/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.thread;

import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.thread.StopThreadServerMsg;
import com.seeyon.ctp.thread.ThreadManager;
import com.seeyon.ctp.thread.ThreadPort;
import com.seeyon.ctp.thread.ThreadRequest;
import com.seeyon.ctp.thread.ThreadValue;
import com.seeyon.ctp.thread.monitor.ThreadMonitor;
import org.apache.commons.logging.Log;

public abstract class ThreadServer
implements Runnable {
    private static final Log LOGGER = CtpLogFactory.getLog(ThreadServer.class);
    protected boolean startFlag = true;
    private Object portName = null;
    private ThreadPort port = null;
    private Object parameter = null;
    protected boolean continueFlag = true;
    protected String threadID = null;
    private String description = "\u540e\u53f0\u670d\u52a1\u7ebf\u7a0b";

    public ThreadPort getPort() {
        return this.port;
    }

    public void setPort(ThreadPort port) {
        this.port = port;
    }

    public Object getPortName() {
        return this.portName;
    }

    public void setPortName(Object portName) {
        this.portName = portName;
    }

    public Object getParameter() {
        return this.parameter;
    }

    public void setParameter(Object parameter) {
        this.parameter = parameter;
    }

    protected void setContinueFlag(boolean continueFlag) {
        this.continueFlag = continueFlag;
    }

    public boolean isContinueFlag() {
        return this.continueFlag;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getThreadID() {
        return this.threadID;
    }

    public boolean isStartFlag() {
        return this.startFlag;
    }

    public void setStartFlag(boolean startFlag) {
        this.startFlag = startFlag;
    }

    @Override
    public void run() {
        LOGGER.info((Object)("\u542f\u52a8\u7ebf\u7a0b[Thread Server]:" + this.portName));
        this.threadID = ThreadValue.getThreadId();
        try {
            this.init(this.parameter);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u521d\u59cb\u5316\u7ebf\u7a0b\u53d8\u91cf\u65f6\u9519\u8bef", (Throwable)e);
            return;
        }
        ThreadManager.getInstance().register(this.portName, this.port);
        ThreadRequest request = null;
        while (this.continueFlag) {
            try {
                request = this.port.getRequest();
            }
            catch (InterruptedException e) {
                try {
                    LOGGER.info((Object)("\u7ebf\u7a0b[" + this.description + "]\u5df2\u7ecf\u7ec8\u6b62"));
                }
                catch (Throwable ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            catch (Throwable ex) {
                LOGGER.error((Object)("\u7ebf\u7a0b[" + this.description + "]\u53d6\u8bf7\u6c42\u6570\u636e\u5305\u65f6\u9519\u8bef"), ex);
                continue;
            }
            if (request == null) {
                return;
            }
            try {
                Object rst = null;
                Object data = request.getData();
                if (data instanceof StopThreadServerMsg) {
                    this.continueFlag = false;
                    this.destroy();
                    ThreadManager.getInstance().remove(this.portName);
                    continue;
                }
                this.service(data);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable ex) {
                LOGGER.error((Object)ex.getLocalizedMessage(), ex);
            }
        }
        ThreadMonitor.stopMonitor();
        LOGGER.info((Object)("\u7ebf\u7a0b:" + this.description + "\u5df2\u7ecf\u7ec8\u6b62"));
    }

    protected abstract void init(Object var1) throws Exception;

    protected abstract void destroy();

    protected abstract void service(Object var1) throws Exception;
}

