/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.thread;

import com.seeyon.ctp.thread.ThreadPort;
import com.seeyon.ctp.thread.ThreadServer;
import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadManager {
    private ConcurrentHashMap<Object, ThreadPort> pool = new ConcurrentHashMap();
    private static ThreadManager instance = new ThreadManager();

    public static ThreadManager getInstance() {
        return instance;
    }

    private ThreadManager() {
    }

    public void register(Object portName, ThreadPort server) {
        this.pool.put(portName, server);
    }

    public void remove(Object portName) {
        this.pool.remove(portName);
    }

    public ThreadPort getPort(Object portName) {
        return this.pool.get(portName);
    }

    public static ThreadPort startServer(Object portName, Class<?> clazz, Object parameter, String description) throws Exception {
        ThreadPort port = instance.getPort(portName);
        if (port != null) {
            if (clazz.isInstance(port)) {
                return port;
            }
            port.stopService();
        }
        ThreadServer server = null;
        try {
            server = (ThreadServer)clazz.newInstance();
            server.setDescription(description);
        }
        catch (Exception e) {
            throw new Exception("\u7c7b" + clazz.getName() + "\u4e0d\u80fd\u88ab\u5b9e\u4f8b\u5316", e);
        }
        server.setParameter(parameter);
        port = new ThreadPort();
        port.startService(portName, server);
        return port;
    }

    public static ThreadPort startServer(Object portName, Class<?> clazz, Object parameter, String description, int threadCount) throws Exception {
        ThreadPort port = instance.getPort(portName);
        if (port != null) {
            if (clazz.isInstance(port)) {
                return port;
            }
            port.stopService();
        }
        ThreadServer server = null;
        try {
            Constructor<?> con = clazz.getConstructor(Integer.class);
            server = (ThreadServer)con.newInstance(new Integer(threadCount));
            server.setDescription(description);
        }
        catch (Exception e) {
            throw new Exception("\u7c7b" + clazz.getName() + "\u4e0d\u80fd\u88ab\u5b9e\u4f8b\u5316", e);
        }
        server.setParameter(parameter);
        port = new ThreadPort();
        port.startService(portName, server);
        return port;
    }
}

