/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.startup;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.startup.StartupTask;
import com.seeyon.ctp.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;

public class StartupTaskManager {
    private static Log logger = CtpLogFactory.getLog(StartupTaskManager.class);
    private static final StartupTaskManager INSTANCE = new StartupTaskManager();

    private StartupTaskManager() {
    }

    public static StartupTaskManager getInstance() {
        return INSTANCE;
    }

    public void run() {
        String file = AppContext.getCfgHome() + "/startup/tasks.properties";
        String readTextFile = StartupTaskManager.readTextFile(file);
        logger.info((Object)"startup:scan startup tasks:");
        if (!Strings.isEmpty(readTextFile)) {
            String[] classes;
            for (String className : classes = readTextFile.split("\n")) {
                try {
                    Object instance = Class.forName(className).newInstance();
                    if (instance instanceof StartupTask) {
                        logger.info((Object)("startup:run startup task [" + className + "]"));
                        StartupTask task = (StartupTask)instance;
                        task.run();
                        continue;
                    }
                    logger.error((Object)("startup:invalid startup task [" + className + "] "));
                }
                catch (Throwable e) {
                    logger.error((Object)e.getLocalizedMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(String fileName) {
        StringBuilder sb = new StringBuilder();
        FileInputStream input = null;
        InputStreamReader reader = null;
        BufferedReader breader = null;
        try {
            File file = new File(fileName);
            if (file.exists()) {
                input = new FileInputStream(file);
                reader = new InputStreamReader((InputStream)input, "UTF-8");
                breader = new BufferedReader(reader);
                String line = breader.readLine();
                while (line != null) {
                    sb.append(line).append("\n");
                    line = breader.readLine();
                }
                breader.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(breader);
        }
        return sb.toString();
    }
}

