/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.session;

import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.session.SessionExpiringMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.logging.Log;
import org.springframework.session.MapSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.data.redis.RedisOperationsSessionRepository;

public class CTPSessionRepository
implements SessionRepository {
    private static Log LOG = CtpLogFactory.getLog(CTPSessionRepository.class);
    private int expireInSeconds = 1800;
    public static SessionExpiringMap sessions = new SessionExpiringMap();
    public static Set<String> SESSION_KEY_WHITE_LIST = new ConcurrentSkipListSet<String>();
    private static SessionRepository repository;

    public void setExpireInSeconds(int expireInSeconds) {
        this.expireInSeconds = expireInSeconds;
    }

    public Session createSession() {
        return this.getRepository().createSession();
    }

    public void save(Session paramS) {
        this.getRepository().save(paramS);
    }

    public Session getSession(String paramString) {
        return this.getRepository().getSession(paramString);
    }

    public void delete(String paramString) {
        this.getRepository().delete(paramString);
    }

    private void init() {
        Integer sessionStorageMode = SystemProperties.getInstance().getIntegerProperty("session.storage", 2);
        if (RedisHandler.isRedisEnabled() && sessionStorageMode == 2) {
            try {
                repository = RedisHandler.buildSessionRepository();
                ((RedisOperationsSessionRepository)repository).setDefaultMaxInactiveInterval(this.expireInSeconds);
                if (repository == null) {
                    LOG.error((Object)"\u521d\u59cb\u5316Spring Session Repository\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5Redis\u7684\u76f8\u5173\u914d\u7f6e\uff0c\u91c7\u7528\u666e\u901aSession\u6a21\u5f0f");
                    repository = new MapSessionRepository();
                    ((MapSessionRepository)repository).setDefaultMaxInactiveInterval(this.expireInSeconds);
                }
            }
            catch (Throwable e) {
                LOG.error((Object)("\u521d\u59cb\u5316\u4f1a\u8bdd\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684redis\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff1a" + e.getLocalizedMessage()), e);
            }
        } else {
            repository = new MapSessionRepository();
        }
    }

    public synchronized SessionRepository getRepository() {
        if (repository == null) {
            this.init();
        }
        return repository;
    }

    public static void shutdown() {
        repository = new SessionRepository(){

            public Session createSession() {
                return null;
            }

            public void save(Session paramS) {
            }

            public Session getSession(String paramString) {
                return null;
            }

            public void delete(String paramString) {
            }
        };
    }

    static {
        SESSION_KEY_WHITE_LIST.add("com.seeyon.current_user");
        SESSION_KEY_WHITE_LIST.add("login.result");
        repository = null;
    }
}

