/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.services;

import com.seeyon.ctp.services.ServiceException;
import com.seeyon.ctp.services.ServiceResponse;
import com.seeyon.oainterface.common.OAInterfaceException;

public class ServiceResponseImpl
implements ServiceResponse {
    private long result;
    private long errNumber = 0L;
    private String errMsg;

    public static ServiceResponse getInstance(OAInterfaceException e) {
        return new ServiceResponseImpl(e);
    }

    public static ServiceResponse getInstance(ServiceException e) {
        return new ServiceResponseImpl(e);
    }

    public static ServiceResponse getInstance(long errNumber, String errMsg) {
        return new ServiceResponseImpl(errNumber, errMsg);
    }

    public static ServiceResponse getInstance(long result) {
        return new ServiceResponseImpl(result);
    }

    public static ServiceResponse getInstance() {
        return new ServiceResponseImpl(0L);
    }

    private ServiceResponseImpl(long result) {
        this.result = result;
    }

    private ServiceResponseImpl(long errNumber, String errMsg) {
        this.errNumber = errNumber;
        this.errMsg = errMsg;
    }

    private ServiceResponseImpl(OAInterfaceException e) {
        this.result = -1L;
        this.errNumber = e.getErrcode();
        this.errMsg = e.getUserMsg();
    }

    private ServiceResponseImpl(ServiceException e) {
        this.result = -1L;
        this.errNumber = e.getErrorNumber();
        this.errMsg = e.getMessage();
    }

    @Override
    public long getResult() {
        return this.result;
    }

    @Override
    public String getErrorMessage() {
        return this.errMsg;
    }

    @Override
    public long getErrorNumber() {
        return this.errNumber;
    }
}

