/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.monitor;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.login.online.OnlineRecorder;
import com.seeyon.ctp.monitor.domain.CurrentStatus;
import com.seeyon.ctp.monitor.domain.MonitorConfig;
import com.seeyon.ctp.monitor.domain.Threshold;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.XMLCoder;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.modeler.Registry;

public class AppStatus
extends Thread {
    private static Log log = CtpLogFactory.getLog(AppStatus.class);
    private Threshold threshold = new Threshold();
    private List flightLog = new ArrayList();

    public AppStatus(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            OutputStreamWriter fileWirter = null;
            BufferedWriter bin = null;
            try {
                AppStatus.sleep(MonitorConfig.getIntervalTimems());
                this.status();
                fileWirter = new FileWriter(MonitorConfig.getFilePath() + "perflog_" + Datetimes.format(new Date(), "yyyy-MM-dd", Locale.getDefault()) + ".xml", false);
                bin = new BufferedWriter(fileWirter);
                bin.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?> <PerfMetrics>");
                bin.write(XMLCoder.encoder(this.threshold));
                bin.write(XMLCoder.encoder(this.flightLog));
                bin.write("</PerfMetrics>");
                bin.flush();
                bin.close();
                continue;
            }
            catch (IOException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                continue;
            }
            catch (InterruptedException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                continue;
            }
            finally {
                if (fileWirter != null) {
                    try {
                        fileWirter.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (bin == null) continue;
                try {
                    bin.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                continue;
            }
            break;
        }
    }

    private void status() {
        try {
            CurrentStatus status = new CurrentStatus();
            status.setOnlineUsersCount4PC(OnlineRecorder.getOnlineUserNumber4Server());
            status.setOnlineUsersCount4M1(OnlineRecorder.getOnlineUserNumber4M1());
            MBeanServer mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
            Set<ObjectInstance> set = mBeanServer.queryMBeans(new ObjectName("*:type=ThreadPool,*"), null);
            for (ObjectInstance oi : set) {
                ObjectName objectName = oi.getObjectName();
                if ("http-80".equals(objectName.getKeyProperty("name"))) {
                    this.threshold.setMaxThreadsCount4Http(((Integer)mBeanServer.getAttribute(objectName, "maxThreads")).intValue());
                    status.setBusyThreadsCount4Http(((Integer)mBeanServer.getAttribute(objectName, "currentThreadsBusy")).intValue());
                } else if ("jk-8951".equals(objectName.getKeyProperty("name"))) {
                    this.threshold.setMaxThreadsCount4Ajp(((Integer)mBeanServer.getAttribute(objectName, "maxThreads")).intValue());
                    status.setBusyThreadsCount4Ajp(((Integer)mBeanServer.getAttribute(objectName, "currentThreadsBusy")).intValue());
                }
                if (status.getOnlineUsersCount4PC() <= 10L || status.getBusyThreadsCount4Ajp() <= status.getOnlineUsersCount4PC() && status.getBusyThreadsCount4Http() <= status.getOnlineUsersCount4PC()) continue;
                log.warn((Object)("\u5f53\u524d\u7e41\u5fd9\u7ebf\u7a0b\u76f8\u5bf9\u8fc7\u9ad8\uff01http\u7ebf\u7a0b\u6570\uff1a" + status.getBusyThreadsCount4Http() + "\uff0cAJP\u7ebf\u7a0b\u6570\uff1a" + status.getBusyThreadsCount4Ajp()));
                this.dumpThread(Datetimes.format(new Date(), "yy-MM-dd HHmmss", Locale.getDefault()));
            }
            status.setProcessCpuTime((Long)mBeanServer.getAttribute(new ObjectName("java.lang:type=OperatingSystem"), "ProcessCpuTime"));
            List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
                MemoryUsage memoryUsage = memoryPoolMXBean.getUsage();
                if ("CMS Old Gen".equals(memoryPoolMXBean.getName())) {
                    this.threshold.setMaxOldGenBytes(memoryUsage.getMax());
                    status.setOldGenBytes(memoryUsage.getUsed());
                    continue;
                }
                if (!"CMS Perm Gen".equals(memoryPoolMXBean.getName())) continue;
                this.threshold.setMaxPermGenBytes(memoryUsage.getMax());
                status.setPermGenBytes(memoryUsage.getUsed());
            }
            List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean garbageCollectorMXBean : garbageCollectorMXBeans) {
                if (!"ConcurrentMarkSweep".equals(garbageCollectorMXBean.getName())) continue;
                status.setFullGcTime(garbageCollectorMXBean.getCollectionTime());
                status.setFullGCCount(garbageCollectorMXBean.getCollectionCount());
            }
            this.flightLog.add(status);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpThread(String tag) {
        BufferedWriter bin = null;
        try {
            ThreadInfo[] tinfos;
            FileWriter fileWirter = new FileWriter(MonitorConfig.getFilePath() + "threaddump_" + tag + ".txt", false);
            bin = new BufferedWriter(fileWirter);
            ThreadMXBean tmbean = ManagementFactory.getThreadMXBean();
            long[] tids = tmbean.getAllThreadIds();
            for (ThreadInfo ti : tinfos = tmbean.getThreadInfo(tids, Integer.MAX_VALUE)) {
                bin.write("\"" + ti.getThreadName() + "\" Id=" + ti.getThreadId() + " in " + (Object)((Object)ti.getThreadState()));
                if (ti.getLockName() != null) {
                    bin.write(" on lock=" + ti.getLockName());
                }
                if (ti.isSuspended()) {
                    bin.write(" (suspended)");
                }
                if (ti.isInNative()) {
                    bin.write(" (running in native)");
                }
                if (ti.getLockOwnerName() != null) {
                    bin.write("     owned by " + ti.getLockOwnerName() + " Id=" + ti.getLockOwnerId());
                }
                bin.write("\n");
                StackTraceElement[] stacktrace = ti.getStackTrace();
                for (int i = 0; i < stacktrace.length; ++i) {
                    StackTraceElement ste = stacktrace[i];
                    bin.write("    at " + ste.toString() + "\n");
                }
            }
            bin.flush();
        }
        catch (IOException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }
}

