/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.event;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.event.FireEventThread;
import com.seeyon.ctp.thread.monitor.ThreadMonitor;
import com.seeyon.ctp.thread.single.SingleThread;
import com.seeyon.ctp.thread.trace.RuntimeData;
import org.apache.commons.logging.Log;

public class EventMonitor
extends SingleThread {
    private static final Log LOGGER = CtpLogFactory.getLog(EventMonitor.class);
    private static final long serialVersionUID = 6569791303821003442L;

    @Override
    protected void init() {
    }

    @Override
    public String getDescription() {
        return "\u4e8b\u4ef6\u76d1\u63a7\u5b88\u62a4";
    }

    @Override
    protected void doService() throws InterruptedException {
        Thread.sleep(3000L);
        RuntimeData[] list = ThreadMonitor.getEventThreadList();
        if (list == null || list.length == 0) {
            return;
        }
        LOGGER.info((Object)("--\u5f53\u524d\u5e76\u53d1\u8fd0\u884c\u4e8b\u4ef6\u6570\uff1a" + list.length + ";--"));
        for (RuntimeData d : list) {
            if (d.getActionCode() == null || d.getActionCode().compareTo("event_thread_server") != 0) continue;
            LOGGER.info((Object)("\u52a8\u4f5c\uff1a" + d.getActionCode()));
            LOGGER.info((Object)("\u89e6\u53d1\u4fe1\u606f\uff1a" + d.getTraceInfo()));
            LOGGER.info((Object)("\u8c03\u7528\u4fe1\u606f\uff1a" + ((FireEventThread)d.getProcessObject()).getEvent().getClass().getCanonicalName()));
            LOGGER.info((Object)("\u7ebf\u7a0b\u53f7\uff1a" + d.getThreadId()));
            LOGGER.info((Object)("\u5f53\u524d\u8017\u65f6\uff1a" + (System.currentTimeMillis() - d.getBeginTime())));
        }
    }
}

