/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.event;

import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.cache.redis.RedisNotification;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.event.EventDispatcher;
import org.apache.commons.logging.Log;

public class DistributedEventHandler {
    private static final Log logger = CtpLogFactory.getLog(DistributedEventHandler.class);

    public void fireEvent(Event event) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("--- \u6536\u5230\u5206\u5e03\u5f0f\u4e8b\u4ef6\uff1a" + event));
            }
            EventDispatcher.stopDispatching();
            EventDispatcher.fireEvent(event);
        }
        finally {
            EventDispatcher.continueDispatching();
        }
    }

    public void handleRedisNotification(RedisNotification notification) {
        try {
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("--- \u6536\u5230\u5206\u5e03\u5f0f\u6d88\u606f\u901a\u77e5\uff1a" + notification));
            }
            RedisHandler.stopCacheReadOnly();
            RedisHandler.stopDispatch();
            RedisHandler.handleNotify(notification);
        }
        finally {
            RedisHandler.recoverCacheReadonly();
            RedisHandler.continueDispatch();
        }
    }
}

