/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.dubbo;

import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.BeansOfTypeListener;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.dubbo.RefreshInterfacesAfterUpdate;
import com.seeyon.ctp.util.annotation.AnnotationAware;
import com.seeyon.ctp.util.annotation.AnnotationFactory;
import com.seeyon.ctp.util.annotation.MethodAnnotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RefreshInterfaceAfterUpdateAnnotationAware
extends AbstractSystemInitializer
implements AnnotationAware {
    private static final Log logger = LogFactory.getLog(RefreshInterfaceAfterUpdateAnnotationAware.class);
    private AnnotationFactory annotationFactory;
    private Map<Class, Map<Method, Object>> allListens = new ConcurrentHashMap<Class, Map<Method, Object>>();

    @Override
    public void setAnnotationFactory(AnnotationFactory annotationFactory) {
        this.annotationFactory = annotationFactory;
    }

    @Override
    public void initialize() {
        if (!SystemEnvironment.isDistributedMode()) {
            return;
        }
        BeansOfTypeListener beansOfTypeListener = new BeansOfTypeListener(){

            @Override
            public void onChange(Class clazz) {
                Map listens = (Map)RefreshInterfaceAfterUpdateAnnotationAware.this.allListens.get(clazz);
                if (listens != null) {
                    for (Map.Entry entry : listens.entrySet()) {
                        try {
                            ((Method)entry.getKey()).invoke(entry.getValue(), new Object[0]);
                        }
                        catch (Exception e) {
                            logger.error((Object)"\u6267\u884cbeansOfByte\u5237\u65b0\u53d1\u751f\u9519\u8bef", (Throwable)e);
                        }
                    }
                }
            }
        };
        Set<MethodAnnotation> methodAnnotation = this.annotationFactory.getAnnotationOfMethod(RefreshInterfacesAfterUpdate.class);
        if (methodAnnotation != null) {
            for (MethodAnnotation annotation : methodAnnotation) {
                if (!(annotation.getAnnotation() instanceof RefreshInterfacesAfterUpdate)) continue;
                try {
                    RefreshInterfacesAfterUpdate anno = (RefreshInterfacesAfterUpdate)annotation.getAnnotation();
                    Object target = AppContext.getBean(annotation.getBeanName());
                    if (target != null) {
                        Map<Method, Object> interfaceListens = this.allListens.get(anno.inface());
                        if (interfaceListens == null) {
                            interfaceListens = new ConcurrentHashMap<Method, Object>();
                            this.allListens.put(anno.inface(), interfaceListens);
                            AppContext.addBeansOfTypeListener(anno.inface(), beansOfTypeListener);
                        }
                        interfaceListens.put(annotation.getMethod(), target);
                        continue;
                    }
                    logger.warn((Object)("Spring\u5bb9\u5668\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230bean[\"" + annotation.getBeanName() + "\"], RefreshInterfacesAfterUpdate\u6ce8\u89e3\u89e3\u6790\u5ffd\u7565\uff01"));
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

