/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.dubbo;

import com.alibaba.dubbo.config.spring.ReferenceBean;
import com.alibaba.dubbo.config.spring.ServiceBean;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public class DubboServiceContext {
    private static final Log logger = CtpLogFactory.getLog(DubboServiceContext.class);
    private static boolean initialized = false;
    private static final String DUBBO_GROUP_INTERFACE_NAMES = "META-INF/dubbo/group.interface.names";
    private static final Set<Class> groupInterfaces = new HashSet<Class>();
    private static final Map<String, Class> providerInterfaceMap = new ConcurrentHashMap<String, Class>();
    private static final Map<Class<?>, Map<String, ?>> beansOfTypeCacheMap = new ConcurrentHashMap();
    private static final Map<String, Object> beansMap = new ConcurrentHashMap<String, Object>();
    private static final Pattern dubboUrlPattern = Pattern.compile("dubbo://(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}):(\\d{1,5})\\S+&group=(\\w+)\\S+");

    public static synchronized void initBeforeSpring() {
        if (groupInterfaces.size() > 0) {
            return;
        }
        try {
            DubboServiceContext.fillGroupInterfaceNames();
        }
        catch (Throwable t) {
            logger.error((Object)"initBeforeSpring \u5931\u8d25", t);
        }
    }

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        try {
            logger.info((Object)"DubboServiceContext \u521d\u59cb\u5316\uff0c\u7528\u4e8e\u53d1\u5e03/\u83b7\u53d6/\u76d1\u542c BeansOfType \u63a5\u53e3 ...");
            DubboServiceContext.publishService();
            DubboServiceContext.pullRegistedService();
            DubboServiceContext.subscribeServiceRegister();
            initialized = true;
            logger.info((Object)"DubboServiceContext \u521d\u59cb\u5316\u5b8c\u6210");
        }
        catch (Throwable t) {
            logger.error((Object)"DubboServiceContext \u521d\u59cb\u5316\u5931\u8d25", t);
        }
    }

    private static void publishService() {
        for (Class clazz : groupInterfaces) {
            logger.warn((Object)("process group interface[" + clazz.getName() + "]"));
            Map groupClazzs = AppContext.getBeansOfType(clazz);
            int index = 0;
            if (groupClazzs == null) continue;
            for (Map.Entry entry : groupClazzs.entrySet()) {
                DubboServiceContext.publishDubboService(clazz, SystemEnvironment.getAppId() + "_" + index++, entry.getValue());
            }
        }
    }

    private static void pullRegistedService() {
        for (String dubboServiceKey : providerInterfaceMap.keySet()) {
            DubboServiceContext.refreshInterface(dubboServiceKey);
        }
    }

    private static void fillGroupInterfaceNames() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(DubboServiceContext.class.getClassLoader().getResourceAsStream(DUBBO_GROUP_INTERFACE_NAMES)));
        String interfaceName = null;
        while ((interfaceName = reader.readLine()) != null) {
            if (Strings.isBlank(interfaceName)) continue;
            try {
                Class<?> clazz = Class.forName(interfaceName);
                if (!clazz.isInterface()) {
                    logger.warn((Object)("\u5ffd\u7565\u5206\u7ec4\u63a5\u53e3\u6ce8\u518c\uff0c\u539f\u56e0\uff1a" + interfaceName + "\u4e0d\u662f\u63a5\u53e3\u7c7b\u578b"));
                    continue;
                }
                groupInterfaces.add(clazz);
                providerInterfaceMap.put("/dubbo/" + interfaceName + "/providers", clazz);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("\u5ffd\u7565\u5206\u7ec4\u63a5\u53e3\u6ce8\u518c\uff0c\u539f\u56e0\uff1a" + interfaceName + " \u4e0d\u5b58\u5728"));
            }
        }
    }

    private static void refreshInterface(String dubboServiceKey) {
        Map keyValue = RedisHandler.getDubboRedisTemplate().opsForHash().entries((Object)dubboServiceKey);
        for (Map.Entry entry : keyValue.entrySet()) {
            if (Long.parseLong((String)entry.getValue()) < System.currentTimeMillis() - 60000L) continue;
            String dubboUrl = (String)entry.getKey();
            try {
                Matcher matcher = dubboUrlPattern.matcher(dubboUrl);
                if (matcher.matches()) {
                    if (matcher.groupCount() <= 2) continue;
                    String serviceIp = matcher.group(1);
                    int servicePort = Integer.parseInt(matcher.group(2));
                    String group = matcher.group(3);
                    if (group.split("_")[0].equals(SystemEnvironment.getAppId())) continue;
                    Class clazz = providerInterfaceMap.get(dubboServiceKey);
                    if (clazz == null) {
                        logger.error((Object)(dubboServiceKey + "\u4e0d\u5b58\u5728"));
                        continue;
                    }
                    if (beansOfTypeCacheMap.get(clazz) != null && beansOfTypeCacheMap.get(clazz).containsKey(clazz.getSimpleName() + "_" + group)) continue;
                    DubboServiceContext.fillTypeBean(clazz, group);
                    continue;
                }
                logger.info((Object)("\u683c\u5f0f\u4e0d\u89c4\u8303\u7684dubboUrl\uff1a" + (String)entry.getKey()));
            }
            catch (Exception e) {
                logger.error((Object)("\u89e3\u6790dubboUrl[" + dubboUrl + "]\u51fa\u9519"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillTypeBean(Class clazz, String group) {
        Class clazz2 = clazz;
        synchronized (clazz2) {
            Map<String, ?> beans = beansOfTypeCacheMap.get(clazz);
            if (beans == null) {
                beans = new ConcurrentHashMap();
                beansOfTypeCacheMap.put(clazz, beans);
            }
            ReferenceBean referenceBean = new ReferenceBean();
            referenceBean.setApplicationContext(AppContext.getApplicationContext());
            referenceBean.setInterface(clazz);
            referenceBean.setGroup(group);
            referenceBean.setMock("return empty");
            try {
                referenceBean.afterPropertiesSet();
                String beanId = clazz.getSimpleName() + "_" + group;
                Object bean = referenceBean.get();
                beans.put(beanId, bean);
                logger.warn((Object)("\u6ce8\u5165\u8fdc\u7a0b\u5206\u7ec4\u63a5\u53e3\u670d\u52a1 " + beanId));
                beansMap.put(beanId, bean);
                AppContext.clearBeansOfType(clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void publishDubboService(Class clazz, String group, Object obj) {
        ServiceBean serviceBean = new ServiceBean();
        serviceBean.setApplicationContext(AppContext.getApplicationContext());
        serviceBean.setInterface(clazz);
        serviceBean.setRef(obj);
        serviceBean.setGroup(group);
        serviceBean.setApplicationEventPublisher((ApplicationEventPublisher)AppContext.getApplicationContext());
        try {
            serviceBean.afterPropertiesSet();
            serviceBean.export();
            logger.warn((Object)("publishing group interface service [" + clazz.getName() + "(" + group + ")]"));
        }
        catch (Exception e) {
            logger.error((Object)"publish dubbo service error", (Throwable)e);
        }
    }

    private static void subscribeServiceRegister() {
        if (providerInterfaceMap.size() == 0) {
            logger.warn((Object)"\u6ca1\u6709\u9700\u8981\u8ba2\u9605\u7684dubbo\u670d\u52a1\u63a5\u53e3");
            return;
        }
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                byte[][] channels = new byte[providerInterfaceMap.size()][];
                int i = 0;
                for (String dubboServiceKey : providerInterfaceMap.keySet()) {
                    channels[i++] = dubboServiceKey.getBytes();
                }
                RedisHandler.getDubboRedisTemplate().getConnectionFactory().getConnection().subscribe(new MessageListener(){

                    public void onMessage(Message message, byte[] pattern) {
                        if ("register".equals(new String(message.getBody()))) {
                            DubboServiceContext.refreshInterface(new String(message.getChannel()));
                        }
                    }
                }, (byte[][])channels);
            }
        });
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        if (!groupInterfaces.contains(type)) {
            return Collections.emptyMap();
        }
        Map<String, ?> result = beansOfTypeCacheMap.get(type);
        if (result == null) {
            return Collections.emptyMap();
        }
        return result;
    }

    public static Object getBean(String beanId) {
        return beansMap.get(beanId);
    }

    public static boolean isGroupInterface(String interfaceName) {
        return providerInterfaceMap.containsKey("/dubbo/" + interfaceName + "/providers");
    }
}

