/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.dubbo;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.config.PlatformAppEnum;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.dubbo.DubboServiceContext;
import com.seeyon.ctp.util.StringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.logging.Log;

public class DubboConfigAutoGenerator {
    private static final Log logger = CtpLogFactory.getLog(DubboConfigAutoGenerator.class);
    private static final String DUBBO_CONSUMER_XML = "spring-dubbo-consumer.xml";
    private static final String DUBBO_PROVIDER_XML = "spring-dubbo-provider.xml";
    private static final String APPS_API_JAR_NAME = "seeyon-apps-api.jar";
    private static final Set<String> specialJarNames = new HashSet<String>();
    private static final Map<PlatformAppEnum, Set<String>> specialInterfaceMap = new ConcurrentHashMap<PlatformAppEnum, Set<String>>();
    private static final Set<String> excludJarNames = new HashSet<String>();
    private static final Set<String> excludInterfaceNames = new HashSet<String>();
    private static final Set<String> existsAppIds = new HashSet<String>();
    private static final Map<String, String> beanNamesMap = new ConcurrentHashMap<String, String>();
    private static final Pattern pattern;
    private static final FilenameFilter providerApiFilter;

    public static void generatorDubboConfigFiles(String configDirPath, String libDirPath) {
        File[] apiJars;
        File[] appsJars;
        final Pattern appsPattern = Pattern.compile("seeyon-apps-\\w+\\.jar");
        File libDir = new File(libDirPath);
        HashSet<String> cInterfaces = new HashSet<String>();
        HashSet<String> pInterfaces = new HashSet<String>();
        for (File appsJar : appsJars = libDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return appsPattern.matcher(name).matches() && !name.equalsIgnoreCase(DubboConfigAutoGenerator.APPS_API_JAR_NAME);
            }
        })) {
            existsAppIds.add(appsJar.getName().substring(12).replaceAll("\\.jar", ""));
        }
        for (File file : apiJars = libDir.listFiles(providerApiFilter)) {
            try {
                DubboConfigAutoGenerator.obtainInterfacesFromJar(file, cInterfaces, pInterfaces);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File configDir = new File(configDirPath);
        try {
            DubboConfigAutoGenerator.createProviderFile(configDir, pInterfaces);
            DubboConfigAutoGenerator.createConsumerFile(configDir, cInterfaces);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    private static void createProviderFile(File configDir, Set<String> pInterfaces) throws ConfigurationException {
        if (configDir == null || !configDir.exists() || !configDir.isDirectory()) {
            logger.error((Object)"configDir \u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        File configFile = new File(configDir.getPath() + File.separator + DUBBO_PROVIDER_XML);
        XMLConfiguration providerXML = new XMLConfiguration(configFile);
        HierarchicalConfiguration.Node rootNode = providerXML.getRoot();
        rootNode.remove("dubbo:service");
        rootNode.remove("bean");
        if ("1".equals(SystemProperties.getInstance().getProperty("ctp.zipkin.enabled"))) {
            DubboConfigAutoGenerator.addZipkinBeans(rootNode);
        }
        for (String className : pInterfaces) {
            HierarchicalConfiguration.Node serviceNode = new HierarchicalConfiguration.Node("dubbo:service");
            HierarchicalConfiguration.Node nameAttri = new HierarchicalConfiguration.Node("interface", (Object)className);
            serviceNode.addAttribute((ConfigurationNode)nameAttri);
            String ref = null;
            String smartClassName = className.substring(className.lastIndexOf(".") + 1);
            ref = "com.seeyon.ctp.common.content.comment.CommentManager".equals(className) || "com.seeyon.ctp.common.content.mainbody.MainbodyManager".equals(className) ? "ctp" + className.substring(className.lastIndexOf(".") + 1) : (beanNamesMap.containsKey(smartClassName) ? beanNamesMap.get(smartClassName) : StringUtil.firstCharLower(smartClassName));
            HierarchicalConfiguration.Node refAttri = new HierarchicalConfiguration.Node("ref", (Object)ref);
            serviceNode.addAttribute((ConfigurationNode)refAttri);
            rootNode.addChild(serviceNode);
        }
        providerXML.save();
    }

    private static void addZipkinBeans(HierarchicalConfiguration.Node rootNode) {
        HierarchicalConfiguration.Node beanNode = new HierarchicalConfiguration.Node("bean");
        beanNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("id", (Object)"sender"));
        beanNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("class", (Object)"zipkin2.reporter.beans.OkHttpSenderFactoryBean"));
        HierarchicalConfiguration.Node propertyNode = new HierarchicalConfiguration.Node("property");
        propertyNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("name", (Object)"endpoint"));
        propertyNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("value", (Object)"${ctp.zipkin.url}"));
        beanNode.addChild(propertyNode);
        rootNode.addChild(beanNode);
        HierarchicalConfiguration.Node tracingNode = new HierarchicalConfiguration.Node("bean");
        tracingNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("id", (Object)"tracing"));
        tracingNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("class", (Object)"brave.spring.beans.TracingFactoryBean"));
        HierarchicalConfiguration.Node serviceNamePNode = new HierarchicalConfiguration.Node("property");
        serviceNamePNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("name", (Object)"localServiceName"));
        serviceNamePNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("value", (Object)"${ctp.moduleName}"));
        tracingNode.addChild(serviceNamePNode);
        HierarchicalConfiguration.Node reporterPNode = new HierarchicalConfiguration.Node("property");
        reporterPNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("name", (Object)"spanReporter"));
        HierarchicalConfiguration.Node reporterBean = new HierarchicalConfiguration.Node("bean");
        reporterBean.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("class", (Object)"zipkin2.reporter.beans.AsyncReporterFactoryBean"));
        HierarchicalConfiguration.Node reporterPNode1 = new HierarchicalConfiguration.Node("property");
        reporterPNode1.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("name", (Object)"sender"));
        reporterPNode1.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("ref", (Object)"sender"));
        reporterBean.addChild(reporterPNode1);
        HierarchicalConfiguration.Node reporterPNode2 = new HierarchicalConfiguration.Node("property");
        reporterPNode2.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("name", (Object)"closeTimeout"));
        reporterPNode2.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("value", (Object)"500"));
        reporterBean.addChild(reporterPNode2);
        reporterPNode.addChild(reporterBean);
        tracingNode.addChild(reporterPNode);
        HierarchicalConfiguration.Node contextPNode = new HierarchicalConfiguration.Node("property");
        contextPNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("name", (Object)"currentTraceContext"));
        HierarchicalConfiguration.Node contextBean = new HierarchicalConfiguration.Node("bean");
        contextBean.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("class", (Object)"brave.spring.beans.CurrentTraceContextFactoryBean"));
        HierarchicalConfiguration.Node contextPChildNode = new HierarchicalConfiguration.Node("property");
        contextPChildNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("name", (Object)"scopeDecorators"));
        contextBean.addChild(contextPChildNode);
        HierarchicalConfiguration.Node decorateBean = new HierarchicalConfiguration.Node("bean");
        decorateBean.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("class", (Object)"brave.context.slf4j.MDCScopeDecorator"));
        decorateBean.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("factory-method", (Object)"create"));
        contextPChildNode.addChild(decorateBean);
        contextPNode.addChild(contextBean);
        tracingNode.addChild(contextPNode);
        rootNode.addChild(tracingNode);
    }

    private static void createConsumerFile(File configDir, Set<String> cInterfaces) throws ConfigurationException {
        if (configDir == null || !configDir.exists() || !configDir.isDirectory()) {
            logger.error((Object)"configDir \u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        File configFile = new File(configDir.getPath() + File.separator + DUBBO_CONSUMER_XML);
        XMLConfiguration consumerXML = new XMLConfiguration(configFile);
        HierarchicalConfiguration.Node rootNode = consumerXML.getRoot();
        rootNode.remove("dubbo:reference");
        for (String className : cInterfaces) {
            HierarchicalConfiguration.Node serviceNode = new HierarchicalConfiguration.Node("dubbo:reference");
            String consumerId = null;
            String smartClassName = className.substring(className.lastIndexOf(".") + 1);
            consumerId = "com.seeyon.ctp.common.content.comment.CommentManager".equals(className) || "com.seeyon.ctp.common.content.mainbody.MainbodyManager".equals(className) ? "ctp" + smartClassName : (beanNamesMap.containsKey(smartClassName) ? beanNamesMap.get(smartClassName) : StringUtil.firstCharLower(smartClassName));
            HierarchicalConfiguration.Node idAttri = new HierarchicalConfiguration.Node("id", (Object)consumerId);
            serviceNode.addAttribute((ConfigurationNode)idAttri);
            HierarchicalConfiguration.Node interfaceAttri = new HierarchicalConfiguration.Node("interface", (Object)className);
            serviceNode.addAttribute((ConfigurationNode)interfaceAttri);
            if (!"formApi4Cap3".equals(consumerId)) {
                HierarchicalConfiguration.Node mockAttri = new HierarchicalConfiguration.Node("mock", (Object)"return empty");
                serviceNode.addAttribute((ConfigurationNode)mockAttri);
            }
            rootNode.addChild(serviceNode);
        }
        consumerXML.save();
    }

    private static HierarchicalConfiguration.Node generateDubboRootNode() {
        HierarchicalConfiguration.Node dubboBeansNode = new HierarchicalConfiguration.Node();
        DefaultConfigurationNode attr = new DefaultConfigurationNode("xmlns");
        attr.setValue((Object)"http://www.springframework.org/schema/beans");
        dubboBeansNode.addAttribute((ConfigurationNode)attr);
        return dubboBeansNode;
    }

    private static void obtainInterfacesFromJar(File file, Set<String> cInterfaces, Set<String> pInterfaces) throws IOException {
        File dir = file.getParentFile();
        String fileName = file.getName();
        boolean isProvider = false;
        boolean isSpeical = specialJarNames.contains(fileName);
        boolean isAppsApi = fileName.equalsIgnoreCase(APPS_API_JAR_NAME);
        if (!isSpeical && !isAppsApi) {
            final String prefix = fileName.substring(0, fileName.length() - 8);
            int count = 0;
            count = "seeyon-cap".equals(prefix) ? dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return "seeyon-cap-core.jar".equals(name);
                }
            }).length + 1 : dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix);
                }
            }).length;
            isProvider = count > 1;
        } else if (isSpeical && SystemEnvironment.isBaseService()) {
            isProvider = true;
        }
        JarFile jar = new JarFile(file);
        Enumeration<JarEntry> entry = jar.entries();
        while (entry.hasMoreElements()) {
            String className;
            block10: {
                JarEntry jarEntry = entry.nextElement();
                String name = jarEntry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (jarEntry.isDirectory() || (!isSpeical ? !pattern.matcher(name).matches() && !DubboConfigAutoGenerator.isSpecialAppsInterface(fileName, name) : !specialInterfaceMap.get((Object)PlatformAppEnum.Base).contains(name) && !pattern.matcher(name).matches())) continue;
                className = name.substring(0, name.length() - 6).replace("/", ".");
                if (excludInterfaceNames.contains(className) || DubboServiceContext.isGroupInterface(className)) continue;
                try {
                    if (!DubboConfigAutoGenerator.class.getClassLoader().loadClass(className).isInterface()) {
                    }
                    break block10;
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)(className + "can't found "), (Throwable)e);
                }
                continue;
            }
            if (isAppsApi) {
                isProvider = existsAppIds.contains(className.replaceAll("\\.api[\\.\\w]+", "").substring(16));
            }
            if (isProvider) {
                pInterfaces.add(className);
                continue;
            }
            cInterfaces.add(className);
        }
    }

    private static boolean isSpecialAppsInterface(String fileName, String name) {
        if (fileName.equals("seeyon-ctp-message-api.jar")) {
            return specialInterfaceMap.get((Object)PlatformAppEnum.Message).contains(name);
        }
        if (fileName.equals("seeyon-ctp-workflow-api.jar")) {
            return specialInterfaceMap.get((Object)PlatformAppEnum.Workflow).contains(name);
        }
        if (fileName.equals("seeyon-cap-api.jar")) {
            return specialInterfaceMap.get((Object)PlatformAppEnum.Cap).contains(name);
        }
        if (fileName.equals("seeyon-ctp-report-api.jar")) {
            return specialInterfaceMap.get((Object)PlatformAppEnum.Report).contains(name);
        }
        if (fileName.equals("seeyon-ctp-portal-api.jar")) {
            return specialInterfaceMap.get((Object)PlatformAppEnum.Base).contains(name);
        }
        return false;
    }

    static {
        specialJarNames.add("seeyon-ctp-common.jar");
        specialJarNames.add("seeyon-ctp-core.jar");
        specialJarNames.add("seeyon-ctp-organization.jar");
        HashSet<String> baseInterfaceNames = new HashSet<String>();
        baseInterfaceNames.add("com/seeyon/ctp/common/config/AppUrlReport.class");
        baseInterfaceNames.add("com/seeyon/apps/agent/manager/AgentIntercalateManager.class");
        baseInterfaceNames.add("com/seeyon/apps/common/isignaturehtml/manager/ISignatureHtmlManager.class");
        baseInterfaceNames.add("com/seeyon/apps/system/signet/manager/CtpSignetManager.class");
        baseInterfaceNames.add("com/seeyon/ctp/common/office/manager/OfficeBakFileManager.class");
        baseInterfaceNames.add("com/seeyon/ctp/common/office/HandWriteManager.class");
        baseInterfaceNames.add("com/seeyon/ctp/common/office/HtmlHandWriteManager.class");
        baseInterfaceNames.add("com/seeyon/ctp/common/office/MSignatureManager.class");
        baseInterfaceNames.add("com/seeyon/ctp/common/office/OfficeLockManager.class");
        baseInterfaceNames.add("com/seeyon/ctp/login/LoginControl.class");
        baseInterfaceNames.add("com/seeyon/v3x/contentTemplate/manager/ContentTemplateManager.class");
        baseInterfaceNames.add("com/seeyon/v3x/isearch/manager/ISearchManager.class");
        baseInterfaceNames.add("com/seeyon/v3x/isearch/manager/ISearchRegisterManager.class");
        baseInterfaceNames.add("com/seeyon/v3x/system/signet/manager/SignetManager.class");
        baseInterfaceNames.add("com/seeyon/v3x/system/signet/manager/V3xHtmDocumentSignatManager.class");
        baseInterfaceNames.add("com/seeyon/v3x/worktimeset/manager/WorkTimeManager.class");
        baseInterfaceNames.add("com/seeyon/v3x/worktimeset/manager/WorkTimeSetManager.class");
        baseInterfaceNames.add("com/seeyon/ctp/login/online/OnlineManager.class");
        baseInterfaceNames.add("com/seeyon/ctp/common/content/mainbody/MainbodyManager.class");
        baseInterfaceNames.add("com/seeyon/ctp/common/content/comment/CommentManager.class");
        baseInterfaceNames.add("com/seeyon/ctp/menu/manager/PluginMenuManager.class");
        baseInterfaceNames.add("com/seeyon/apps/ldap/manager/LdapBindingMgr.class");
        baseInterfaceNames.add("com/seeyon/ctp/portal/space/manager/PortletEntityDataManager.class");
        baseInterfaceNames.add("com/seeyon/v3x/peoplerelate/manager/PeopleRelateManager.class");
        specialInterfaceMap.put(PlatformAppEnum.Base, baseInterfaceNames);
        beanNamesMap.put("AIApi", "aiApi");
        HashSet<String> msgInterfaceNames = new HashSet<String>();
        msgInterfaceNames.add("com/seeyon/ctp/common/usermessage/extended/ExtendedMessageSystemManager.class");
        msgInterfaceNames.add("com/seeyon/v3x/mail/manager/MessageMailManager.class");
        msgInterfaceNames.add("com/seeyon/ctp/common/usermessage/pipeline/MessagePipelineManager.class");
        msgInterfaceNames.add("com/seeyon/ctp/common/usermessage/UserMessageFilterConfigManager.class");
        msgInterfaceNames.add("com/seeyon/v3x/mobile/login/manager/MobileLoginManager.class");
        msgInterfaceNames.add("com/seeyon/v3x/mobile/message/manager/MobileMessageManager.class");
        specialInterfaceMap.put(PlatformAppEnum.Message, msgInterfaceNames);
        HashSet<String> capInterfaceNames = new HashSet<String>();
        capInterfaceNames.add("com/seeyon/ctp/cap/api/manager/CAPFormManager.class");
        capInterfaceNames.add("com/seeyon/ctp/report/chart2/core/ChartRender.class");
        beanNamesMap.put("CAPFormManager", "capFormManager");
        specialInterfaceMap.put(PlatformAppEnum.Cap, capInterfaceNames);
        HashSet<String> colInterfaceNames = new HashSet<String>();
        colInterfaceNames.add("com/seeyon/ctp/common/permission/manager/PermissionLayoutManager.class");
        colInterfaceNames.add("com/seeyon/ctp/common/affair/manager/AffairManager.class");
        colInterfaceNames.add("com/seeyon/ctp/common/affair/manager/PendingManager.class");
        colInterfaceNames.add("com/seeyon/ctp/common/template/manager/TemplateManager.class");
        colInterfaceNames.add("com/seeyon/ctp/common/supervise/manager/SuperviseManager.class");
        colInterfaceNames.add("com/seeyon/ctp/common/permission/manager/PermissionManager.class");
        colInterfaceNames.add("com/seeyon/ctp/common/track/manager/CtpTrackMemberManager.class");
        beanNamesMap.put("WorkflowApiManager", "wapi");
        beanNamesMap.put("CtpTrackMemberManager", "trackManager");
        specialInterfaceMap.put(PlatformAppEnum.Workflow, colInterfaceNames);
        HashSet<String> reportInterfaceNames = new HashSet<String>();
        reportInterfaceNames.add("com/seeyon/ctp/report/category/manager/ReportCategoryManager.class");
        specialInterfaceMap.put(PlatformAppEnum.Report, reportInterfaceNames);
        beanNamesMap.put("VReportApi", "vreportApi");
        beanNamesMap.put("NCMobileApi", "ncMobileApi");
        beanNamesMap.put("NCPluginApi", "ncPluginApi");
        excludInterfaceNames.add("com.seeyon.ctp.report.engine.api.interfaces.DataSource");
        pattern = Pattern.compile("com/seeyon(/\\w+)+/w?api(/\\w+)+\\.class");
        providerApiFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean isApiJar = name.endsWith("-api.jar");
                isApiJar &= name.startsWith("seeyon-");
                isApiJar |= specialJarNames.contains(name);
                return isApiJar &= !excludJarNames.contains(name);
            }
        };
    }
}

