/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.ws;

import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.services.security.ServiceManager;
import com.seeyon.ctp.util.Strings;
import com.seeyon.oainterface.common.OAInterfaceException;
import com.seeyon.v3x.common.web.util.ResponseUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.AxisServlet;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.wso2.spring.ws.SpringWebService;
import org.wso2.spring.ws.WebServices;
import org.wso2.spring.ws.axis2.SpringBeanSystemConfigurator;
import org.wso2.spring.ws.axis2.SpringWebServiceBuilder;
import org.wso2.spring.ws.beans.MessageReceiverBean;
import org.wso2.spring.ws.util.Utils;

public class CtpAxis2Servlet
extends AxisServlet {
    private static final long serialVersionUID = -3121758988294508597L;
    private static final Log log = LogFactory.getLog(AxisServlet.class);
    public static final String CONFIGURATION_CONTEXT = "CONFIGURATION_CONTEXT";
    private boolean closeReader = true;
    private static final int BUFFER_SIZE = 8192;
    private AxisService axisService;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServiceManager.getInstance();
        if ("1".equals(SystemProperties.getInstance().getProperty("webservice.enabled"))) {
            this.init1(servletConfig);
        }
    }

    private void init1(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        WebServices servicesBean = Utils.getServicesfromAppContext((ApplicationContext)applicationContext);
        ArrayList services = servicesBean.getServices();
        if (services != null) {
            for (SpringWebService springService : services) {
                String beanName = springService.getServiceName();
                Object springPOJO = springService.getServiceBean();
                String clazz = springPOJO.getClass().getName();
                clazz = Utils.getTargetClassFromJdkDynamicAopProxy(springPOJO).getName();
                try {
                    this.axisService = new AxisService(beanName + "SpringService");
                    SpringWebServiceBuilder builder = new SpringWebServiceBuilder(this.configContext, this.axisService);
                    springService = this.populateCommonParameters(springService, clazz);
                    this.axisService = builder.populateService(springService);
                    this.axisConfiguration.addService(this.axisService);
                    this.handleModulesRefs();
                }
                catch (Exception e) {
                    throw new ServletException("Could not populate Web Service with required Spring bean", (Throwable)e);
                }
            }
        }
    }

    private SpringWebService populateCommonParameters(SpringWebService springService, String clazz) {
        HashMap<String, String> parameters;
        ArrayList<MessageReceiverBean> msgReceivers = springService.getMessageReceivers();
        if (msgReceivers == null || msgReceivers.isEmpty()) {
            MessageReceiverBean inOnlyReceiver = new MessageReceiverBean();
            inOnlyReceiver.setMep("http://www.w3.org/2004/08/wsdl/in-only");
            inOnlyReceiver.setClazz("org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
            MessageReceiverBean inOutOnlyReceiver = new MessageReceiverBean();
            inOutOnlyReceiver.setMep("http://www.w3.org/2004/08/wsdl/in-out");
            inOutOnlyReceiver.setClazz("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
            if (msgReceivers == null) {
                msgReceivers = new ArrayList<MessageReceiverBean>();
            }
            msgReceivers.add(inOnlyReceiver);
            msgReceivers.add(inOutOnlyReceiver);
            springService.setMessageReceivers(msgReceivers);
        }
        if ((parameters = springService.getParameters()) == null) {
            parameters = new HashMap<String, String>();
        }
        parameters.put("ServiceObjectSupplier", "org.wso2.spring.ws.axis2.SpringObjectSupplier");
        parameters.put("SpringPOJO", (String)springService.getServiceBean());
        parameters.put("ServiceClass", clazz);
        springService.setParameters(parameters);
        return springService;
    }

    private void handleModulesRefs() throws MissingResourceException, AxisFault {
        ArrayList list = this.axisService.getModules();
        for (int i = 0; i < list.size(); ++i) {
            AxisModule module = this.axisConfiguration.getModule((String)list.get(i));
            if (module == null) {
                throw new DeploymentException(Messages.getMessage((String)"badModuleFromService", (String)this.axisService.getName(), (String)((QName)list.get(i)).getLocalPart()));
            }
            this.axisService.engageModule(module);
        }
    }

    protected ConfigurationContext initConfigContext(ServletConfig config) throws ServletException {
        ServletContext servletContext = this.servletConfig.getServletContext();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        try {
            SpringBeanSystemConfigurator sbsc = new SpringBeanSystemConfigurator(Utils.getAxisConfigfromAppContext((ApplicationContext)applicationContext), config);
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContext((AxisConfigurator)sbsc);
            configContext.setProperty("ContainerManaged", (Object)"true");
            return configContext;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletResponse response;
        CTPAxisRequestFacade request;
        try {
            request = new CTPAxisRequestFacade((HttpServletRequest)req);
            response = (HttpServletResponse)res;
        }
        catch (ClassCastException e) {
            throw new ServletException("non-HTTP request or response");
        }
        ResponseUtil.addResponseHeader(request, response);
        this.service(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            response.setBufferSize(8192);
        }
        catch (Throwable t) {
            log.info((Object)("Old Servlet API :" + t));
        }
        this.initContextRoot(request);
        ServletOutputStream out = response.getOutputStream();
        String contentType = request.getContentType();
        if (!HTTPTransportUtils.isRESTRequest((String)contentType)) {
            MessageContext msgContext = this.createMessageContext(request, response);
            msgContext.setProperty("ContentType", (Object)contentType);
            try {
                int len;
                String url;
                try {
                    url = request.getRequestURL().toString();
                }
                catch (Throwable t) {
                    log.info((Object)("Old Servlet API (fallback to HttpServletRequest.getRequestURI) :" + t));
                    url = request.getRequestURI();
                }
                InputStream in = HTTPTransportUtils.handleGZip((MessageContext)msgContext, (InputStream)request.getInputStream());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) > -1) {
                    baos.write(buffer, 0, len);
                }
                baos.flush();
                ByteArrayInputStream in1 = new ByteArrayInputStream(baos.toByteArray());
                ByteArrayInputStream in2 = new ByteArrayInputStream(baos.toByteArray());
                msgContext.setEnvelope(TransportUtils.createSOAPMessage((MessageContext)msgContext, (InputStream)in1, (String)contentType));
                try {
                    boolean tokenAccepted = false;
                    OMElement methodElement = msgContext.getEnvelope().getBody().getFirstElement();
                    OMElement token = methodElement.getFirstElement();
                    Iterator params = token.getChildElements();
                    while (params.hasNext()) {
                        OMElement next = (OMElement)params.next();
                        String paramName = next.getLocalName();
                        String value = next.getText();
                        if (!paramName.equals("token")) continue;
                        ServiceManager.getInstance().activeToken(value);
                        tokenAccepted = true;
                        break;
                    }
                    if (!tokenAccepted) {
                        throw new OAInterfaceException(12005, "Invalid token,please authenticate again.");
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                Handler.InvocationResponse pi = HTTPTransportUtils.processHTTPPostRequest((MessageContext)msgContext, (InputStream)new BufferedInputStream(in2), (OutputStream)new BufferedOutputStream((OutputStream)out), (String)contentType, (String)request.getHeader("SOAPAction"), (String)url);
                Boolean holdResponse = (Boolean)msgContext.getProperty("HoldResponse");
                if (pi.equals((Object)Handler.InvocationResponse.SUSPEND) || holdResponse != null && Boolean.TRUE.equals(holdResponse)) {
                    ((RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl")).awaitResponse();
                }
                response.setContentType("text/xml; charset=" + msgContext.getProperty("CHARACTER_SET_ENCODING"));
                if (TransportUtils.isResponseWritten((MessageContext)msgContext) || ((RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl")).getStatus() == RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED) return;
                response.setStatus(202);
                return;
            }
            catch (AxisFault e) {
                this.setResponseState(msgContext, response);
                log.debug((Object)e);
                if (msgContext == null) throw new ServletException((Throwable)e);
                this.processAxisFault(msgContext, response, (OutputStream)out, e);
                return;
            }
            catch (Throwable t) {
                log.error((Object)t.getMessage(), t);
                try {
                    if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                        response.setStatus(202);
                    } else {
                        Integer code;
                        AxisBindingMessage axisBindingMessage;
                        response.setStatus(500);
                        AxisBindingOperation axisBindingOperation = (AxisBindingOperation)msgContext.getProperty("AxisBindingOperation");
                        if (axisBindingOperation != null && (axisBindingMessage = axisBindingOperation.getFault((String)msgContext.getProperty("faultName"))) != null && (code = (Integer)axisBindingMessage.getProperty("whttp:code")) != null) {
                            response.setStatus(code.intValue());
                        }
                    }
                    this.handleFault(msgContext, (OutputStream)out, new AxisFault(t.toString(), t));
                    return;
                }
                catch (AxisFault e2) {
                    log.info((Object)e2);
                    throw new ServletException((Throwable)e2);
                }
            }
            finally {
                this.closeStaxBuilder(msgContext);
                TransportUtils.deleteAttachments((MessageContext)msgContext);
            }
        }
        if (!this.disableREST) {
            new AxisServlet.RestRequestProcessor((AxisServlet)this, "POST", request, response).processXMLRequest();
            return;
        } else {
            this.showRestDisabledErrorMessage(response);
        }
    }

    private void setResponseState(MessageContext messageContext, HttpServletResponse response) {
        int stateInt;
        String state = (String)messageContext.getProperty("axis2.http.response.state");
        if (state != null && (stateInt = Integer.parseInt(state)) == 401) {
            String realm = (String)messageContext.getProperty("axis2.authentication.realm");
            response.addHeader("WWW-Authenticate", "basic realm=\"" + realm + "\"");
        }
    }

    private void processAxisFault(MessageContext msgContext, HttpServletResponse res, OutputStream out, AxisFault e) {
        try {
            if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                res.setStatus(202);
            } else {
                Integer code;
                AxisBindingMessage fault;
                String status = (String)msgContext.getProperty("axis2.http.response.state");
                if (status == null) {
                    res.setStatus(500);
                } else {
                    res.setStatus(Integer.parseInt(status));
                }
                AxisBindingOperation axisBindingOperation = (AxisBindingOperation)msgContext.getProperty("AxisBindingOperation");
                if (axisBindingOperation != null && (fault = axisBindingOperation.getFault((String)msgContext.getProperty("faultName"))) != null && (code = (Integer)fault.getProperty("whttp:code")) != null) {
                    res.setStatus(code.intValue());
                }
            }
            this.handleFault(msgContext, out, e);
        }
        catch (AxisFault e2) {
            log.info((Object)e2);
        }
    }

    private void closeStaxBuilder(MessageContext messageContext) throws ServletException {
        if (this.closeReader && messageContext != null) {
            try {
                StAXBuilder builder;
                SOAPEnvelope envelope = messageContext.getEnvelope();
                if (envelope != null && (builder = (StAXBuilder)envelope.getBuilder()) != null) {
                    builder.close();
                }
            }
            catch (Exception e) {
                log.debug((Object)e.toString(), (Throwable)e);
            }
        }
    }

    class CTPAxisRequestFacade
    extends HttpServletRequestWrapper
    implements HttpServletRequest {
        public CTPAxisRequestFacade(HttpServletRequest request) {
            super(request);
        }

        public String getContentType() {
            String raw = super.getContentType();
            if (!Strings.isEmpty(raw) && raw.indexOf("application/xml") > -1) {
                return "text/xml";
            }
            return raw;
        }
    }
}

