/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.web;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.web.GenericFilterProxy;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GenericFilterBean {
    private List<GenericFilterProxy> genericFilterProxies;

    public void setGenericFilterProxies(List<GenericFilterProxy> genericFilterProxies) {
        this.genericFilterProxies = genericFilterProxies;
    }

    public boolean doFilter(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.genericFilterProxies == null || this.genericFilterProxies.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.genericFilterProxies.size(); ++i) {
            GenericFilterProxy proxy = this.genericFilterProxies.get(i);
            String[] urlPattern = proxy.getUrlPattern();
            if (!this.isMap(request, urlPattern) || proxy.doFilter(request, response)) continue;
            return false;
        }
        return true;
    }

    private boolean isMap(HttpServletRequest request, String[] urlPatterns) {
        String uri = request.getRequestURI();
        if (uri == null) {
            return false;
        }
        String contextPath = SystemEnvironment.getContextPath();
        if (contextPath == null) {
            return false;
        }
        if (uri.startsWith(contextPath)) {
            uri = uri.substring(contextPath.length());
        }
        for (String urlPattern : urlPatterns) {
            if ("/*".equals(urlPattern)) {
                return true;
            }
            if (urlPattern.equals(uri)) {
                return true;
            }
            if (urlPattern.endsWith("*") && uri.startsWith(urlPattern = urlPattern.substring(0, urlPattern.length() - 1))) {
                return true;
            }
            if (!urlPattern.startsWith("*") || !uri.endsWith(urlPattern = urlPattern.substring(1))) continue;
            return true;
        }
        return false;
    }
}

