/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.web;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class ExtendJavascriptInteceptor
implements HandlerInterceptor {
    private Map<String, List<String>> cache = new ConcurrentHashMap<String, List<String>>();
    private static final Log log = CtpLogFactory.getLog(ExtendJavascriptInteceptor.class);

    private List<String> getListFiles(String path, String suffix, boolean isdepth) {
        ArrayList<String> lstFileNames = new ArrayList<String>();
        File file = new File(path);
        return this.listFile(lstFileNames, file, suffix, isdepth);
    }

    private List<String> listFile(List<String> lstFileNames, File f, String suffix, boolean isdepth) {
        if (f.isDirectory()) {
            File[] t = f.listFiles();
            for (int i = 0; i < t.length; ++i) {
                if (!isdepth && !t[i].isFile()) continue;
                this.listFile(lstFileNames, t[i], suffix, isdepth);
            }
        } else {
            String filePath = f.getAbsolutePath();
            String fileName = f.getName();
            if (!"".equals(suffix)) {
                int begIndex = filePath.lastIndexOf(".");
                String tempsuffix = "";
                if (begIndex != -1 && (tempsuffix = filePath.substring(begIndex + 1, filePath.length())).equals(suffix)) {
                    lstFileNames.add(fileName);
                }
            } else {
                lstFileNames.add(fileName);
            }
        }
        return lstFileNames;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object obj, Exception e) throws Exception {
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object obj, ModelAndView view) throws Exception {
        List<String> list;
        if (view == null) {
            return;
        }
        String viewName = view.getViewName();
        if (viewName == null) {
            return;
        }
        if (AppContext.isRunningModeDevelop() || request.getParameter("ctp_dump_modelAndView") != null) {
            response.setHeader("ModelAndView.name", viewName);
        }
        if (AppContext.isRunningModeDevelop()) {
            log.info((Object)("ModelAndView:" + viewName));
            if (Strings.isNotEmpty(viewName) && !viewName.startsWith("raw:")) {
                log.info((Object)("req:" + request.getServletPath() + "?method=" + request.getParameter("method") + " jsp:" + SystemEnvironment.getApplicationFolder() + "/WEB-INF/jsp/" + viewName + ".jsp"));
            } else {
                log.info((Object)("req:" + request.getServletPath() + "?method=" + request.getParameter("method") + " jsp:" + SystemEnvironment.getApplicationFolder() + viewName.substring(4) + ".jsp"));
            }
        }
        if ((list = this.cache.get(viewName)) == null) {
            if (viewName.startsWith(":redirect")) {
                list = Collections.EMPTY_LIST;
            } else {
                File directory;
                String parentPath = SystemEnvironment.getApplicationFolder() + "/extend/js/";
                String path = parentPath + viewName.replace("raw:", "");
                File file = new File(path);
                if (FileUtil.inDirectory(file, directory = new File(parentPath))) {
                    list = this.getListFiles(path, "js", false);
                    int size = list.size();
                    ArrayList<String> l = new ArrayList<String>(size);
                    for (String js : list) {
                        l.add("extend/js/" + viewName + "/" + js);
                    }
                    list = l;
                    this.cache.put(viewName, l);
                }
            }
        }
        view.addObject("EXTEND_JS", list);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object obj) throws Exception {
        return true;
    }
}

