/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.urlshortener;

import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.po.urlshortener.CtpShortURL;
import com.seeyon.ctp.common.urlshortener.SerialManager;
import com.seeyon.ctp.common.urlshortener.URLMapper;
import com.seeyon.ctp.common.urlshortener.URLMapperDao;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.LRUMap;

@ProcessInDataSource(name=DataSourceName.BASE)
public class URLMapperImpl
implements URLMapper,
SerialManager {
    private URLMapperDao urlMapperDao;
    private LRUMap<String, CtpShortURL> shortCache = new LRUMap(2000);
    private LRUMap<String, CtpShortURL> cache = new LRUMap(2000);

    public URLMapperDao getUrlMapperDao() {
        return this.urlMapperDao;
    }

    public void setUrlMapperDao(URLMapperDao urlMapperDao) {
        this.urlMapperDao = urlMapperDao;
    }

    @Override
    public String getShortUrl(String url) throws BusinessException {
        CtpShortURL po = this.urlMapperDao.findByUrl(url);
        if (po != null) {
            this.cache(po);
            return po.getShortUrl();
        }
        return null;
    }

    @Override
    public String getUrl(String shortUrl) throws BusinessException {
        CtpShortURL po = this.urlMapperDao.findByShortUrl(shortUrl);
        if (po != null) {
            this.cache(po);
            return po.getUrl();
        }
        return null;
    }

    private void cache(CtpShortURL po) {
        this.shortCache.put(po.getShortUrl(), po);
        this.cache.put(po.getUrl(), po);
    }

    @Override
    public void mapping(CtpShortURL po) {
        this.urlMapperDao.update(po);
        this.cache(po);
    }

    @Override
    public int getNextSerialNo(CtpShortURL po) throws BusinessException {
        return this.urlMapperDao.getNextSerialNo(po);
    }
}

