/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.thirdparty.menu;

import com.seeyon.ctp.common.thirdparty.menu.ThirdpartyMenu;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ThirdpartyMenuManager {
    private static final ThirdpartyMenuManager INSTANCE = new ThirdpartyMenuManager();
    private Map<String, List<ThirdpartyMenu>> moduleMenuMap = new ConcurrentHashMap<String, List<ThirdpartyMenu>>();

    private ThirdpartyMenuManager() {
    }

    public static ThirdpartyMenuManager getInstance() {
        return INSTANCE;
    }

    public void addMenu(ThirdpartyMenu menu) {
        for (String module : menu.getModule()) {
            List<ThirdpartyMenu> list = this.moduleMenuMap.get(module);
            if (list == null) {
                list = new CopyOnWriteArrayList<ThirdpartyMenu>();
                this.moduleMenuMap.put(module, list);
            }
            list.add(menu);
        }
    }

    public List<ThirdpartyMenu> getMenus(String module) {
        List<ThirdpartyMenu> list = this.moduleMenuMap.get(module);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }
}

