/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.shareMap;

import com.seeyon.ctp.common.timer.TimerHolder;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class V3xShareMap {
    private static Map<Object, Entry> map = new ConcurrentHashMap<Object, Entry>();

    public static void put(Object key, Object object) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        map.put(key, new Entry(object));
    }

    public static String put(Object object) {
        Long key = UUID.randomUUID().getMostSignificantBits();
        String keyStr = key.toString();
        V3xShareMap.put(keyStr, object);
        return keyStr;
    }

    public static Object get(Object key) {
        if (key == null) {
            return null;
        }
        Entry entry = map.remove(key);
        if (entry != null) {
            return entry.getObject();
        }
        return null;
    }

    public static Object getReserved(Object key) {
        if (key == null) {
            return null;
        }
        Entry entry = map.get(key);
        if (entry != null) {
            return entry.getObject();
        }
        return null;
    }

    public static void remove(Object key) {
        if (key != null) {
            map.remove(key);
        }
    }

    public static void clearUnvalidationObject() {
        Iterator<Map.Entry<Object, Entry>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next().getValue();
            if (entry.isValid()) continue;
            iterator.remove();
        }
    }

    static {
        TimerHolder.newTimer(new Runnable(){

            @Override
            public void run() {
                V3xShareMap.clearUnvalidationObject();
            }
        }, 30000L, 600000L);
    }

    private static class Entry {
        private Object object;
        private long timestamp;

        public Entry(Object object) {
            this.object = object;
            this.timestamp = System.currentTimeMillis();
        }

        public Object getObject() {
            return this.object;
        }

        public boolean isValid() {
            return System.currentTimeMillis() - this.timestamp < 0x6DDD00L;
        }
    }
}

