/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.rate;

import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.quartz.QuartzListener;
import com.seeyon.ctp.common.rate.SeeyonRateLimiter;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RateLimitInitializer
extends AbstractSystemInitializer {
    private static Log logger = CtpLogFactory.getLog(QuartzListener.class);
    private static AtomicBoolean initialized = new AtomicBoolean(false);
    private static final String DEFAULT_PERMITS = "permitsPreSecond";
    private static final String DEFAULT_WEIGHT = "defaultWeight";
    private static final String DEFAULT_TIMEOUT = "waitMilliSecond";

    @Override
    public void initialize() {
        if (initialized.get()) {
            return;
        }
        File rateLimitXMLFile = new File(AppContext.getCfgHome() + "/base/rate_limit.xml");
        if (!rateLimitXMLFile.exists()) {
            return;
        }
        SAXReader builder = null;
        try {
            builder = new SAXReader();
            Document doc = builder.read(rateLimitXMLFile);
            Element root = doc.getRootElement();
            List childrenList = root.elements();
            int defaultWeight = 1;
            long timeoutMilliSecond = 200L;
            for (Element child : childrenList) {
                if (DEFAULT_PERMITS.equals(child.getName())) {
                    try {
                        SeeyonRateLimiter.initRateLimiter(Integer.parseInt(child.getStringValue()));
                    }
                    catch (Exception e) {
                        logger.warn((Object)"rate_limit.xml permitsPreSecond must be int type", (Throwable)e);
                        SeeyonRateLimiter.initRateLimiter(0);
                    }
                    continue;
                }
                if (DEFAULT_WEIGHT.equals(child.getName())) {
                    try {
                        defaultWeight = Integer.parseInt(child.getStringValue());
                    }
                    catch (Exception e) {
                        logger.warn((Object)"rate_limit.xml defaultWeight must be int type", (Throwable)e);
                    }
                    continue;
                }
                if (DEFAULT_TIMEOUT.equals(child.getName())) {
                    try {
                        timeoutMilliSecond = Long.parseLong(child.getStringValue());
                    }
                    catch (Exception e) {
                        logger.warn((Object)"rate_limit.xml waitMilliSecond must be long type", (Throwable)e);
                    }
                    continue;
                }
                if (!"rateLimit".equals(child.getName())) continue;
                Element element = child.element("requestUrl");
                SeeyonRateLimiter.RateLimit limit = null;
                String uri = null;
                if (element != null) {
                    String url = element.getStringValue();
                    String[] urlArray = url.split("\\?");
                    uri = urlArray[0];
                    limit = new SeeyonRateLimiter.RateLimit(url, defaultWeight);
                    if (urlArray.length > 1) {
                        String paramStr = urlArray[1];
                        for (String param : paramStr.split("&")) {
                            String[] paramPair = param.split("=");
                            if (paramPair.length == 2) {
                                limit.addParameter(paramPair[0], paramPair[1]);
                                continue;
                            }
                            logger.error((Object)("\u9650\u6d41\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5 reteLimit.requestUrl (" + url + ")"));
                        }
                    }
                }
                if (limit == null) continue;
                String requestType = "page";
                element = child.element("requestType");
                if (element != null) {
                    requestType = element.getStringValue();
                }
                limit.setRequestType(requestType);
                if ("rest".equals(requestType)) {
                    element = child.element("code");
                    if (element != null) {
                        limit.setCode(element.getStringValue());
                    }
                } else {
                    element = child.element("toUrl");
                    if (element != null) {
                        limit.setToUrl(element.getStringValue());
                    }
                }
                if ((element = child.element("hint")) != null) {
                    limit.setHint(element.getStringValue());
                }
                if ((element = child.element("weight")) != null) {
                    try {
                        limit.setWeight(Integer.parseInt(element.getStringValue()));
                    }
                    catch (Exception e) {
                        logger.warn((Object)"rate_limit.xml rateLimit.weight must be int type", (Throwable)e);
                    }
                }
                if ((element = child.element("valid")) != null) {
                    try {
                        limit.setValid(Boolean.parseBoolean(element.getStringValue()));
                    }
                    catch (Exception e) {
                        logger.warn((Object)"rate_limit.xml rateLimit.weight must be int type", (Throwable)e);
                    }
                }
                limit.setTimeout(timeoutMilliSecond);
                SeeyonRateLimiter.addRateLimit(uri, limit);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error parsing XML file:" + rateLimitXMLFile.getAbsolutePath()), (Throwable)e);
        }
        initialized.set(true);
    }
}

