/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.parser;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.config.SystemConfig;
import com.seeyon.ctp.common.encrypt.CoderFactory;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.parser.WordTextPiece;
import com.seeyon.ctp.util.UUIDLong;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.util.LittleEndian;

public class WPSFileParser {
    private static SystemConfig systemConfig;
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWPSWordContent(File file) throws Exception {
        FileInputStream is = null;
        FileOutputStream fileOS = null;
        StringBuilder sb = null;
        DocumentInputStream din = null;
        try {
            is = new FileInputStream(file);
            String newPathName = SystemEnvironment.getSystemTempFolder() + File.separator + String.valueOf(UUIDLong.longUUID());
            fileOS = new FileOutputStream(newPathName);
            CoderFactory.getInstance().download(is, fileOS);
            is = new FileInputStream(new File(newPathName));
            ArrayList text = new ArrayList();
            POIFSFileSystem fsys = new POIFSFileSystem((InputStream)is);
            DocumentEntry headerProps = (DocumentEntry)fsys.getRoot().getEntry("WordDocument");
            din = fsys.createDocumentInputStream("WordDocument");
            byte[] header = new byte[headerProps.getSize()];
            din.read(header);
            short info = LittleEndian.getShort((byte[])header, (int)10);
            boolean useTable1 = (info & 0x200) != 0;
            int complexOffset = LittleEndian.getInt((byte[])header, (int)418);
            String tableName = null;
            tableName = useTable1 ? "1Table" : "0Table";
            DocumentEntry table = (DocumentEntry)fsys.getRoot().getEntry(tableName);
            byte[] tableStream = new byte[table.getSize()];
            din.close();
            din = fsys.createDocumentInputStream(tableName);
            din.read(tableStream);
            fsys.close();
            fsys = null;
            table = null;
            headerProps = null;
            int multiple = WPSFileParser.findText(tableStream, complexOffset, text);
            sb = new StringBuilder();
            int size = text.size();
            tableStream = null;
            for (int x = 0; x < size; ++x) {
                WordTextPiece nextPiece = (WordTextPiece)text.get(x);
                int start = nextPiece.getStart();
                int length = nextPiece.getLength();
                boolean unicode = nextPiece.usesUnicode();
                String toStr = null;
                toStr = unicode ? new String(header, start, length * multiple, "UTF-16LE") : new String(header, start, length, "ISO-8859-1");
                sb.append(toStr).append(" ");
            }
            din.close();
        }
        catch (Exception e) {
            log.warn((Object)("\u83b7\u53d6WPS\u6587\u6863\u5185\u5bb9\u6709\u8bef(" + e.getMessage() + "),\u5ffd\u7565"));
            String string = "";
            return string;
        }
        catch (Throwable e) {
            log.warn((Object)("WPS \u6587\u6863\u5185\u5bb9\u4e0d\u80fd\u89e3\u6790(" + e.getMessage() + "),\u5ffd\u7565"));
            String string = "";
            return string;
        }
        finally {
            if (fileOS != null) {
                try {
                    fileOS.close();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
            if (din != null) {
                try {
                    din.close();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    private static int findText(byte[] tableStream, int complexOffset, List text) throws IOException {
        int pos = complexOffset;
        int multiple = 2;
        while (tableStream[pos] == 1) {
            short skip = LittleEndian.getShort((byte[])tableStream, (int)(++pos));
            pos += 2 + skip;
        }
        if (tableStream[pos] != 2) {
            throw new IOException("corrupted Word file");
        }
        int pieceTableSize = LittleEndian.getInt((byte[])tableStream, (int)(++pos));
        pos += 4;
        int pieces = (pieceTableSize - 4) / 12;
        for (int x = 0; x < pieces; ++x) {
            int filePos = LittleEndian.getInt((byte[])tableStream, (int)(pos + (pieces + 1) * 4 + x * 8 + 2));
            boolean unicode = false;
            if ((filePos & 0x40000000) == 0) {
                unicode = true;
            } else {
                unicode = false;
                multiple = 1;
                filePos &= 0xBFFFFFFF;
                filePos /= 2;
            }
            int totLength = LittleEndian.getInt((byte[])tableStream, (int)(pos + (x + 1) * 4)) - LittleEndian.getInt((byte[])tableStream, (int)(pos + x * 4));
            WordTextPiece piece = new WordTextPiece(filePos, totLength, unicode);
            text.add(piece);
        }
        return multiple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWPSExcelContent(File file) throws Exception {
        FileInputStream is = null;
        FileOutputStream fileOS = null;
        StringBuffer b = null;
        try {
            is = new FileInputStream(file);
            String newPathName = SystemEnvironment.getSystemTempFolder() + File.separator + String.valueOf(UUIDLong.longUUID());
            fileOS = new FileOutputStream(newPathName);
            CoderFactory.getInstance().download(is, fileOS);
            is = new FileInputStream(new File(newPathName));
            ArrayList<String> allContent = new ArrayList<String>();
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)is);
            try {
                int size = workbook.getNumberOfSheets();
                if (size != 0) {
                    for (int i = 0; i < size; ++i) {
                        HSSFSheet sheet = workbook.getSheetAt(i);
                        String sheetContent = WPSFileParser.getSheetData(sheet);
                        allContent.add(sheetContent);
                    }
                }
                b = new StringBuffer();
                if (allContent != null && !allContent.isEmpty()) {
                    for (String str : allContent) {
                        b.append(str);
                    }
                }
            }
            finally {
                workbook.close();
            }
        }
        catch (Exception e) {
            log.warn((Object)("\u83b7\u53d6WPS\u8868\u683c\u5185\u5bb9\u6709\u8bef(" + e.getMessage() + "),\u5ffd\u7565"));
            String string = "";
            return string;
        }
        catch (Throwable e) {
            log.warn((Object)("WPS\u8868\u683c\u5185\u5bb9\u4e0d\u80fd\u89e3\u6790(" + e.getMessage() + "),\u5ffd\u7565"));
        }
        finally {
            if (fileOS != null) {
                try {
                    fileOS.close();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return b != null ? b.toString() : "";
    }

    private static String getSheetData(HSSFSheet sheet) throws IOException {
        ArrayList reList = new ArrayList();
        int maxRow = sheet.getLastRowNum();
        for (int i = 0; i <= maxRow; ++i) {
            ArrayList<String> subList = new ArrayList<String>();
            HSSFRow row = sheet.getRow(i);
            if (row == null) continue;
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                HSSFCell cell = sheet.getRow(i).getCell((int)((short)j));
                if (cell == null) continue;
                if (CellType.STRING.equals((Object)cell.getCellType())) {
                    subList.add(cell.getRichStringCellValue().toString());
                }
                if (CellType.NUMERIC.equals((Object)cell.getCellType())) {
                    subList.add(String.valueOf(cell.getNumericCellValue()));
                }
                if (CellType.FORMULA.equals((Object)cell.getCellType())) {
                    subList.add(cell.getCellFormula());
                }
                if (!CellType.BOOLEAN.equals((Object)cell.getCellType())) continue;
                subList.add(String.valueOf(cell.getBooleanCellValue()));
            }
            reList.addAll(subList);
        }
        StringBuilder b = new StringBuilder();
        if (reList != null && !reList.isEmpty()) {
            for (String str : reList) {
                b.append(str);
            }
        }
        return b.toString();
    }

    static {
        log = CtpLogFactory.getLog(WPSFileParser.class);
    }
}

