/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.parser;

import com.seeyon.ctp.common.encrypt.PipeHandle;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.parser.IFileParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.commons.logging.Log;

public class RTFFileParser
implements IFileParser {
    private static final Log log = CtpLogFactory.getLog(RTFFileParser.class);
    private File file;
    private String title;
    private Map metadata;

    public RTFFileParser() {
    }

    public RTFFileParser(File file) {
        this.setFile(file);
    }

    @Override
    public void setFile(File file) {
        this.file = file;
        this.title = file.getName();
        this.metadata = new ConcurrentHashMap();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContentString() {
        String s = "";
        RTFEditorKit rtf = new RTFEditorKit();
        DefaultStyledDocument defaultstyleddocument = new DefaultStyledDocument();
        FileInputStream input = null;
        PipedInputStream in = null;
        try {
            input = new FileInputStream(this.file);
            in = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream(in);
            PipeHandle handle = new PipeHandle(input, out);
            Thread t = new Thread(handle);
            t.start();
            rtf.read(new InputStreamReader(in), (Document)defaultstyleddocument, 0);
            s = defaultstyleddocument.getText(0, defaultstyleddocument.getLength());
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (Exception e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return s;
    }

    @Override
    public Reader getContentReader() {
        String s = this.getContentString();
        StringReader reader = null;
        if (s != null) {
            reader = new StringReader(s);
        }
        return reader;
    }

    @Override
    public String getMetadata(String metadataname) {
        return (String)this.metadata.get(metadataname);
    }
}

