/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.office.trans.util;

import com.itextpdf.text.pdf.PdfEncryptor;
import com.itextpdf.text.pdf.PdfReader;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.config.SystemConfig;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.filemanager.Constants;
import com.seeyon.ctp.common.office.trans.manager.OfficeTransManager;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.common.security.SecurityHelper;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OfficeTransHelper {
    public static final String OFFICE_TRANS_TYPE_YONGZHONG = "yongzhong";
    public static final String OFFICE_TRANS_TYPE_SEEYON = "seeyon";
    public static final String DEFAULT_FILE_SUFFIX = ".seeyon";
    public static final String PDF_PASSWORD = "SeeYon";
    private static final Log log = LogFactory.getLog(OfficeTransHelper.class);
    public static final String OfficeTransPathPrefix = "/seeyon/office/cache/";
    private static final String[] supportArray = new String[]{"doc", "docx", "xls", "xlsx", "ppt", "pptx", "rtf"};
    private static Set<String> supports = new HashSet<String>();
    private static String pdfSwitch = SystemProperties.getInstance().getProperty("officeTrans.switch.pdf");
    private static String preConver = SystemProperties.getInstance().getProperty("officeTrans.switch.preconvert");
    private static OfficeTransManager officeTransManager;

    private static boolean isSupport(String extension) {
        return supports.contains(extension);
    }

    public static boolean isPreConvert() {
        return !Strings.isBlank(preConver) && !"false".equals(preConver);
    }

    public static boolean allowTrans(Attachment attachment) {
        if (attachment == null) {
            return false;
        }
        Integer type = attachment.getType();
        if (!OfficeTransHelper.checkType(type)) {
            return false;
        }
        if (!OfficeTransHelper.checkSize(attachment)) {
            return false;
        }
        if (!OfficeTransHelper.isOfficeTran()) {
            return false;
        }
        return OfficeTransHelper.isSupport(attachment.getExtension());
    }

    public static boolean allowTrans(V3XFile file) {
        if (file == null) {
            return false;
        }
        if (!OfficeTransHelper.checkSize(file)) {
            return false;
        }
        if (!OfficeTransHelper.isOfficeTran()) {
            return false;
        }
        String mimeType = file.getMimeType();
        if ("msoffice".equals(mimeType)) {
            return true;
        }
        if ("application/msword".equals(mimeType)) {
            return true;
        }
        if ("application/vnd.ms-excel".equals(mimeType)) {
            return true;
        }
        if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(mimeType)) {
            return true;
        }
        if ("application/vnd.openxmlformats-officedocument.wordprocessingml.document".equals(mimeType)) {
            return true;
        }
        if ("application/pdf".equals(mimeType)) {
            return Strings.isNotBlank(pdfSwitch) && "true".equals(pdfSwitch);
        }
        Integer type = file.getType();
        if (!OfficeTransHelper.checkType(type)) {
            return false;
        }
        return OfficeTransHelper.isSupport(FilenameUtils.getExtension((String)file.getFilename()).toLowerCase());
    }

    private static boolean checkSize(Attachment attachment) {
        return attachment.getSize() < OfficeTransHelper.getOfficeTransManager().getFileMaxSize();
    }

    private static boolean checkSize(V3XFile attachment) {
        return attachment.getSize() < OfficeTransHelper.getOfficeTransManager().getFileMaxSize();
    }

    private static boolean checkType(int type) {
        return type == Constants.ATTACHMENT_TYPE.FILE.ordinal() || type == Constants.ATTACHMENT_TYPE.FormFILE.ordinal();
    }

    public static String buildCacheUrl(V3XFile file, boolean needDownload) {
        return OfficeTransHelper.buildCacheUrl(file.getCreateDate(), file.getId(), file.getFilename(), needDownload);
    }

    public static String buildCacheUrl(Date createDate, long fileId, String filename, boolean needDownload) {
        String d = Datetimes.format(createDate, "yyyyMMdd");
        String d1 = Datetimes.format(createDate, "yyyy-MM-dd");
        try {
            return SystemEnvironment.getContextPath() + "/officeTrans.do?fileCreateDate=" + d + "&fileCreateDate1=" + d1 + "&fileId=" + fileId + "&v=" + SecurityHelper.digest(fileId) + "&needDownload=" + needDownload + "&filename=" + URLEncoder.encode(filename, "UTF-8");
        }
        catch (Exception e) {
            log.error((Object)("\u521b\u5efaOffice\u6587\u6863\u8f6c\u6362\u5728\u7ebf\u67e5\u770bURL\u5730\u5740\u65f6\u51fa\u73b0\u5f02\u5e38[fileId=" + fileId + "]"), (Throwable)e);
            return null;
        }
    }

    private static OfficeTransManager getOfficeTransManager() {
        if (officeTransManager == null) {
            officeTransManager = (OfficeTransManager)AppContext.getBean("officeTransManager");
        }
        return officeTransManager;
    }

    public static boolean isOfficeTran() {
        boolean officeTransPluginFlag = AppContext.hasPlugin("baseOfficeTrans") || AppContext.hasPlugin("yongzhongOfficeTrans");
        SystemConfig systemConfig = (SystemConfig)AppContext.getBean("systemConfig");
        String item = systemConfig.get("office_transform_enable");
        return "enable".equals(item) && officeTransPluginFlag;
    }

    public static String formatSize(long size) {
        String fileSzie = null;
        fileSzie = size < 1024L ? new DecimalFormat("#").format((double)size) + "B" : (size < 0x100000L ? new DecimalFormat("#.00").format((double)size / 1024.0) + "KB" : (size < 0x40000000L ? new DecimalFormat("#.00").format((double)size / 1048576.0) + "MB" : new DecimalFormat("#.00").format((double)size / 1.073741824E9) + "GB"));
        return fileSzie;
    }

    public static long getFileSize(String path) {
        File file = new File(path);
        long size = 0L;
        if (file.exists()) {
            size = file.isFile() ? file.length() : OfficeTransHelper.getChildFileSize(file.listFiles(), size);
        }
        return size;
    }

    private static long getChildFileSize(File[] childFiles, long size) {
        for (int i = 0; i < childFiles.length; ++i) {
            if (!childFiles[i].exists() || childFiles[i].getName().endsWith(DEFAULT_FILE_SUFFIX)) continue;
            if (childFiles[i].isFile()) {
                size += childFiles[i].length();
                continue;
            }
            size = OfficeTransHelper.getChildFileSize(childFiles[i].listFiles(), size);
        }
        return size;
    }

    public static String getExtName(String fileName) {
        int dot;
        if (OfficeTransHelper.isDir(fileName)) {
            return "dir";
        }
        if (fileName != null && fileName.length() > 0 && (dot = fileName.lastIndexOf(46)) > -1 && dot < fileName.length() - 1) {
            return fileName.substring(dot + 1);
        }
        return fileName;
    }

    public static boolean isDir(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        File f = new File(path);
        return f.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File updatePDFFilePopedom(File file, String oldPassword) {
        File tagetFile = file;
        if (!file.getAbsolutePath().toLowerCase().trim().endsWith(".pdf.seeyon")) {
            tagetFile = new File(file.getAbsolutePath() + DEFAULT_FILE_SUFFIX);
        }
        if (tagetFile.exists() && tagetFile.length() > 0L) {
            return tagetFile;
        }
        OutputStream os = null;
        PdfReader reader = null;
        try {
            reader = null == oldPassword || "".equals(oldPassword) ? new PdfReader(file.getAbsolutePath()) : new PdfReader(file.getAbsolutePath(), oldPassword.getBytes());
            PdfReader.unethicalreading = true;
            os = new FileOutputStream(tagetFile);
            PdfEncryptor.encrypt((PdfReader)reader, (OutputStream)os, (boolean)true, (String)"HK@FB", (String)PDF_PASSWORD, (int)2068);
        }
        catch (Exception e) {
            log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
                if (null != os) {
                    os.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return tagetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPDFFileTotalPage(File file) {
        int page = 0;
        PdfReader reader = null;
        try {
            reader = new PdfReader(file.getAbsolutePath(), PDF_PASSWORD.getBytes());
            page = reader.getNumberOfPages();
        }
        catch (IOException e) {
            log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
        return page;
    }

    public static byte[] readFile(File file) throws IOException {
        byte[] contents = new byte[]{0};
        if (file == null || !file.exists()) {
            return contents;
        }
        if (!file.isFile() || !file.canRead()) {
            return contents;
        }
        FileInputStream fstream = null;
        try {
            fstream = new FileInputStream(file);
            contents = new byte[(int)file.length()];
            fstream.read(contents);
        }
        finally {
            if (fstream != null) {
                fstream.close();
            }
        }
        return contents;
    }

    static {
        for (int i = 0; i < supportArray.length; ++i) {
            supports.add(supportArray[i]);
        }
        if (Strings.isNotBlank(pdfSwitch) && "true".equals(pdfSwitch)) {
            supports.add("pdf");
        }
    }
}

