/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.office.trans.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;

public class Common {
    private static final Log LOGGER = CtpLogFactory.getLog(Common.class);

    public void setCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "private, max-age=10800, pre-check=10800");
        response.setHeader("Pragma", "private");
        SimpleDateFormat rfc822Dateformat = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);
        response.setHeader("Expires", rfc822Dateformat.format(new Date()));
    }

    public void clearCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "private, max-age=0, pre-check=0");
        response.setHeader("Pragma", "No-Cache");
        response.setHeader("Expires", "0");
    }

    public boolean endOrRespond(HttpServletRequest request, HttpServletResponse response) {
        String mod = request.getHeader("If-Modified-Since");
        if (mod == null) {
            return true;
        }
        response.setHeader("Last-Modified", mod);
        return false;
    }

    public int getStringHashCode(String string) {
        if ((string = string.trim()) == null || string.length() == 0) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < string.length(); ++i) {
            hash = 31 * hash + string.charAt(i);
        }
        return hash;
    }

    public BufferedImage createResizedCopy(Image originalImage, int scaledWidth, int scaledHeight, boolean preserveAlpha) {
        int imageType = preserveAlpha ? 1 : 2;
        BufferedImage scaledBI = new BufferedImage(scaledWidth, scaledHeight, imageType);
        Graphics2D g = scaledBI.createGraphics();
        if (preserveAlpha) {
            g.setComposite(AlphaComposite.Src);
        }
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null);
        g.dispose();
        return scaledBI;
    }

    public void scale(String src, int width, int height, String dest) throws IOException {
        BufferedImage bsrc = ImageIO.read(new File(src));
        BufferedImage bdest = new BufferedImage(width, height, 2);
        bdest = this.createResizedCopy(bsrc, width, height, false);
        ImageIO.write((RenderedImage)bdest, "png", new File(dest));
    }

    public String generateImage(String sourceFile, String cacheFile, String resolution, String outformat) {
        String extension = sourceFile.substring(sourceFile.lastIndexOf(".") + 1).toLowerCase();
        try {
            BufferedImage bimg = ImageIO.read(new File(sourceFile));
            int width = bimg.getWidth();
            int height = bimg.getHeight();
            int resol = 1;
            if (resolution != null) {
                try {
                    resol = Integer.parseInt(resolution.trim());
                }
                catch (Exception e) {
                    resol = width;
                }
                if (width <= resol) {
                    return sourceFile;
                }
            } else {
                resol = width;
            }
            double ratio = (double)height / (double)width;
            int newWidth = resol;
            int newHeight = (int)Math.ceil((double)newWidth * ratio);
            BufferedImage bdest = new BufferedImage(newWidth, newHeight, 2);
            bdest = this.createResizedCopy(bimg, newWidth, newHeight, false);
            ImageIO.write((RenderedImage)bdest, extension, new File(cacheFile));
        }
        catch (Exception e) {
            cacheFile = sourceFile;
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return cacheFile;
    }
}

