/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.office.trans.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;

public class CodeUtil {
    private static final Log LOG = CtpLogFactory.getLog(CodeUtil.class);

    public static String encode(String param) {
        return CodeUtil.encode(param, "UTF-8");
    }

    public static String encode(String param, String code) {
        if (param == null) {
            return null;
        }
        if ("".equals(param.trim())) {
            return "";
        }
        String temp = null;
        try {
            temp = URLEncoder.encode(new String(param.getBytes("iso8859-1"), code), code);
        }
        catch (UnsupportedEncodingException e) {
            temp = param;
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return temp.trim();
    }

    public static String decode(String param) {
        return CodeUtil.decode(param, "UTF-8");
    }

    public static String decode(String param, String code) {
        if (param == null) {
            return null;
        }
        if ("".equals(param.trim())) {
            return "";
        }
        String temp = null;
        try {
            String codeType = CodeUtil.getByteCoding(param.getBytes("iso8859-1"));
            temp = new String(param.getBytes("iso8859-1"), codeType);
            temp = URLDecoder.decode(temp, code);
        }
        catch (UnsupportedEncodingException e) {
            temp = param;
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return temp.trim();
    }

    public static String decodeAuto(String param) {
        return CodeUtil.decodeAuto(param, "UTF-8");
    }

    public static String decodeAuto(String param, String code) {
        if (param == null) {
            return null;
        }
        if ("".equals(param.trim())) {
            return param;
        }
        try {
            String codeType = CodeUtil.getByteCoding(param.getBytes("iso8859-1"));
            if (!"GBK".equals(codeType)) {
                param = new String(param.getBytes("iso8859-1"), codeType);
            }
            if (!CodeUtil.isConSpeCharacters(param)) {
                param = new String(param.getBytes("iso8859-1"), codeType);
            }
            param = URLDecoder.decode(param, code);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return param;
    }

    public static boolean isConSpeCharacters(String string) {
        return string.replaceAll("[\u0391-\uffe5]*[a-z]*[A-Z]*\\d*-*_*\\s*", "").replace(",", "").replace("~", "").replace(".", "").replace("/", "").replace("\\", "").replace("(", "").replace(")", "").replace(":", "").length() == 0;
    }

    public static String getByteCoding(byte[] data) {
        int countGoodUtf = 0;
        int countBadUtf = 0;
        byte currentByte = 0;
        byte previousByte = 0;
        for (int i = 1; i < data.length; ++i) {
            currentByte = data[i];
            previousByte = data[i - 1];
            if ((currentByte & 0xC0) == 128) {
                if ((previousByte & 0xC0) == 192) {
                    ++countGoodUtf;
                    continue;
                }
                if ((previousByte & 0x80) != 0) continue;
                ++countBadUtf;
                continue;
            }
            if ((previousByte & 0xC0) != 192) continue;
            ++countBadUtf;
        }
        return countGoodUtf > countBadUtf ? "UTF-8" : "GBK";
    }

    public static String escape(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length() * 6);
        for (int i = 0; i < src.length(); ++i) {
            char j = src.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public static String unescape(String src) {
        StringBuilder tmp = new StringBuilder();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }
}

