/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.office.trans;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.office.trans.manager.OfficeTransManager;
import com.seeyon.ctp.common.office.trans.manager.SeeyonOfficeTransManagerImpl;
import com.seeyon.ctp.common.office.trans.util.Common;
import com.seeyon.ctp.common.office.trans.util.OfficeTransHelper;
import com.seeyon.ctp.util.Datetimes;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

public class OfficeTransController
extends BaseController {
    private OfficeTransManager officeTransManager;

    public OfficeTransManager getOfficeTransManager() {
        return this.officeTransManager;
    }

    public void setOfficeTransManager(OfficeTransManager officeTransManager) {
        this.officeTransManager = officeTransManager;
    }

    public ModelAndView view(HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.noCache(response);
        ModelAndView mv = new ModelAndView("common/officeTrans/view");
        Date createDate = Datetimes.parseDate(request.getParameter("createDate"));
        String filename = request.getParameter("filename");
        long fileId = Long.valueOf(request.getParameter("fileId"));
        String url = OfficeTransHelper.buildCacheUrl(createDate, fileId, filename, true);
        mv.addObject("officeTransUrl", (Object)url);
        return mv;
    }

    @Override
    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.noCache(response);
        ModelAndView mv = new ModelAndView("common/officeTrans/index");
        return mv;
    }

    public ModelAndView wait(HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.noCache(response);
        ModelAndView mv = new ModelAndView("common/officeTrans/wait");
        return mv;
    }

    public ModelAndView toShow(HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.noCache(response);
        String filePath = request.getParameter("filePath");
        String fileName = request.getParameter("fileName");
        String fileSuffix = request.getParameter("fileSuffix");
        String fileSize = request.getParameter("fileSize");
        String isChild = request.getParameter("isChild");
        String totalPage = request.getParameter("totalPage");
        request.setAttribute("filePath", (Object)filePath);
        request.setAttribute("fileName", (Object)fileName);
        request.setAttribute("fileSuffix", (Object)fileSuffix);
        request.setAttribute("fileSize", (Object)fileSize);
        request.setAttribute("isChild", (Object)isChild);
        request.setAttribute("totalPage", (Object)totalPage);
        ModelAndView mv = new ModelAndView("common/officeTrans/wait");
        return mv;
    }

    public ModelAndView toMiniShow(HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.noCache(response);
        String fileId = request.getParameter("fileId");
        String dateStr = request.getParameter("dateStr");
        ModelAndView mv = new ModelAndView("common/officeTrans/newTrans/documentMin");
        Object seeyonOfficeTransManagerObj = AppContext.getBean("seeyonOfficeTransManager");
        SeeyonOfficeTransManagerImpl seeyonOfficeTransManager = null;
        if (seeyonOfficeTransManagerObj != null) {
            seeyonOfficeTransManager = (SeeyonOfficeTransManagerImpl)seeyonOfficeTransManagerObj;
            File targetFile = seeyonOfficeTransManager.getFileForNewOfficeTrans(Long.valueOf(fileId), dateStr);
            String filePath = "";
            filePath = targetFile.getCanonicalPath();
            String filePathUTF8 = URLEncoder.encode(filePath, "UTF-8");
            String passFileName = request.getParameter("fileName");
            if (null == passFileName || "".equals(passFileName.trim())) {
                passFileName = targetFile.getName();
            }
            String extName = OfficeTransHelper.getExtName(filePathUTF8);
            File pdfFile = null;
            File parentDir = targetFile.getParentFile();
            String transedFileName = targetFile.getName() + ".pdf.seeyon";
            pdfFile = new File(parentDir, transedFileName);
            pdfFile = OfficeTransHelper.updatePDFFilePopedom(pdfFile, null);
            int totalPage = OfficeTransHelper.getPDFFileTotalPage(pdfFile);
            mv.addObject("fileId", (Object)fileId);
            mv.addObject("dateStr", (Object)dateStr);
            mv.addObject("fileSuffix", (Object)extName);
            mv.addObject("totalPage", (Object)totalPage);
        }
        return mv;
    }

    public ModelAndView noFind(HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.noCache(response);
        ModelAndView mv = new ModelAndView("common/officeTrans/newTrans/FileNotFind");
        return mv;
    }

    public void docView(HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.noCache(response);
        BufferedOutputStream outs = new BufferedOutputStream((OutputStream)response.getOutputStream());
        Common conf = new Common();
        String fileId = request.getParameter("fileId");
        String dateStr = request.getParameter("dateStr");
        Object seeyonOfficeTransManagerObj = AppContext.getBean("seeyonOfficeTransManager");
        SeeyonOfficeTransManagerImpl seeyonOfficeTransManager = null;
        if (seeyonOfficeTransManagerObj != null) {
            File pdfFileSysauto;
            seeyonOfficeTransManager = (SeeyonOfficeTransManagerImpl)seeyonOfficeTransManagerObj;
            File targetFile = seeyonOfficeTransManager.getFileForNewOfficeTrans(Long.valueOf(fileId), dateStr);
            String doc = targetFile.getCanonicalPath();
            String page = request.getParameter("page");
            String totalPage = request.getParameter("totalPage");
            String format = request.getParameter("format");
            String resolution = request.getParameter("resolution");
            String callback = request.getParameter("callback");
            String allowcache = request.getParameter("allowcache");
            if (doc == null) {
                return;
            }
            if (format == null) {
                format = "swf";
            }
            if (callback == null) {
                callback = "";
            }
            if (allowcache == null) {
                allowcache = "true";
            }
            String pdfFilePath = doc;
            boolean isPdfSrcFile = false;
            if (!doc.toLowerCase().trim().endsWith(".pdf") && !doc.toLowerCase().trim().endsWith(".pdf.seeyon")) {
                pdfFilePath = doc + ".pdf";
            } else if (doc.toLowerCase().trim().endsWith(".pdf")) {
                isPdfSrcFile = true;
            }
            if (!isPdfSrcFile && !pdfFilePath.toLowerCase().trim().endsWith(".pdf.seeyon") && (pdfFileSysauto = new File(pdfFilePath + ".seeyon")).exists() && pdfFileSysauto.length() > 0L) {
                pdfFilePath = pdfFileSysauto.getAbsolutePath();
            }
            String swfFilePath = doc + ".swf";
            String jsonFilePath = doc + ".js";
            String pngFilePath = doc + ".png";
            String jpgCachePath = doc + "_res_" + resolution + ".jpg";
            if (null != totalPage && !"".equals(totalPage.trim()) && Integer.parseInt(totalPage) > 1) {
                if (null != page && !"".equals(page.trim())) {
                    swfFilePath = doc + "_" + page + ".swf";
                    jsonFilePath = doc + "_" + page + ".js";
                    pngFilePath = doc + "_" + page + ".png";
                    jpgCachePath = doc + "_" + page + "_res_" + resolution + ".jpg";
                }
            } else {
                page = null;
            }
            String messages = "";
            if ("true".equals(allowcache)) {
                conf.setCacheHeaders(response);
            }
            if ("swf".equals(format) || "jpg".equals(format) || "png".equals(format) || "pdf".equals(format)) {
                String swfFilePathSysauto;
                swfFilePath = swfFilePathSysauto = swfFilePath + ".seeyon";
                if (!"png".equals(format) && !"jpg".equals(format)) {
                    if ("pdf".equals(format)) {
                        response.setContentType("application/pdf");
                        outs.write(OfficeTransHelper.readFile(new File(pdfFilePath)));
                    } else if ("swf".equals(format) && ("false".equals(allowcache) || "true".equals(allowcache) && conf.endOrRespond(request, response))) {
                        response.setContentType("application/x-shockwave-flash");
                        response.setHeader("Accept-Ranges", "bytes");
                        byte[] content = OfficeTransHelper.readFile(new File(swfFilePath));
                        response.setContentLength(content.length);
                        outs.write(content);
                    }
                }
            } else if ("json".equals(format) || "jsonp".equals(format)) {
                // empty if block
            }
            if (!(messages.length() <= 0 || "[OK]".equals(messages) || "[Converted]".equals(messages) || "png".equals(format))) {
                outs.write(("\u9519\u8bef:" + messages.substring(1, messages.length() - 2)).getBytes());
            }
            outs.flush();
            outs.close();
        }
    }
}

