/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.metadata.util;

import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.metadata.bo.MetadataCategoryBO;
import com.seeyon.ctp.common.metadata.bo.MetadataColumnBO;
import com.seeyon.ctp.common.metadata.bo.MetadataTableTreeBO;
import com.seeyon.ctp.common.metadata.enums.ColumnTypeEnum;
import com.seeyon.ctp.common.po.metadata.CtpMetadataCategory;
import com.seeyon.ctp.common.po.metadata.CtpMetadataColumn;
import com.seeyon.ctp.common.po.metadata.CtpMetadataTable;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class ConvertMetadataUtil {
    public static List<MetadataTableTreeBO> convertCtpMetadataTableToTreeBOList(List<CtpMetadataTable> ctpMetadataTableList) {
        ArrayList<MetadataTableTreeBO> metadataTableTreeBOList = new ArrayList<MetadataTableTreeBO>();
        int sort = 1;
        if (CollectionUtils.isNotEmpty(ctpMetadataTableList)) {
            for (CtpMetadataTable ctpMetadataTable : ctpMetadataTableList) {
                MetadataTableTreeBO metadataTableTreeBO = new MetadataTableTreeBO();
                metadataTableTreeBO.setId(ctpMetadataTable.getId());
                metadataTableTreeBO.setTableName(ctpMetadataTable.getLabel());
                metadataTableTreeBO.setParentId(-1L);
                metadataTableTreeBO.setIconSkin("");
                metadataTableTreeBO.setSort(sort++);
                metadataTableTreeBOList.add(metadataTableTreeBO);
            }
        }
        return metadataTableTreeBOList;
    }

    public static CtpMetadataColumn convertMetadataColumnParamsToCtpMetadataColumn(Map<String, Object> params) {
        CtpMetadataColumn ctpMetadataColumn = null;
        if (params != null) {
            Long columnId = ParamUtil.getLong(params, "column_id", -1L);
            ctpMetadataColumn = new CtpMetadataColumn();
            if (columnId != -1L) {
                ctpMetadataColumn.setId(columnId);
                String createTimeStr = ParamUtil.getString(params, "create_time");
                if (Strings.isNotEmpty(createTimeStr)) {
                    ctpMetadataColumn.setCreateTime(Datetimes.parse(createTimeStr));
                }
            } else {
                ctpMetadataColumn.setNewId();
                ctpMetadataColumn.setCreateTime(DateUtil.currentDate());
            }
            ctpMetadataColumn.setIsPreset(ParamUtil.getInt(params, "is_preset", 0));
            ctpMetadataColumn.setLabel(ParamUtil.getString(params, "column_label"));
            ctpMetadataColumn.setName(ParamUtil.getString(params, "column_name"));
            ctpMetadataColumn.setAlias(ParamUtil.getString(params, "column_alias"));
            ctpMetadataColumn.setType(ParamUtil.getInt(params, "column_type", ColumnTypeEnum.Text.key()));
            ctpMetadataColumn.setDataType(ParamUtil.getInt(params, "data_type"));
            ctpMetadataColumn.setComponent(ParamUtil.getString(params, "component"));
            ctpMetadataColumn.setRule(ParamUtil.getString(params, "column_rule"));
            Integer isSeach = Integer.parseInt(ParamUtil.getString(params, "yes_rd", "0"));
            ctpMetadataColumn.setIsSeach(isSeach);
            Integer isShowinPersoninfo = Integer.parseInt(ParamUtil.getString(params, "yes_rd_pinfo", "0"));
            ctpMetadataColumn.setIsShowinPersoninfo(isShowinPersoninfo);
            Integer isShowinPersoncard = Integer.parseInt(ParamUtil.getString(params, "yes_rd_pcard", "1"));
            ctpMetadataColumn.setIsShowinPersoncard(isShowinPersoncard);
            Integer isShowinWorkflow = Integer.parseInt(ParamUtil.getString(params, "yes_rd_wf", "0"));
            ctpMetadataColumn.setIsShowinWorkflow(isShowinWorkflow);
            String isEnableStr = Strings.isNotEmpty(ParamUtil.getString(params, "normal_rd")) ? ParamUtil.getString(params, "normal_rd") : ParamUtil.getString(params, "invalidation_rd");
            ctpMetadataColumn.setIsEnable(Integer.parseInt(isEnableStr));
            ctpMetadataColumn.setCategoryId(ParamUtil.getLong(params, "category"));
            ctpMetadataColumn.setSort(ParamUtil.getInt(params, "sort_txt"));
            ctpMetadataColumn.setDescription(ParamUtil.getString(params, "description"));
            ctpMetadataColumn.setTableId(ParamUtil.getLong(params, "table_id"));
            ctpMetadataColumn.setUpdateTime(DateUtil.currentDate());
            ctpMetadataColumn.setCreateUser(ParamUtil.getLong(params, "create_user"));
            ctpMetadataColumn.setOrgAccountId(ParamUtil.getLong(params, "orgAccountId"));
            ctpMetadataColumn.setIsDelete(0);
        }
        return ctpMetadataColumn;
    }

    public static MetadataColumnBO convertToMetadataColumnBO(CtpMetadataColumn ctpMetadataColumn) {
        MetadataColumnBO metadataColumnBO = null;
        if (ctpMetadataColumn != null) {
            metadataColumnBO = new MetadataColumnBO();
            metadataColumnBO.setId(ctpMetadataColumn.getId());
            metadataColumnBO.setLabel(ctpMetadataColumn.getLabel());
            metadataColumnBO.setColumnName(ctpMetadataColumn.getName());
            metadataColumnBO.setAlias(ctpMetadataColumn.getAlias());
            metadataColumnBO.setType(ctpMetadataColumn.getType());
            metadataColumnBO.setDataType(ctpMetadataColumn.getDataType());
            metadataColumnBO.setRule(ctpMetadataColumn.getRule());
            metadataColumnBO.setComponent(ctpMetadataColumn.getComponent());
            metadataColumnBO.setSort(ctpMetadataColumn.getSort());
            metadataColumnBO.setIsSeach(ctpMetadataColumn.getIsSeach());
            metadataColumnBO.setIsShowinPersoninfo(ctpMetadataColumn.getIsShowinPersoninfo() == null ? 0 : ctpMetadataColumn.getIsShowinPersoninfo());
            metadataColumnBO.setIsShowinPersoncard(ctpMetadataColumn.getIsShowinPersoncard() == null ? 0 : ctpMetadataColumn.getIsShowinPersoncard());
            metadataColumnBO.setIsShowinWorkflow(ctpMetadataColumn.getIsShowinWorkflow() == null ? 0 : ctpMetadataColumn.getIsShowinWorkflow());
            metadataColumnBO.setStatus(ctpMetadataColumn.getIsEnable());
            String statusStr = ctpMetadataColumn.getIsEnable() == 1 ? ResourceUtil.getString("common.state.normal.label") : ResourceUtil.getString("common.state.invalidation.label");
            metadataColumnBO.setStatusStr(statusStr);
            metadataColumnBO.setDescription(ctpMetadataColumn.getDescription());
            metadataColumnBO.setTableId(ctpMetadataColumn.getTableId());
            metadataColumnBO.setCategoryId(ctpMetadataColumn.getCategoryId());
            metadataColumnBO.setCreateUser(ctpMetadataColumn.getCreateUser());
            metadataColumnBO.setCreateTime(ctpMetadataColumn.getCreateTime());
            metadataColumnBO.setUpdateTime(ctpMetadataColumn.getUpdateTime());
            metadataColumnBO.setIsEnable(ctpMetadataColumn.getIsEnable());
            metadataColumnBO.setIsPreset(ctpMetadataColumn.getIsPreset());
            metadataColumnBO.setIsDelete(ctpMetadataColumn.getIsDelete());
        }
        return metadataColumnBO;
    }

    public static List<MetadataColumnBO> convertToMetadataColumnBOList(List<CtpMetadataColumn> ctpMetadataColumnList) {
        ArrayList<MetadataColumnBO> metadataColumnBOList = new ArrayList<MetadataColumnBO>();
        if (CollectionUtils.isNotEmpty(ctpMetadataColumnList)) {
            for (CtpMetadataColumn ctpMetadataColumn : ctpMetadataColumnList) {
                MetadataColumnBO metadataColumnBO = ConvertMetadataUtil.convertToMetadataColumnBO(ctpMetadataColumn);
                metadataColumnBOList.add(metadataColumnBO);
            }
        }
        return metadataColumnBOList;
    }

    public static MetadataCategoryBO convertToMetadataCategoryBO(CtpMetadataCategory ctpMetadataCategory) {
        MetadataCategoryBO metadataCategoryBO = null;
        if (ctpMetadataCategory != null) {
            metadataCategoryBO = new MetadataCategoryBO();
            metadataCategoryBO.setId(ctpMetadataCategory.getId());
            metadataCategoryBO.setName(ctpMetadataCategory.getCateName());
            metadataCategoryBO.setModuleType(ctpMetadataCategory.getModuleType());
            metadataCategoryBO.setCreateUser(ctpMetadataCategory.getCreateUser());
            metadataCategoryBO.setUpdateTime(ctpMetadataCategory.getUpdateTime());
            metadataCategoryBO.setCreateTime(ctpMetadataCategory.getCreateTime());
        }
        return metadataCategoryBO;
    }

    public static List<MetadataCategoryBO> convertToMetadataCategoryBOList(List<CtpMetadataCategory> ctpMetadataCategoryList) {
        ArrayList<MetadataCategoryBO> metadataCategoryBOList = new ArrayList<MetadataCategoryBO>();
        if (CollectionUtils.isNotEmpty(ctpMetadataCategoryList)) {
            for (CtpMetadataCategory ctpMetadataCategory : ctpMetadataCategoryList) {
                MetadataCategoryBO metadataCategoryBO = ConvertMetadataUtil.convertToMetadataCategoryBO(ctpMetadataCategory);
                metadataCategoryBOList.add(metadataCategoryBO);
            }
        }
        return metadataCategoryBOList;
    }

    public static CtpMetadataCategory convertToCtpMetadataCategory(MetadataCategoryBO metadataCategoryBO) {
        CtpMetadataCategory ctpMetadataCategory = null;
        if (metadataCategoryBO != null) {
            ctpMetadataCategory = new CtpMetadataCategory();
            ctpMetadataCategory.setId(metadataCategoryBO.getId());
            ctpMetadataCategory.setCateName(metadataCategoryBO.getName());
            ctpMetadataCategory.setModuleType(metadataCategoryBO.getModuleType());
            ctpMetadataCategory.setCreateUser(metadataCategoryBO.getCreateUser());
            ctpMetadataCategory.setUpdateTime(metadataCategoryBO.getUpdateTime());
            ctpMetadataCategory.setCreateTime(metadataCategoryBO.getCreateTime());
        }
        return ctpMetadataCategory;
    }
}

