/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.metadata.manager;

import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.metadata.Column;
import com.seeyon.ctp.common.metadata.MetadataOldUtil;
import com.seeyon.ctp.common.metadata.Table;
import com.seeyon.ctp.common.metadata.bo.MetadataColumnBO;
import com.seeyon.ctp.common.metadata.enums.ColumnTypeEnum;
import com.seeyon.ctp.common.metadata.manager.MetadataColumnManager;
import com.seeyon.ctp.common.metadata.manager.MetadataManager;
import com.seeyon.ctp.common.metadata.manager.MetadataTableManager;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import java.util.List;

@ProcessInDataSource(name=DataSourceName.BASE)
public class MetadataManagerImpl
implements MetadataManager {
    private MetadataTableManager metadataTableManager;
    private MetadataColumnManager metadataColumnManager;

    @Override
    public Table getTable(String name) {
        return MetadataOldUtil.getTable(name);
    }

    @Override
    public Column getColumn(String tableName, String columnName) {
        return MetadataOldUtil.getColumn(tableName, columnName);
    }

    @Override
    public Column getColumnByAlias(String tableName, String columnAlias) {
        return MetadataOldUtil.getColumnByAlias(tableName, columnAlias);
    }

    @Override
    public String toJSON() {
        return MetadataOldUtil.toJSON();
    }

    @Override
    @AjaxAccess
    public String getAvailableColumn(String tableId, int type) throws BusinessException {
        if (Strings.isEmpty(tableId)) {
            return null;
        }
        List<MetadataColumnBO> columns = this.metadataColumnManager.getMetadataColumnList(Long.parseLong(tableId));
        int from = 1;
        int to = 10;
        switch (type) {
            case 1: {
                from = 11;
                to = 20;
                break;
            }
            case 2: {
                from = 21;
                to = 30;
                break;
            }
            case 3: {
                from = 31;
                to = 40;
                break;
            }
            case 4: {
                from = 41;
                to = 50;
                break;
            }
            case 5: {
                from = 51;
                to = 60;
                break;
            }
        }
        for (int i = from; i <= to; ++i) {
            String name = "EXT_ATTR_" + i;
            if (this.containsColumn(columns, name)) continue;
            return name;
        }
        return null;
    }

    private boolean containsColumn(List<MetadataColumnBO> columns, String name) {
        for (MetadataColumnBO column : columns) {
            if (!name.equals(column.getColumnName())) continue;
            return true;
        }
        return false;
    }

    public MetadataColumnManager getMetadataColumnManager() {
        return this.metadataColumnManager;
    }

    public void setMetadataColumnManager(MetadataColumnManager metadataColumnManager) {
        this.metadataColumnManager = metadataColumnManager;
    }

    public MetadataTableManager getMetadataTableManager() {
        return this.metadataTableManager;
    }

    public void setMetadataTableManager(MetadataTableManager metadataTableManager) {
        this.metadataTableManager = metadataTableManager;
    }

    @Override
    @AjaxAccess
    public String[] getAvailableColumns(String tableId) throws BusinessException {
        ColumnTypeEnum[] values = ColumnTypeEnum.values();
        int length = values.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            ColumnTypeEnum columnTypeEnum = values[i];
            int type = columnTypeEnum.key();
            result[type] = this.getAvailableColumn(tableId, type);
        }
        return result;
    }
}

