/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.metadata.manager;

import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.appLog.AppLogAction;
import com.seeyon.ctp.common.appLog.manager.AppLogManager;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.metadata.bo.MetadataCategoryBO;
import com.seeyon.ctp.common.metadata.bo.MetadataColumnBO;
import com.seeyon.ctp.common.metadata.dao.MetadataColumnDao;
import com.seeyon.ctp.common.metadata.event.MetadataColumnChangedEvent;
import com.seeyon.ctp.common.metadata.event.MetadataColumnDisableEvent;
import com.seeyon.ctp.common.metadata.manager.MetadataCategoryManager;
import com.seeyon.ctp.common.metadata.manager.MetadataColumnManager;
import com.seeyon.ctp.common.metadata.util.ConvertMetadataUtil;
import com.seeyon.ctp.common.po.metadata.CtpMetadataColumn;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ProcessInDataSource(name=DataSourceName.BASE)
public class MetadataColumnManagerImpl
extends AbstractSystemInitializer
implements MetadataColumnManager {
    private static final Log log = LogFactory.getLog(MetadataColumnManagerImpl.class);
    private MetadataColumnDao metadataColumnDao;
    private AppLogManager appLogManager;
    private MetadataCategoryManager metadataCategoryManager;
    private CacheMap<Long, CtpMetadataColumn> cache;
    private EnumManager enumManagerNew;

    @Override
    public void initialize() {
        CacheAccessable factory = CacheFactory.getInstance(MetadataColumnManager.class);
        this.cache = factory.createMap("MetadataColumn");
        List<CtpMetadataColumn> all = this.metadataColumnDao.findAll();
        for (CtpMetadataColumn column : all) {
            if (column.getIsDelete() == 1) continue;
            this.cache.put(column.getId(), column);
        }
    }

    private List<CtpMetadataColumn> getColumnListFromCache(FlipInfo fi, Map<String, Object> params) {
        Long tableId = (Long)params.get("tableId");
        Long categoryId = (Long)params.get("categoryId");
        Integer isEnable = (Integer)params.get("isEnable");
        Integer type = (Integer)params.get("type");
        String label = (String)params.get("label");
        ArrayList<CtpMetadataColumn> result = new ArrayList<CtpMetadataColumn>();
        for (CtpMetadataColumn column : this.cache.values()) {
            if (tableId != null && !tableId.equals(column.getTableId()) || isEnable != null && !isEnable.equals(column.getIsEnable()) || type != null && !type.equals(column.getType()) || Strings.isNotBlank(label) && column.getLabel().indexOf(label) < 0 || categoryId != null && !categoryId.equals(column.getCategoryId())) continue;
            result.add(column);
        }
        return DBAgent.memoryPaging(result, fi);
    }

    public AppLogManager getAppLogManager() {
        return this.appLogManager;
    }

    public void setAppLogManager(AppLogManager appLogManager) {
        this.appLogManager = appLogManager;
    }

    public MetadataColumnDao getMetadataColumnDao() {
        return this.metadataColumnDao;
    }

    public MetadataCategoryManager getMetadataCategoryManager() {
        return this.metadataCategoryManager;
    }

    public void setMetadataCategoryManager(MetadataCategoryManager metadataCategoryManager) {
        this.metadataCategoryManager = metadataCategoryManager;
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    @Override
    public Boolean createMetadataColumn(Map<String, Object> params) throws BusinessException {
        CtpMetadataColumn ctpMetadataColumn = ConvertMetadataUtil.convertMetadataColumnParamsToCtpMetadataColumn(params);
        boolean isRe = this.checkReName(ctpMetadataColumn);
        if (isRe) {
            String message = ResourceUtil.getString("addressbook.fieldset.name.repeated");
            throw new BusinessException(message);
        }
        this.updateMetadataColumnSortByInsertSort(params, ctpMetadataColumn);
        ctpMetadataColumn.setOrgAccountId(AppContext.currentAccountId());
        Long id = this.metadataColumnDao.createCtpMetadataColumn(ctpMetadataColumn);
        Boolean bool = id != -1L;
        this.cache.put(id, ctpMetadataColumn);
        if (ctpMetadataColumn.getType() == 3) {
            String rule = ctpMetadataColumn.getRule();
            Map map = new HashMap();
            try {
                map = (Map)JSONUtil.parseJSONString(rule);
                Long eId = Long.valueOf((String)map.get("codeId"));
                this.enumManagerNew.updateEnumRef(eId);
            }
            catch (Exception e) {
                log.error((Object)(ctpMetadataColumn.getLabel() + " \u5f15\u7528\u7684\u679a\u4e3e\u89c4\u5219\u683c\u5f0f\u4e0d\u662f\u6709\u6548\u7684json\u683c\u5f0f"));
            }
        }
        int moduleType = this.getModuleType(ctpMetadataColumn.getCategoryId());
        MetadataColumnChangedEvent event = new MetadataColumnChangedEvent(this);
        event.setCtpMetadataColumn(ctpMetadataColumn);
        EventDispatcher.fireEvent(event);
        this.insertMetaDateColumnLog(moduleType, ctpMetadataColumn.getLabel());
        return bool;
    }

    @Override
    public Boolean updateCtpMetadataColumn(Map<String, Object> params) throws BusinessException {
        Event event;
        CtpMetadataColumn ctpMetadataColumn = ConvertMetadataUtil.convertMetadataColumnParamsToCtpMetadataColumn(params);
        boolean isRe = this.checkReName(ctpMetadataColumn);
        if (isRe) {
            String message = ResourceUtil.getString("addressbook.fieldset.name.repeated");
            throw new BusinessException(message);
        }
        boolean isDisable = false;
        CtpMetadataColumn oldCtpMetadataColumn = new CtpMetadataColumn();
        if (null != ctpMetadataColumn && (oldCtpMetadataColumn = this.metadataColumnDao.getById(ctpMetadataColumn.getId())).getIsEnable() == 1 && ctpMetadataColumn.getIsEnable() == 0) {
            isDisable = true;
        }
        this.updateMetadataColumnSortByInsertSort(params, ctpMetadataColumn);
        ctpMetadataColumn.setOrgAccountId(AppContext.currentAccountId());
        this.metadataColumnDao.updateCtpMetadataColumn(ctpMetadataColumn);
        this.cache.put(ctpMetadataColumn.getId(), ctpMetadataColumn);
        if (ctpMetadataColumn.getType() == 3) {
            String rule = ctpMetadataColumn.getRule();
            Map map = new HashMap();
            try {
                map = (Map)JSONUtil.parseJSONString(rule);
                Long eId = Long.valueOf((String)map.get("codeId"));
                this.enumManagerNew.updateEnumRef(eId);
            }
            catch (Exception e) {
                log.error((Object)(ctpMetadataColumn.getLabel() + " \u5f15\u7528\u7684\u679a\u4e3e\u89c4\u5219\u683c\u5f0f\u4e0d\u662f\u6709\u6548\u7684json\u683c\u5f0f"));
            }
        }
        if (ctpMetadataColumn.getIsEnable() == 0) {
            event = new MetadataColumnDisableEvent(this);
            ((MetadataColumnDisableEvent)event).setCtpMetadataColumn(ctpMetadataColumn);
            ((MetadataColumnDisableEvent)event).setOrgAccountId(ctpMetadataColumn.getCreateUser());
            ((MetadataColumnDisableEvent)event).setTableId(ctpMetadataColumn.getTableId());
            EventDispatcher.fireEvent(event);
        }
        event = new MetadataColumnChangedEvent(this);
        ((MetadataColumnChangedEvent)event).setCtpMetadataColumn(ctpMetadataColumn);
        EventDispatcher.fireEvent(event);
        int moduleType = this.getModuleType(ctpMetadataColumn.getCategoryId());
        if (isDisable) {
            this.disableMetaDateColumnLog(moduleType, ctpMetadataColumn.getLabel());
        } else {
            this.updateMetaDateColumnLog(moduleType, ctpMetadataColumn.getLabel());
        }
        return true;
    }

    @Override
    public FlipInfo findCtpMetadataColumnList(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        if (MapUtils.isNotEmpty(params)) {
            fi.setParams(params);
        }
        this.filterQueryParam(params);
        List<CtpMetadataColumn> metadataColumnList = this.getColumnListFromCache(fi, params);
        Collections.sort(metadataColumnList, new Comparator<CtpMetadataColumn>(){

            @Override
            public int compare(CtpMetadataColumn o1, CtpMetadataColumn o2) {
                return o1.getSort().compareTo(o2.getSort());
            }
        });
        List<MetadataColumnBO> metadataColumnBOList = ConvertMetadataUtil.convertToMetadataColumnBOList(metadataColumnList);
        if (CollectionUtils.isNotEmpty(metadataColumnBOList) && fi != null) {
            fi.setData(metadataColumnBOList);
        }
        return fi;
    }

    @Override
    public List<MetadataColumnBO> getMetadataColumnList(final Long tableId) throws BusinessException {
        if (tableId == null) {
            return null;
        }
        FlipInfo fi = new FlipInfo();
        fi.setSize(999999);
        List<CtpMetadataColumn> metadataColumnList = this.getColumnListFromCache(fi, new HashMap(){
            {
                this.put("tableId", tableId);
            }
        });
        List<MetadataColumnBO> metadataColumnBOList = ConvertMetadataUtil.convertToMetadataColumnBOList(metadataColumnList);
        return metadataColumnBOList;
    }

    @Override
    public Integer getMaxColumnSort(String tableIdStr) throws BusinessException {
        Long tableId = Strings.isNotEmpty(tableIdStr) ? Long.parseLong(tableIdStr) : -1L;
        return this.metadataColumnDao.getMaxColumnSort(tableId);
    }

    @Override
    public String getCtpMetadataColumnToJSON(String columnIdStr) throws BusinessException {
        String jsonStr = null;
        Long columnId = Strings.isNotEmpty(columnIdStr) ? Long.parseLong(columnIdStr) : -1L;
        MetadataColumnBO metadataColumnBO = this.getCtpMetadataColumnById(columnId);
        if (metadataColumnBO != null) {
            jsonStr = JSONUtil.toJSONString(metadataColumnBO);
        }
        return jsonStr;
    }

    @Override
    public void deleteColumn(String idStr) throws BusinessException {
        String disabledLabels = "";
        if (Strings.isNotEmpty(idStr)) {
            Long tableId = null;
            Long orgAccountId = null;
            String[] idArray = idStr.split(",");
            ArrayList<Long> idList = new ArrayList<Long>();
            for (int i = 0; i < idArray.length; ++i) {
                idList.add(Long.parseLong(idArray[i]));
                CtpMetadataColumn ctpMetadataColumn = this.metadataColumnDao.getById(Long.parseLong(idArray[i]));
                orgAccountId = ctpMetadataColumn.getCreateUser();
                tableId = ctpMetadataColumn.getTableId();
                Long categoryId = ctpMetadataColumn.getCategoryId();
                int moduleType = this.getModuleType(categoryId);
                this.deleteMetaDateColumnLog(moduleType, ctpMetadataColumn.getLabel());
                disabledLabels = "".equals(disabledLabels) ? ctpMetadataColumn.getName() : disabledLabels + "," + ctpMetadataColumn.getName();
                MetadataColumnChangedEvent event = new MetadataColumnChangedEvent(this);
                event.setCtpMetadataColumn(ctpMetadataColumn);
                EventDispatcher.fireEvent(event);
            }
            this.metadataColumnDao.deleteColumn(idList);
            this.cache.removeAll(idList);
            MetadataColumnDisableEvent event = new MetadataColumnDisableEvent(this);
            event.setDisabledLabels(disabledLabels.split(","));
            event.setOrgAccountId(orgAccountId);
            event.setTableId(tableId);
            EventDispatcher.fireEvent(event);
        }
    }

    private void filterQueryParam(Map<String, Object> params) {
        if (MapUtils.isNotEmpty(params)) {
            if (Strings.isNotBlank(ParamUtil.getString(params, "tableId"))) {
                params.put("tableId", ParamUtil.getLong(params, "tableId"));
            }
            if (Strings.isNotBlank(ParamUtil.getString(params, "isEnable"))) {
                params.put("isEnable", ParamUtil.getInt(params, "isEnable"));
            }
            if (Strings.isNotBlank(ParamUtil.getString(params, "type"))) {
                params.put("type", ParamUtil.getInt(params, "type"));
            }
            if (Strings.isNotBlank(ParamUtil.getString(params, "categoryId"))) {
                params.put("categoryId", ParamUtil.getLong(params, "categoryId"));
            }
        }
    }

    private void updateMetadataColumnSortByInsertSort(Map<String, Object> params, CtpMetadataColumn ctpMetadataColumn) throws BusinessException {
        boolean isInsert = ParamUtil.getInt(params, "insert_rd", 0) == 1;
        Long columnId = ctpMetadataColumn.getId();
        Integer sort = ctpMetadataColumn.getSort();
        Long tableId = ctpMetadataColumn.getTableId();
        if (isInsert && (!this.cache.contains(columnId) || this.cache.contains(columnId) && !this.cache.get(columnId).getSort().equals(sort))) {
            this.metadataColumnDao.updateMetadataColumnSort(sort, tableId);
            for (CtpMetadataColumn column : this.cache.values()) {
                Integer oldSort;
                if (tableId != null && !tableId.equals(column.getTableId()) || (oldSort = column.getSort()) < sort) continue;
                column.setSort(oldSort + 1);
            }
        }
    }

    @Override
    public MetadataColumnBO getCtpMetadataColumnById(Long columnId) throws BusinessException {
        CtpMetadataColumn ctpMetadataColumn = this.cache.get(columnId);
        if (ctpMetadataColumn == null && (ctpMetadataColumn = this.metadataColumnDao.getById(columnId)) == null) {
            return null;
        }
        MetadataColumnBO metadataColumnBO = ConvertMetadataUtil.convertToMetadataColumnBO(ctpMetadataColumn);
        return metadataColumnBO;
    }

    public void setMetadataColumnDao(MetadataColumnDao metadataColumnDao) {
        this.metadataColumnDao = metadataColumnDao;
    }

    private int getModuleType(Long categoryId) throws BusinessException {
        MetadataCategoryBO metadataCategoryBO = this.metadataCategoryManager.getCategoryById(categoryId);
        return metadataCategoryBO.getModuleType();
    }

    private void insertMetaDateColumnLog(int moduleType, String label) {
        if (moduleType == 14) {
            this.insertLog(AppLogAction.Organization_NewAddressBookField, label);
        }
    }

    private void updateMetaDateColumnLog(int moduleType, String label) {
        if (moduleType == 14) {
            this.insertLog(AppLogAction.Organization_UpdateAddressBookField, label);
        }
    }

    private void disableMetaDateColumnLog(int moduleType, String label) {
        if (moduleType == 14) {
            this.insertLog(AppLogAction.Organization_DisEnableAddressBookField, label);
        }
    }

    private void deleteMetaDateColumnLog(int moduleType, String label) {
        if (moduleType == 14) {
            this.insertLog(AppLogAction.Organization_DeleteAddressBookField, label);
        }
    }

    private void insertLog(AppLogAction action, String label) {
        this.appLogManager.insertLog(AppContext.getCurrentUser(), action, AppContext.getCurrentUser().getName(), label);
    }

    private boolean checkReName(CtpMetadataColumn ctpMetadataColumn) throws BusinessException {
        FlipInfo fi = new FlipInfo();
        fi.setSize(999999);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", ctpMetadataColumn.getCategoryId());
        List list = this.findCtpMetadataColumnList(fi, params).getData();
        for (MetadataColumnBO old : list) {
            if (!old.getLabel().equals(ctpMetadataColumn.getLabel()) || old.getId().compareTo(ctpMetadataColumn.getId()) == 0) continue;
            return true;
        }
        return false;
    }
}

