/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.metadata;

import com.seeyon.ctp.common.metadata.Column;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Table {
    private String name;
    private String className;
    private final List<Column> columns = new ArrayList<Column>();
    private final Map<String, Column> columnMap = new HashMap<String, Column>();

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Table() {
    }

    public Table(Collection<Column> columns) {
        this();
        for (Column column : columns) {
            this.columns.add(column);
            this.columnMap.put(column.getName(), column);
            column.setTable(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Column getColumn(String name) {
        return this.columnMap.get(name);
    }

    public Column getColumnByAlias(String alias) {
        if (alias == null) {
            return null;
        }
        for (Map.Entry<String, Column> entry : this.columnMap.entrySet()) {
            Column column = entry.getValue();
            if (!alias.equals(column.getAlias())) continue;
            return column;
        }
        return null;
    }
}

