/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.log;

import com.seeyon.ctp.common.log.Log4j2XMLConfig;
import com.seeyon.ctp.common.log.LogInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LogTool {
    private static Map<String, String> logMap = Log4j2XMLConfig.getInstance().getDefaultLogMap();

    public static List<Logger> getLoggers() {
        Set<String> keySet = logMap.keySet();
        ArrayList<Logger> loggerList = new ArrayList<Logger>(logMap.size());
        for (String key : keySet) {
            loggerList.add(LogManager.getLogger((String)key));
        }
        return loggerList;
    }

    public static List<LogInfo> getLogInfos() {
        List<Logger> loggerList = LogTool.getLoggers();
        ArrayList<LogInfo> logInfoList = new ArrayList<LogInfo>(logMap.size());
        for (int i = 0; i < loggerList.size(); ++i) {
            Logger logger = loggerList.get(i);
            if (null == logger.getLevel()) continue;
            LogInfo bean = new LogInfo();
            String name = logger.getName();
            bean.setName(name);
            bean.setLevel(logger.getLevel().toString());
            bean.setInitLevel(logMap.get(name).toUpperCase());
            logInfoList.add(bean);
        }
        return logInfoList;
    }

    public static void updateLevels() {
        for (Map.Entry<String, String> entry : logMap.entrySet()) {
            String loggerName = entry.getKey();
            Level level = LogTool.switchLevel(entry.getValue());
            Logger logger = LogManager.getLogger((String)loggerName);
            if (null == logger.getLevel()) continue;
            logger.setLevel(level);
        }
    }

    public static void updateLevel(String loggerName, String loggerLevel) {
        Logger logger = LogManager.getLogger((String)loggerName);
        logger.setLevel(LogTool.switchLevel(loggerLevel));
    }

    private static Level switchLevel(String loggerLevel) {
        if (loggerLevel.equalsIgnoreCase("OFF")) {
            return Level.OFF;
        }
        if ("FATAL".equalsIgnoreCase(loggerLevel)) {
            return Level.FATAL;
        }
        if ("ERROR".equalsIgnoreCase(loggerLevel)) {
            return Level.ERROR;
        }
        if ("WARN".equalsIgnoreCase(loggerLevel)) {
            return Level.WARN;
        }
        if ("INFO".equalsIgnoreCase(loggerLevel)) {
            return Level.INFO;
        }
        if ("DEBUG".equalsIgnoreCase(loggerLevel)) {
            return Level.DEBUG;
        }
        if ("TRACE".equalsIgnoreCase(loggerLevel)) {
            return Level.TRACE;
        }
        if ("ALL".equalsIgnoreCase(loggerLevel)) {
            return Level.ALL;
        }
        return Level.ALL;
    }
}

