/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class I18nUtil {
    private static final Log log = CtpLogFactory.getLog(I18nUtil.class);
    private static List<Locale> defaultLocals = null;

    public static String getLocalAsString(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder sb = new StringBuilder();
        if (Strings.isNotEmpty(variant)) {
            sb.append(language).append('_').append(country.toUpperCase()).append('_').append(variant);
        } else if (Strings.isNotEmpty(country)) {
            sb.append(language).append('_').append(country.toUpperCase());
        } else {
            sb.append(language);
        }
        return sb.toString();
    }

    public static Locale parseLocale(String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            return null;
        }
        String[] localeArray = language.split("[-|_]");
        String country = "";
        String variant = "";
        for (int i = 0; i < localeArray.length; ++i) {
            if (i == 0) {
                language = localeArray[i];
                continue;
            }
            if (i == 1) {
                country = localeArray[i];
                continue;
            }
            if (i != 2) continue;
            variant = localeArray[i];
        }
        return new Locale(language, country, variant);
    }

    public static String getLevelTypeName(String levelType) {
        String ret = "";
        if ("custom".equals(levelType)) {
            ret = "\u81ea\u5b9a\u4e49";
        } else if ("product".equals(levelType)) {
            ret = "\u4ea7\u54c1";
        } else if ("common".equals(levelType)) {
            ret = "\u516c\u5171";
        } else if ("plugin".equals(levelType)) {
            ret = "\u63d2\u4ef6";
        } else if ("default".equals(levelType)) {
            ret = "\u9ed8\u8ba4";
        }
        return ret;
    }

    public static List<Locale> getLeastLocales(List<Locale> locales) {
        if (locales == null) {
            locales = new ArrayList<Locale>();
        }
        for (Locale l : defaultLocals) {
            if (locales.contains(l)) continue;
            locales.add(l);
        }
        return locales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readCustomJs(File customFile) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (customFile != null && customFile.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(customFile), "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    int index;
                    if (!StringUtils.isNotBlank((CharSequence)line) || (index = line.indexOf("=")) == -1) continue;
                    String key = line.substring(0, index);
                    String value = line.substring(index + 1, line.length());
                    ret.put(key, value);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCustomJs(Map<String, String> items, File customFile) {
        BufferedWriter writer = null;
        try {
            if (!items.isEmpty()) {
                Set<String> keys = items.keySet();
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(customFile), "UTF-8"));
                for (String key : keys) {
                    writer.write(key + "=" + items.get(key));
                    writer.newLine();
                }
                writer.flush();
            }
        }
        catch (Exception e) {
            log.error((Object)"\u4fdd\u5b58\u81ea\u5b9a\u4e49js\u56fd\u9645\u5316\u62a5\u9519", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String escapeJavascript(String str) {
        if (str == null) {
            return str;
        }
        StringBuilder out = new StringBuilder();
        int sz = str.length();
        block13: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.append('\\');
                        out.append('b');
                        break;
                    }
                    case '\n': {
                        out.append('\\');
                        out.append('n');
                        break;
                    }
                    case '\t': {
                        out.append('\\');
                        out.append('t');
                        break;
                    }
                    case '\f': {
                        out.append('\\');
                        out.append('f');
                        break;
                    }
                    case '\r': {
                        out.append('\\');
                        out.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.append("\\u00" + I18nUtil.hex(ch));
                            break;
                        }
                        out.append("\\u000" + I18nUtil.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    out.append('\\');
                    out.append('\'');
                    continue block13;
                }
                case '\"': {
                    out.append("\\\"");
                    continue block13;
                }
                case '\\': {
                    out.append('\\');
                    out.append('\\');
                    continue block13;
                }
                case '/': {
                    out.append("\\/");
                    continue block13;
                }
                default: {
                    out.append(ch);
                }
            }
        }
        return out.toString();
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }

    public static void uploadJsFile(File jsFile, String content, boolean fromSrcFile) {
        if (jsFile.exists()) {
            boolean copyRet;
            String fileName = jsFile.getName();
            File parent = jsFile.getParentFile();
            File srcBack = new File(parent, fileName + ".src.bak.byauto");
            if (!srcBack.exists() && !(copyRet = FileUtil.copyFile(jsFile, srcBack))) {
                log.warn((Object)"\u5907\u4efdJS\u6587\u4ef6\u5931\u8d25");
                return;
            }
            File newBack = new File(parent, fileName + ".temp");
            boolean ret = false;
            ret = fromSrcFile ? FileUtil.copyFileAndAddContent(srcBack, newBack, content) : FileUtil.copyFileAndAddContent(jsFile, newBack, content);
            if (ret) {
                boolean doBack;
                File bakFile = new File(parent, fileName + ".bak.byauto");
                if (bakFile.exists()) {
                    bakFile.delete();
                }
                if (doBack = jsFile.renameTo(bakFile)) {
                    newBack.renameTo(jsFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> parseJSONFile(File defFile) {
        Map defs = null;
        if (defFile.exists() && defFile.isFile()) {
            BufferedReader reader = null;
            try {
                StringBuilder defData = new StringBuilder();
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(defFile), "UTF-8"));
                String line = null;
                boolean isMultiComment = false;
                int last = 32;
                String whiteSpaceChars = " \t\r\n\f";
                while ((line = reader.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    for (int i = 0; i < line.length(); ++i) {
                        char c = line.charAt(i);
                        if (whiteSpaceChars.indexOf(c) == -1) {
                            if (isMultiComment) {
                                if (c == '/' && last == 42) {
                                    isMultiComment = false;
                                }
                            } else if (c == '*' && last == 47) {
                                isMultiComment = true;
                                defData.delete(defData.length() - 1, defData.length());
                            } else {
                                defData.append(c);
                            }
                        }
                        last = c;
                    }
                }
                defs = JSONUtil.parseJSONString(defData.toString(), Map.class);
            }
            catch (Exception e) {
                log.error((Object)("\u9519\u8bef\u683c\u5f0f\u6587\u4ef6\uff1a" + defFile.getAbsolutePath()));
                log.error((Object)"", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"", (Throwable)e);
                    }
                }
            }
        }
        return defs;
    }

    static {
        defaultLocals = new ArrayList<Locale>(3);
        defaultLocals.add(new Locale("en"));
        defaultLocals.add(new Locale("zh", "CN"));
        defaultLocals.add(new Locale("zh", "TW"));
    }
}

