/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.pager;

import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.pager.PageParameter;
import com.seeyon.ctp.util.FlipInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;

public class PageUtil {
    public static List<ResourceInfo> selectDataList(List<ResourceInfo> dataList, Predicate predicate) {
        ArrayList selected = (ArrayList)CollectionUtils.select(dataList, (Predicate)predicate);
        if (selected == null) {
            selected = new ArrayList();
        }
        return selected;
    }

    public static List<Map<Locale, ResourceInfo>> selectDataList4Key(List<Map<Locale, ResourceInfo>> dataList, Predicate<Map<Locale, ResourceInfo>> predicate) {
        ArrayList selected = (ArrayList)CollectionUtils.select(dataList, predicate);
        if (selected == null) {
            selected = new ArrayList();
        }
        return selected;
    }

    public static void updatePager(List<ResourceInfo> dataList, FlipInfo flipInfo) {
        if (flipInfo == null) {
            flipInfo = new FlipInfo();
        }
        flipInfo.setTotal(dataList.size());
    }

    public static List<ResourceInfo> limitDataList(FlipInfo flipInfo, List<ResourceInfo> dataList) {
        int start = (flipInfo.getPage() - 1) * flipInfo.getSize();
        int end = start + flipInfo.getSize();
        int size = dataList.size();
        start = start > size ? size : start;
        end = end > size ? size : end;
        return dataList.subList(start, end);
    }

    public static void updatePageParameter(List<?> dataList, PageParameter parameter) {
        if (parameter == null) {
            parameter = new PageParameter();
        }
        parameter.setTotalSize(dataList.size());
        parameter.setTotalPage(parameter.getTotalSize() / parameter.getPageSize() + 1);
    }

    public static List<ResourceInfo> limitDataList(PageParameter parameter, List<ResourceInfo> dataList) {
        int start = (parameter.getCurPage() - 1) * parameter.getPageSize();
        int end = start + parameter.getPageSize();
        int size = dataList.size();
        start = start > size ? size : start;
        end = end > size ? size : end;
        return dataList.subList(start, end);
    }

    public static List<Map<Locale, ResourceInfo>> limitDataList4Key(PageParameter parameter, List<Map<Locale, ResourceInfo>> infos) {
        int start = (parameter.getCurPage() - 1) * parameter.getPageSize();
        int end = start + parameter.getPageSize();
        int size = infos.size();
        start = start > size ? size : start;
        end = end > size ? size : end;
        return infos.subList(start, end);
    }

    public static void sortDataList(List<ResourceInfo> dataList) {
        Collections.sort(dataList, PageUtil.newResourceInfoComparator());
    }

    public static void sortDataList4Key(List<Map<Locale, ResourceInfo>> dataList) {
        Collections.sort(dataList, PageUtil.newResourceInfoComparator4Key());
    }

    public static Predicate newResourceInfoPredicate_Key(final String key) {
        return new Predicate(){

            public boolean evaluate(Object item) {
                ResourceInfo info;
                boolean pass = false;
                if (item != null && (info = (ResourceInfo)item).getKey() != null && info.getKey().equals(key)) {
                    pass = true;
                }
                return pass;
            }
        };
    }

    public static Predicate newResourceInfoPredicate_Value(final String value) {
        return new Predicate(){

            public boolean evaluate(Object item) {
                ResourceInfo info;
                boolean pass = false;
                if (item != null && (info = (ResourceInfo)item).getValue() != null && info.getValue().contains(value)) {
                    pass = true;
                }
                return pass;
            }
        };
    }

    public static Predicate newResourceInfoPredicate_Path(final String relativePath) {
        return new Predicate(){

            public boolean evaluate(Object item) {
                ResourceInfo info;
                boolean pass = false;
                if (item != null && (info = (ResourceInfo)item).getRelativePath() != null && info.getRelativePath().startsWith(relativePath)) {
                    pass = true;
                }
                return pass;
            }
        };
    }

    public static Predicate newResourceInfoPredicate_LevelType(final String levelType) {
        return new Predicate(){

            public boolean evaluate(Object item) {
                ResourceInfo info;
                boolean pass = false;
                if (item != null && (info = (ResourceInfo)item).getLevelType() != null && info.getLevelType().equals(levelType)) {
                    pass = true;
                }
                return pass;
            }
        };
    }

    public static Predicate<Map<Locale, ResourceInfo>> newResourceInfoPredicate_LevelType4Key(final String levelType) {
        return new Predicate<Map<Locale, ResourceInfo>>(){

            public boolean evaluate(Map<Locale, ResourceInfo> item) {
                ResourceInfo info;
                boolean pass = false;
                if (item != null && item.size() > 0 && (info = item.values().iterator().next()).getLevelType() != null && info.getLevelType().equals(levelType)) {
                    pass = true;
                }
                return pass;
            }
        };
    }

    public static Predicate newResourceInfoPredicate_All() {
        return new Predicate(){

            public boolean evaluate(Object item) {
                boolean pass = false;
                if (item != null) {
                    pass = true;
                }
                return pass;
            }
        };
    }

    public static Comparator<ResourceInfo> newResourceInfoComparator() {
        return new Comparator<ResourceInfo>(){

            @Override
            public int compare(ResourceInfo left, ResourceInfo right) {
                if (left != null && right != null && left.getKey() != null && right.getKey() != null) {
                    return left.getKey().compareTo(right.getKey());
                }
                return -1;
            }
        };
    }

    public static Comparator<Map<Locale, ResourceInfo>> newResourceInfoComparator4Key() {
        return new Comparator<Map<Locale, ResourceInfo>>(){

            @Override
            public int compare(Map<Locale, ResourceInfo> leftMap, Map<Locale, ResourceInfo> rightMap) {
                Collection<ResourceInfo> rights;
                ResourceInfo left = null;
                ResourceInfo right = null;
                Collection<ResourceInfo> lefts = leftMap.values();
                if (lefts.size() > 0) {
                    left = lefts.iterator().next();
                }
                if ((rights = rightMap.values()).size() > 0) {
                    right = rights.iterator().next();
                }
                if (left != null && right != null && left.getKey() != null && right.getKey() != null) {
                    return left.getKey().compareTo(right.getKey());
                }
                return -1;
            }
        };
    }
}

