/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.m3;

import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.m3.M3I18nLoaderManager;
import com.seeyon.ctp.common.i18n.m3.M3I18nResourceCacheHolder;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class M3I18nUtile {
    public static void cacheM3AppI18nResouce(Locale locale, Map<String, String> items, String i18nFilePath, String i18nFileName, M3I18nLoaderManager.M3ZipFileInfo zipFileInfo) {
        Set<String> keys = items.keySet();
        for (String key : keys) {
            M3I18nUtile.addResource2Cache(locale, "default", key, items.get(key), i18nFilePath, i18nFileName, zipFileInfo);
        }
    }

    public static void addResource2Cache(Locale locale, String levelType, String key, String value, String appID, String i18nFilePath, String i18nFileName) {
        M3I18nLoaderManager.M3ZipFileInfo m3ZipFileInfo = M3I18nLoaderManager.getInstance().getM3ZipInfoByAppID(appID);
        if (m3ZipFileInfo == null) {
            return;
        }
        M3I18nUtile.addResource2Cache(locale, levelType, key, value, i18nFilePath, i18nFileName, m3ZipFileInfo);
    }

    private static void addResource2Cache(Locale locale, String levelType, String key, String valuse, String i18nFilePath, String i18nFileName, M3I18nLoaderManager.M3ZipFileInfo zipFileInfo) {
        String appID = zipFileInfo.getAppID();
        String zipFilePath = zipFileInfo.getZipFilePath();
        String zipFileRevPath = zipFileInfo.getZipFileRevPath();
        ResourceInfo info = new ResourceInfo();
        info.setKey(key);
        info.setUniqueKey(appID + "|" + i18nFileName + "|" + key);
        info.setValue(valuse);
        info.setLocale(locale);
        info.setLevelType(levelType);
        info.setModule("M3_" + appID);
        info.setAppId(appID);
        info.setM3(true);
        info.setFileName(i18nFileName);
        info.setFilePath(i18nFilePath);
        info.setZipFile(zipFilePath);
        info.setM3ZipRelativePath(zipFileRevPath);
        M3I18nResourceCacheHolder.saveOrUpdateM3ResourceInfo(locale, info, false);
        M3I18nResourceCacheHolder.saveOrUpdateM3ZipResourceInfo(locale, info, false);
    }
}

