/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.m3;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class M3I18nPathUtil {
    private static final Log log = CtpLogFactory.getLog(M3I18nPathUtil.class);
    public static final String C_sM3I18n_CustomFileName = "custom_m3I18n";
    private static final String m3ZipDir = "m3files";
    private static final String m3DestZip = "apps";
    private static final String m3Base = "m3";
    private static final String m3TempDir = "m3" + File.separator + "m3_i18n_temp";
    private static final String m3CustomI18n = "m3" + File.separator + "m3_i18n";

    public static String getM3I8nCustomRootPath() {
        try {
            return SystemEnvironment.getPartitionPublicFolder() + File.separator + m3CustomI18n;
        }
        catch (Exception e) {
            log.error((Object)("M3\u56fd\u9645\u5316\uff1a\u83b7\u53d6\u5171\u4eab\u76ee\u5f55\u4f4d\u7f6e\u51fa\u9519" + e.getMessage()));
            return null;
        }
    }

    public static String getM3I18nCustomPathByLocal(Locale locale) {
        String path = "";
        try {
            path = M3I18nPathUtil.getM3I8nCustomRootPath() + M3I18nPathUtil.getM3I18nCustomRelativePath(locale);
            File file = new File(path);
            if (!file.exists() && !file.isDirectory()) {
                new File(file.getParent()).mkdirs();
                file.createNewFile();
            }
        }
        catch (IOException e) {
            log.error((Object)("M3\u56fd\u9645\u5316\uff1a" + e.getMessage()));
        }
        return path;
    }

    public static String getM3I18nCustomRelativePath(Locale locale) {
        return File.separator + C_sM3I18n_CustomFileName + "_" + I18nUtil.getLocalAsString(locale) + ".properties";
    }

    public static String getM3I18nTempDirPathAbs() {
        return SystemEnvironment.getSystemTempFolder() + File.separator + m3TempDir;
    }

    public static String getM3ZipDestDirAbs(String model) {
        return M3I18nPathUtil.getM3ZipDirAbs() + File.separator + model;
    }

    public static String getM3ZipDirAbs() {
        return SystemEnvironment.getApplicationFolder() + File.separator + m3ZipDir;
    }

    public static String formatM3In8nFileName(String format, Locale loc) {
        String language = loc.getLanguage();
        String country = loc.getCountry();
        String variant = loc.getVariant();
        StringBuilder ret = new StringBuilder(language);
        if (StringUtils.isNotBlank((CharSequence)country)) {
            ret.append(format).append(country);
        }
        if (StringUtils.isNotBlank((CharSequence)variant)) {
            ret.append(format).append(variant);
        }
        return ret.toString();
    }
}

