/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n;

import com.seeyon.ctp.common.i18n.ResourceCache;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

class LocalResourceCache
extends ResourceCache {
    private static final Map<Locale, Map<String, ResourceInfo>> cacheMap = new ConcurrentHashMap<Locale, Map<String, ResourceInfo>>();

    LocalResourceCache() {
    }

    @Override
    public Map<String, ResourceInfo> get(Locale loc) {
        Map<String, ResourceInfo> cache = cacheMap.get(loc);
        if (cache == null) {
            cache = new HashMap<String, ResourceInfo>();
            cacheMap.put(loc, cache);
        }
        return cache;
    }

    @Override
    public void put(Locale locale, Map<String, ResourceInfo> resourceMap) {
        if (locale != null) {
            cacheMap.get(locale).putAll(resourceMap);
        }
    }

    @Override
    public Set<Locale> keySet() {
        return cacheMap.keySet();
    }

    @Override
    public String getValue(Locale loc, String key) {
        Map<String, ResourceInfo> map = this.get(loc);
        if (map == null) {
            return null;
        }
        ResourceInfo info = map.get(key);
        if (info != null) {
            return info.getValue();
        }
        return null;
    }

    @Override
    public ResourceInfo getResourceInfo(Locale loc, String key) {
        Map<String, ResourceInfo> map = this.get(loc);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    @Override
    public void put(Locale locale, String key, ResourceInfo value) {
        Map<String, ResourceInfo> resMap;
        if (locale != null && StringUtils.isNotBlank((CharSequence)key) && value != null && (resMap = this.get(locale)) != null) {
            resMap.put(key, value);
        }
    }

    @Override
    public void remove(Locale locale, String key) {
        Map<String, ResourceInfo> resMap;
        if (locale != null && StringUtils.isNotBlank((CharSequence)key) && (resMap = this.get(locale)) != null && resMap.containsKey(key)) {
            resMap.remove(key);
        }
    }

    @Override
    public boolean containsKey(Locale loc) {
        return this.get(loc) != null;
    }
}

