/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n;

import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.redis.RedisCacheMap;
import com.seeyon.ctp.common.i18n.ResourceCache;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;

class DistributedResourceCache
extends ResourceCache {
    private CacheAccessable factory = CacheFactory.getInstance(ResourceCache.class);

    DistributedResourceCache() {
    }

    private CacheMap<String, ResourceInfo> getLocaleCache(Locale locale) {
        String cacheName = I18nUtil.getLocalAsString(locale);
        if (this.factory.isExist(cacheName)) {
            return this.factory.getMap(cacheName);
        }
        CacheMap<String, ResourceInfo> cacheMap = this.factory.createMap(cacheName);
        if (cacheMap instanceof RedisCacheMap) {
            ((RedisCacheMap)cacheMap).initDataFromRedis();
        }
        return cacheMap;
    }

    @Override
    @Deprecated
    public Map<String, ResourceInfo> get(Locale locale) {
        return this.getLocaleCache(locale).toMap();
    }

    @Override
    public void put(Locale locale, Map<String, ResourceInfo> resourceMap) {
        if (locale != null) {
            this.getLocaleCache(locale).putAll(resourceMap);
        }
    }

    @Override
    public Set<Locale> keySet() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(Arrays.asList(this.factory.getCacheNames()));
        Transformer<String, Locale> transformer = new Transformer<String, Locale>(){

            public Locale transform(String input) {
                if (input.indexOf(45) > -1) {
                    String[] arr = input.split("-");
                    return new Locale(arr[0], arr[1]);
                }
                if (input.indexOf(95) > -1) {
                    String[] arr = input.split("_");
                    return new Locale(arr[0], arr[1]);
                }
                return new Locale(input);
            }
        };
        return new HashSet<Locale>(CollectionUtils.collect(keys, (Transformer)transformer));
    }

    @Override
    public String getValue(Locale locale, String key) {
        if (locale == null) {
            return null;
        }
        CacheMap<String, ResourceInfo> map = this.getLocaleCache(locale);
        if (map != null && map.get(key) != null) {
            ResourceInfo info = map.get(key);
            return info.getValue();
        }
        return null;
    }

    @Override
    public ResourceInfo getResourceInfo(Locale locale, String key) {
        if (locale == null) {
            return null;
        }
        CacheMap<String, ResourceInfo> map = this.getLocaleCache(locale);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    @Override
    public void put(Locale locale, String key, ResourceInfo value) {
        if (locale != null && StringUtils.isNotBlank((CharSequence)key) && value != null) {
            this.getLocaleCache(locale).put(key, value);
        }
    }

    @Override
    public void remove(Locale locale, String key) {
        if (locale != null && StringUtils.isNotBlank((CharSequence)key)) {
            this.getLocaleCache(locale).remove(key);
        }
    }

    @Override
    public boolean containsKey(Locale locale) {
        if (locale == null) {
            return false;
        }
        return this.factory.isExist(I18nUtil.getLocalAsString(locale));
    }
}

