/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.function.manager.impl;

import com.seeyon.ctp.common.formula.manager.FormulaManager;
import com.seeyon.ctp.common.function.CtpFunction;
import com.seeyon.ctp.common.function.CtpFunctionCategory;
import com.seeyon.ctp.common.function.manager.FunctionManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.StringWildcardUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;

public class FunctionManagerImpl
implements FunctionManager {
    private static Log logger = CtpLogFactory.getLog(FunctionManagerImpl.class);
    private List<CtpFunction> functions;
    private List<CtpFunctionCategory> categories;
    private FormulaManager formulaManager;

    public void setFormulaManager(FormulaManager formulaManager) {
        this.formulaManager = formulaManager;
    }

    @Override
    public void init(List<CtpFunction> functions, List<CtpFunctionCategory> categories) {
        this.functions = functions;
        this.categories = categories;
        this.validate();
    }

    @Override
    public List<CtpFunction> getByCategory(String category) {
        ArrayList<CtpFunction> result = new ArrayList<CtpFunction>();
        if (category == null) {
            return result;
        }
        String[] categories = category.split(",");
        for (CtpFunction func : this.functions) {
            String[] cates;
            String cate = func.getCategory();
            for (String s : cates = cate.split(",")) {
                if (StringWildcardUtil.matchOne(s, categories) <= -1) continue;
                result.add(func);
            }
        }
        return result;
    }

    @Override
    public List<CtpFunction> getByTemplateCode(String templateCode) {
        ArrayList<CtpFunction> result = new ArrayList<CtpFunction>();
        if (templateCode == null) {
            return result;
        }
        for (CtpFunction func : this.functions) {
            String cate = func.getTemplateCode();
            if (!templateCode.equals(cate)) continue;
            result.add(func);
        }
        return result;
    }

    public boolean validate() {
        boolean result = true;
        result = this.validateName();
        result = this.validateCategories();
        if (!result) {
            // empty if block
        }
        return result;
    }

    private boolean validateCategories() {
        boolean result = true;
        for (CtpFunctionCategory category : this.categories) {
            List<CtpFunction> funcs = this.getByCategory(category.getName());
            for (CtpFunction func : funcs) {
                Class returnType = category.getReturnType();
                if (returnType == null || func.getMethod().getReturnType().equals(returnType)) continue;
                logger.error((Object)("\u51fd\u6570" + func.getClassName() + "." + func.getMethodName() + "\u8fd4\u56de\u503c\u7c7b\u578b\u9519\u8bef:" + category.getName() + "\u7684\u8fd4\u56de\u503c\u5fc5\u987b\u4e3a" + category.getReturnType().getCanonicalName()));
            }
        }
        return result;
    }

    private boolean validateName() {
        boolean result = true;
        HashMap<String, CtpFunction> nameMap = new HashMap<String, CtpFunction>();
        for (CtpFunction func : this.functions) {
            String aliases = func.getAliases();
            if (Strings.isEmpty(aliases)) {
                aliases = func.getMethodName();
            }
            if (nameMap.containsKey(aliases)) {
                result = false;
                logger.error((Object)("\u51fd\u6570\u5b9a\u4e49\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u91cd\u540d:" + func.getClassName() + "\u4e0e" + nameMap.get(aliases) + "\u7684" + aliases));
            }
            nameMap.put(aliases, func);
        }
        return result;
    }

    @Override
    public boolean hasFunction(String category, String templateCode) {
        return this.formulaManager.hasFormulasByType(category, templateCode);
    }

    @Override
    public String getFunctionReference(String category, String templateCode, String script) {
        if (Strings.isEmpty(script)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List<CtpFunction> functions = this.getFunctions(category, templateCode);
        for (CtpFunction func : functions) {
            if (!script.contains(func.getMethodName())) continue;
            sb.append("import static ").append(func.getClassName()).append(".").append(func.getMethodName());
            sb.append(";");
        }
        return sb.toString();
    }

    @Override
    public List<CtpFunction> getFunctions(String category, String templateCode) {
        String cate = category;
        if (category == null) {
            cate = "*";
        }
        List<CtpFunction> functions = this.getByCategory(cate);
        functions.addAll(this.getByTemplateCode(templateCode));
        return functions;
    }
}

