/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.flag;

import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.flag.BrowserEnum;
import java.util.EnumMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public enum BrowserFlag {
    A8Allow(true, true, true, true, true, true, true, false),
    A8Allow4Admin(true, true, true, true, false, true, true, false),
    LoginDog(true, true, true, false, false, false, false, false),
    LoginOpenWindow(true, true, false, false, false, false, false, false),
    CloseWindowLogout(true, true, true, true, false, true, true, true),
    SelectPeople(true, true, true, true, false, true, true, false),
    OpenWindow(true, true, true, true, false, false, false, false),
    HtmlEditer(true, true, true, true, false, true, true, false),
    HideOperation(true, true, true, true, false, true, true, false),
    HideBrowsers(true, true, true, false, false, false, false, false),
    HideMenu(true, true, true, true, false, true, true, false),
    PageBreak(true, true, true, true, false, true, true, false),
    Office(true, true, true, false, false, false, false, false),
    selectPeopleShowType(true, true, true, true, false, true, true, false),
    OpenDivWindow(true, true, true, true, false, true, true, false),
    HideButtons(true, true, true, true, false, false, false, false),
    selectDivType(true, true, true, true, false, true, true, false),
    WorkFlowEdit(true, true, true, false, false, false, false, false),
    OnDbClick(true, true, true, true, false, true, true, true),
    OnlyIe(true, true, true, false, false, false, false, false),
    OnlyIpad(false, false, false, false, true, false, false, false),
    ImEncoding(true, true, true, false, false, true, true, false),
    XUA(false, true, true, false, false, false, false, false);

    private Map<BrowserEnum, Object> flags = new EnumMap<BrowserEnum, Object>(BrowserEnum.class);

    private BrowserFlag(Object IE, Object IE10, Object IE11, Object FireFox, Object iPad, Object Chrome, Object Safari, Object Opera) {
        this.flags.put(BrowserEnum.IE, IE);
        this.flags.put(BrowserEnum.IE9, IE);
        this.flags.put(BrowserEnum.IE10, IE10);
        this.flags.put(BrowserEnum.IE11, IE11);
        this.flags.put(BrowserEnum.FireFox, FireFox);
        this.flags.put(BrowserEnum.iPad, iPad);
        this.flags.put(BrowserEnum.Chrome, Chrome);
        this.flags.put(BrowserEnum.Safari, Safari);
        this.flags.put(BrowserEnum.Opera, Opera);
    }

    private Object getFlag(BrowserEnum b) {
        BrowserEnum b1 = b == null ? BrowserEnum.IE : b;
        return this.flags.get((Object)b1);
    }

    public Object getFlag(User user) {
        return this.getFlag(user.getBrowser());
    }

    public Object getFlag(HttpServletRequest request) {
        BrowserEnum currentBrowser = BrowserEnum.valueOf(request);
        return this.getFlag(currentBrowser);
    }
}

