/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.fileupload;

import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.springframework.web.servlet.ModelAndView;

public class FileController
extends BaseController {
    private FileManager fileManager;
    private AttachmentManager attachmentManager;
    private static Log log = CtpLogFactory.getLog(FileController.class);

    @Override
    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("apps/file/selfupload");
        File file = this.fileManager.getFile(Long.parseLong(request.getParameter("fileid")), new Date());
        modelAndView.addObject("filename", (Object)file.getName());
        modelAndView.addObject("filelength", (Object)file.length());
        return modelAndView;
    }

    public ModelAndView saveFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("apps/file/selfupload");
        String attaFlag = this.attachmentManager.create(ApplicationCategoryEnum.collaboration, (Long)2L, (Long)3L);
        modelAndView.addObject("attachmentsJSON", (Object)JSONUtil.toJSONString(this.attachmentManager.getByReference(2L)));
        return modelAndView;
    }

    public ModelAndView saveAssDoc(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("apps/samples/assdoc/assdoc");
        String attaFlag = this.attachmentManager.create(ApplicationCategoryEnum.collaboration, (Long)4L, (Long)5L, request);
        modelAndView.addObject("attachmentsJSON", (Object)JSONUtil.toJSONString(this.attachmentManager.getByReference(4L)));
        return modelAndView;
    }

    public ModelAndView showFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("apps/file/attlist");
        modelAndView.addObject("attachmentsJSON", (Object)JSONUtil.toJSONString(this.attachmentManager.getByReference(2L)));
        return modelAndView;
    }

    public ModelAndView initFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("apps/file/inituploadfile");
        modelAndView.addObject("attachmentsJSON", (Object)this.attachmentManager.getAttListJSON(2L));
        return modelAndView;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

