/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.filemanager.manager;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.config.manager.ConfigManager;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.encrypt.CoderFactory;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.Constants;
import com.seeyon.ctp.common.filemanager.dao.V3XFileDAO;
import com.seeyon.ctp.common.filemanager.domain.ReplaceBase64Result;
import com.seeyon.ctp.common.filemanager.event.FileUploadEvent;
import com.seeyon.ctp.common.filemanager.manager.FileItemImpl;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.filemanager.manager.PartitionManager;
import com.seeyon.ctp.common.filemanager.manager.Util;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.config.ConfigItem;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.util.Base64;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.ImageUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@ProcessInDataSource(name=DataSourceName.BASE)
public class FileManagerImpl
implements FileManager {
    private static Log log = CtpLogFactory.getLog(FileManagerImpl.class);
    public static final String FORM_FIELD_DEFAULT_FILE1 = "file1";
    private PartitionManager partitionManager;
    private V3XFileDAO v3xFileDAO;
    private int maxWidth;
    private int maxHeight;
    private String fileSuffix;
    private ConfigManager configManager;

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setPartitionManager(PartitionManager partitionManager) {
        this.partitionManager = partitionManager;
    }

    public void setV3xFileDAO(V3XFileDAO v3xFileDAO) {
        this.v3xFileDAO = v3xFileDAO;
    }

    @Override
    public String getNowFolder(boolean createWhenNoExist) throws BusinessException {
        return this.getFolder(new Date(), createWhenNoExist);
    }

    @Override
    public String getFolder(Date createDate, boolean createWhenNoExist) throws BusinessException {
        return this.partitionManager.getFolder(createDate, createWhenNoExist);
    }

    protected String getDefaultFolder() throws BusinessException {
        return this.getFolder(new Date(), true);
    }

    @Override
    public V3XFile getV3XFile(Long fileId) throws BusinessException {
        return this.v3xFileDAO.get(fileId);
    }

    @Override
    public List<V3XFile> getV3XFile(Long[] fileIds) throws BusinessException {
        return this.v3xFileDAO.get(fileIds);
    }

    @Override
    public File getFile(Long fileId) throws BusinessException {
        return this.getSpicFile(fileId, true);
    }

    @Override
    public File getSpicFile(Long fileId, boolean decryption) throws BusinessException {
        V3XFile v3xFile = this.getV3XFile(fileId);
        if (v3xFile == null) {
            throw new IllegalArgumentException("\u6587\u4ef6Id=" + fileId + "\u4e0d\u5b58\u5728");
        }
        File file = this.getNewFile(v3xFile.getCreateDate(), fileId);
        if (!file.exists()) {
            return null;
        }
        if (decryption) {
            return this.decryptionFile(file);
        }
        return file;
    }

    @Override
    public File getFile(Long fileId, Date createDate) throws BusinessException {
        File file = this.getNewFile(createDate, fileId);
        if (!file.exists()) {
            V3XFile v3xFile = this.getV3XFile(fileId);
            if (v3xFile == null) {
                return null;
            }
            Date realCreateDate = v3xFile.getCreateDate();
            file = this.getNewFile(realCreateDate, fileId);
            if (!file.exists()) {
                return null;
            }
        }
        return this.decryptionFile(file);
    }

    @Override
    public File getFileForUC(Long fileId, Date createDate) throws BusinessException {
        String ucFilePath = this.partitionManager.getFolderForUC(createDate, true) + File.separator + String.valueOf(fileId);
        File file = new File(ucFilePath);
        if (!file.exists()) {
            V3XFile v3xFile = this.getV3XFile(fileId);
            if (v3xFile == null) {
                return null;
            }
            Date realCreateDate = v3xFile.getCreateDate();
            ucFilePath = this.partitionManager.getFolderForUC(realCreateDate, true) + File.separator + String.valueOf(fileId);
            file = new File(ucFilePath);
            if (!file.exists()) {
                return null;
            }
        }
        return this.decryptionFile(file);
    }

    @Override
    public File getFileDecryption(Long fileId) throws BusinessException {
        return this.decryptionFile(this.getFile(fileId));
    }

    @Override
    public File getFileDecryption(Long fileId, Date createDate) throws BusinessException {
        return this.decryptionFile(this.getFile(fileId, createDate));
    }

    @Override
    public File getThumFile(Long fileId, Date createDate) throws BusinessException {
        return this.getThumFile(fileId, createDate, this.maxWidth);
    }

    private File getThumFileCommon(String resFile, int px) {
        String smallFile = resFile + "_" + px + this.fileSuffix;
        File file = new File(smallFile);
        if (!file.exists()) {
            try {
                String entryTempFile = CoderFactory.getInstance().decryptFileToTemp(resFile);
                String entryThumFile = entryTempFile + "_" + px + this.fileSuffix;
                ImageUtil.resize(entryTempFile, entryThumFile, px, px);
                if (!entryTempFile.equals(resFile)) {
                    CoderFactory.getInstance().encryptFile(entryThumFile, smallFile);
                }
                return new File(smallFile);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("\u6587\u4ef6\u4e0d\u5b58\u5728:" + e.getLocalizedMessage()));
            }
            catch (Exception e) {
                log.error((Object)("\u751f\u6210\u7f29\u7565\u56fe:" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return file;
    }

    @Override
    public File getThumFile(Long fileId, Date createDate, int px) throws BusinessException {
        String resFile = this.getNewFilepath(createDate, fileId);
        if (!new File(resFile).exists()) {
            V3XFile v3xFile = this.getV3XFile(fileId);
            if (v3xFile == null) {
                return null;
            }
            Date realCreateDate = v3xFile.getCreateDate();
            resFile = this.getNewFilepath(realCreateDate, fileId);
        }
        return this.getThumFileCommon(resFile, px);
    }

    @Override
    public File getThumFileForUC(Long fileId, Date createDate, String pxStr) throws BusinessException {
        String resFile = this.partitionManager.getFolderForUC(createDate, true) + File.separator + String.valueOf(fileId);
        if (!new File(resFile).exists()) {
            V3XFile v3xFile = this.getV3XFile(fileId);
            Date realCreateDate = v3xFile.getCreateDate();
            resFile = this.partitionManager.getFolderForUC(realCreateDate, true) + File.separator + String.valueOf(fileId);
        }
        int px = this.maxWidth;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pxStr})) {
            try {
                px = Integer.valueOf(pxStr);
            }
            catch (Exception e) {
                log.error((Object)"\u4f20\u5165\u7684\u7f29\u7565\u56fe\u53c2\u6570\u4e0d\u7b26\u5408\u89c4\u8303", (Throwable)e);
            }
        }
        return this.getThumFileCommon(resFile, px);
    }

    @Override
    public File decryptionFile(File file) {
        try {
            return CoderFactory.getInstance().decryptFileToTemp(file);
        }
        catch (Exception e) {
            log.error((Object)("\u6587\u4ef6=" + file.getName() + " \u89e3\u5bc6\u9519\u8bef\uff01"), (Throwable)e);
            throw new IllegalArgumentException("\u6587\u4ef6=" + file.getName() + "  \u89e3\u5bc6\u9519\u8bef\uff01");
        }
    }

    @Override
    public Map<String, V3XFile> uploadFiles(HttpServletRequest request, String allowExtensions, Long maxSize) throws BusinessException {
        return this.uploadFiles(request, allowExtensions, null, null, maxSize);
    }

    @Override
    public Map<String, V3XFile> uploadFiles(HttpServletRequest request, String allowExtensions, String destDirectory, Long maxSize) throws BusinessException {
        return this.uploadFiles(request, allowExtensions, null, destDirectory, maxSize);
    }

    @Override
    public Map<String, V3XFile> uploadFiles(HttpServletRequest request, String allowExtensions, File destFile, Long maxSize) throws BusinessException {
        HashMap<String, File> destFiles = new HashMap<String, File>();
        destFiles.put(FORM_FIELD_DEFAULT_FILE1, destFile);
        return this.uploadFiles(request, allowExtensions, destFiles, maxSize);
    }

    @Override
    public Map<String, V3XFile> uploadFiles(HttpServletRequest request, String allowExtensions, Map<String, File> destFiles, Long maxSize) throws BusinessException {
        return this.uploadFiles(request, allowExtensions, destFiles, null, maxSize);
    }

    private Map<String, V3XFile> uploadFiles(HttpServletRequest request, String allowExtensions, Map<String, File> destFiles, String destDirectory, Long maxSize) throws BusinessException {
        String ucFlag;
        String dir = destDirectory;
        String allowExt = allowExtensions;
        User user = AppContext.getCurrentUser();
        if (user == null) {
            return null;
        }
        if (!(request instanceof MultipartHttpServletRequest)) {
            throw new IllegalArgumentException("Argument request must be an instantce of MultipartHttpServletRequest. [" + request.getClass() + "]");
        }
        Date createDate = new Date();
        dir = StringUtils.isNotBlank((CharSequence)dir) ? FilenameUtils.separatorsToSystem((String)dir) : ("yes".equals(ucFlag = request.getParameter("ucFlag")) ? this.partitionManager.getFolderForUC(createDate, true) : this.getFolder(createDate, true));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Object maxUploadSizeExceeded = multipartRequest.getAttribute("MaxUploadSizeExceeded");
        if (maxUploadSizeExceeded != null) {
            if (maxSize == null || maxSize == 0L) {
                throw new BusinessException("fileupload.exception.MaxSize", maxUploadSizeExceeded);
            }
            throw new BusinessException("fileupload.exception.MaxSize", Strings.formatFileSize(maxSize, false));
        }
        Object ex = multipartRequest.getAttribute("unknownException");
        if (ex != null) {
            throw new BusinessException("fileupload.exception.unknown", ex);
        }
        HashMap<String, V3XFile> v3xFiles = new HashMap<String, V3XFile>();
        Iterator fileNames = multipartRequest.getFileNames();
        if (fileNames == null) {
            return null;
        }
        String isEncrypt = request.getParameter("isEncrypt");
        while (fileNames.hasNext()) {
            Object name = fileNames.next();
            if (name == null || "".equals(name)) continue;
            String fieldName = String.valueOf(name);
            List fileItemList = multipartRequest.getFiles(String.valueOf(name));
            for (int fileIndex = 0; fileIndex < fileItemList.size(); ++fileIndex) {
                String value;
                String[] prohibit_suffix;
                MultipartFile fileItem = (MultipartFile)fileItemList.get(fileIndex);
                if (fileItem == null) continue;
                if (maxSize != null && fileItem.getSize() > maxSize) {
                    throw new BusinessException("fileupload.exception.MaxSize", Strings.formatFileSize(maxSize, false));
                }
                String filename = fileItem.getOriginalFilename().replace('\u00a0', ' ').replace('?', ' ');
                String suffix = FilenameUtils.getExtension((String)filename).toLowerCase();
                ConfigItem configItem = this.configManager.getConfigItem("system_switch", "prohibit_att_suffix");
                if (null != configItem && null != configItem.getConfigValue() && Arrays.asList(prohibit_suffix = (value = configItem.getConfigValue()).split(",")).contains(suffix)) {
                    throw new BusinessException("fileupload.exception.UnallowedExtension.settings", value);
                }
                if (!(StringUtils.isEmpty((CharSequence)allowExt) || StringUtils.isEmpty((CharSequence)suffix) || Pattern.matches((allowExt = allowExt.replace(',', '|')).toLowerCase(), suffix))) {
                    throw new BusinessException("fileupload.exception.UnallowedExtension", allowExt);
                }
                if (Strings.isNotBlank(allowExt) && Strings.isBlank(suffix)) {
                    throw new BusinessException("fileupload.exception.UnallowedExtension", allowExt);
                }
                FileItemImpl fi = new FileItemImpl(fileItem);
                FileUploadEvent event = new FileUploadEvent(this, fi);
                try {
                    EventDispatcher.fireEventWithException(event);
                }
                catch (Throwable e) {
                    if (e instanceof BusinessException) {
                        throw (BusinessException)e;
                    }
                    throw new BusinessException(e.getLocalizedMessage(), e);
                }
                if (fi.getMessages().size() > 0) {
                    request.setAttribute("upload.event.message", (Object)fi.getMessages());
                }
                long fileId = UUIDLong.longUUID();
                File destFile = null;
                FilterOutputStream bos = null;
                try {
                    if (destFiles != null && destFiles.get(fieldName) != null) {
                        destFile = destFiles.get(fieldName);
                        destFile.getParentFile().mkdirs();
                    } else {
                        destFile = new File(dir + File.separator + String.valueOf(fileId));
                    }
                    String encryptVersion = null;
                    encryptVersion = CoderFactory.getInstance().getEncryptVersion();
                    if (encryptVersion != null && !"no".equals(encryptVersion) && !"false".equals(isEncrypt)) {
                        bos = new BufferedOutputStream(new FileOutputStream(destFile));
                        CoderFactory.getInstance().upload(fi.getInputStream(), bos, encryptVersion);
                    } else {
                        fi.saveAs(destFile);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    throw new BusinessException("\u9644\u4ef6\u5b58\u76d8\u65f6\u53d1\u751f\u9519\u8bef", e);
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException e) {
                            log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                V3XFile file = new V3XFile(fileId);
                file.setCreateDate(createDate);
                file.setFilename(filename);
                file.setSize(fi.getSize());
                file.setMimeType(fi.getContentType());
                file.setType(Constants.ATTACHMENT_TYPE.FILE.ordinal());
                file.setCreateMember(user.getId());
                file.setAccountId(user.getAccountId());
                String newKeyName = fieldName + "_" + String.valueOf(fileIndex + 1);
                v3xFiles.put(newKeyName, file);
            }
        }
        return v3xFiles;
    }

    @Override
    public ReplaceBase64Result replaceBase64Image(String html) throws BusinessException {
        ReplaceBase64Result result = new ReplaceBase64Result();
        result.setConvertBase64Img(false);
        if (Strings.isBlank(html)) {
            result.setHtml(html);
            return result;
        }
        String regexImg = "<\\s*(i|I)(m|M)(g|G)[^>]+(s|S)(r|R)(c|C)\\s*=\\s*(\"|')data:image/[^>]+>";
        Pattern pattern = Pattern.compile(regexImg);
        Matcher matcher = pattern.matcher(html);
        while (matcher.find()) {
            String imgHtml = matcher.group();
            String imgHtmlNew = null;
            String regexBase64 = "(\"data:image/[^'\"]+\")|('data:image/[^'\"]+')";
            Pattern base64Pattern = Pattern.compile(regexBase64);
            Matcher base64matcher = base64Pattern.matcher(imgHtml);
            while (base64matcher.find()) {
                String base64Str = base64matcher.group();
                base64Str = base64Str.substring(1, base64Str.length() - 1);
                V3XFile v3XFile = this.saveBase64Img(base64Str, null, null);
                StringBuilder urlStr = new StringBuilder();
                urlStr.append(SystemEnvironment.getContextPath());
                urlStr.append("/fileUpload.do?method=showRTE&fileId=");
                urlStr.append(v3XFile.getId().toString());
                urlStr.append("&createDate=");
                urlStr.append(Datetimes.format(v3XFile.getCreateDate(), "yyyy-MM-dd"));
                urlStr.append("&type=image");
                imgHtmlNew = imgHtml.replaceFirst(regexBase64, "\"" + urlStr.toString() + "\"");
            }
            html = html.replaceFirst(regexImg, imgHtmlNew);
            result.setConvertBase64Img(true);
        }
        result.setHtml(html);
        return result;
    }

    @Override
    public V3XFile saveBase64Img(String base64Str, String fileName, Map<String, Object> param) throws BusinessException {
        String value;
        String[] prohibit_suffix;
        User user = AppContext.getCurrentUser();
        Date createDate = new Date();
        String base64Body = null;
        if (base64Str.startsWith("data:image/")) {
            String[] base64 = base64Str.split(",");
            String base64Prefix = base64[0];
            base64Body = base64[1];
            if (Strings.isBlank(fileName)) {
                String imgSuffix = base64Prefix.replace("data:image/", "").replace(";base64", "");
                if ("jpeg".equalsIgnoreCase(imgSuffix)) {
                    imgSuffix = "jpg";
                }
                fileName = Datetimes.format(createDate, "yyyyMMddHHmmss") + "." + imgSuffix;
            }
        } else {
            base64Body = base64Str;
        }
        ByteArrayInputStream inputStream = null;
        try {
            byte[] b = Base64.decode(base64Body);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            inputStream = new ByteArrayInputStream(b);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new BusinessException(e);
        }
        String suffix = FilenameUtils.getExtension((String)fileName).toLowerCase();
        ConfigItem configItem = this.configManager.getConfigItem("system_switch", "prohibit_att_suffix");
        if (null != configItem && null != configItem.getConfigValue() && Arrays.asList(prohibit_suffix = (value = configItem.getConfigValue()).split(",")).contains(suffix)) {
            throw new BusinessException("fileupload.exception.UnallowedExtension.settings", value);
        }
        long fileId = UUIDLong.longUUID();
        String dir = this.getFolder(createDate, true);
        File destFile = new File(dir + File.separator + String.valueOf(fileId));
        FilterOutputStream bos = null;
        try {
            String encryptVersion = CoderFactory.getInstance().getEncryptVersion();
            if (Strings.isNotBlank(encryptVersion) && !"no".equals(encryptVersion)) {
                bos = new BufferedOutputStream(new FileOutputStream(destFile));
                CoderFactory.getInstance().upload(inputStream, bos, encryptVersion);
            } else {
                IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(destFile));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new BusinessException(e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        V3XFile file = new V3XFile(fileId);
        file.setCreateDate(createDate);
        file.setFilename(fileName);
        file.setType(Constants.ATTACHMENT_TYPE.IMAGE.ordinal());
        file.setCreateMember(user.getId());
        file.setAccountId(user.getAccountId());
        return file;
    }

    @Override
    public void deleteFile(Long fileId, Boolean deletePhysicsFile) throws BusinessException {
        File file;
        if (deletePhysicsFile.booleanValue() && (file = this.getSpicFile(fileId, false)) != null) {
            file.delete();
        }
        this.v3xFileDAO.delete(fileId);
    }

    @Override
    public void deletePhysicsFile(Long fileId) throws BusinessException {
        File file = this.getSpicFile(fileId, false);
        if (file != null) {
            file.delete();
        }
    }

    @Override
    public void deleteFile(Long fileId, Date createDate, Boolean deletePhysicsFile) throws BusinessException {
        this.v3xFileDAO.delete(fileId);
        if (deletePhysicsFile.booleanValue()) {
            try {
                File file = this.getFile(fileId, createDate);
                if (file != null) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public InputStream getFileInputStream(Long fileId) throws BusinessException {
        File file = this.getFile(fileId);
        if (file == null) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            log.warn((Object)(file.getAbsolutePath() + "\u4e0d\u5b58\u5728"));
            return null;
        }
    }

    @Override
    public InputStream getFileInputStream(Long fileId, Date createDate) throws BusinessException {
        File file = this.getFile(fileId, createDate);
        if (file == null) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            log.debug((Object)(file.getAbsolutePath() + "\u4e0d\u5b58\u5728"));
            return null;
        }
    }

    @Override
    public InputStream getFileInputStreamForUC(Long fileId, Date createDate) throws BusinessException {
        File file = this.getFileForUC(fileId, createDate);
        if (file == null) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            log.debug((Object)(file.getAbsolutePath() + "\u4e0d\u5b58\u5728"));
            return null;
        }
    }

    @Override
    public void save(V3XFile file) {
        file.setIdIfNew();
        this.v3xFileDAO.save(file);
    }

    @Override
    public void save(List<V3XFile> files) {
        this.v3xFileDAO.save(files);
    }

    @Override
    public byte[] getFileBytes(Long fileId) throws BusinessException {
        File file = this.getFile(fileId);
        try {
            if (file != null) {
                return FileUtils.readFileToByteArray((File)file);
            }
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        return null;
    }

    @Override
    public byte[] getFileBytes(Long fileId, Date createDate) throws BusinessException {
        File file = this.getFile(fileId, createDate);
        try {
            if (file != null) {
                return FileUtils.readFileToByteArray((File)file);
            }
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        return null;
    }

    @Override
    public V3XFile save(String bodyData, ApplicationCategoryEnum category, String filename, Date createDate, Boolean isSaveToDB) throws BusinessException {
        if (bodyData == null) {
            throw new IllegalArgumentException("bodyData is null");
        }
        if (createDate == null) {
            createDate = new Date();
        }
        byte[] bs = bodyData.getBytes();
        V3XFile v3xFile = new V3XFile();
        v3xFile.setIdIfNew();
        v3xFile.setCategory(category.key());
        v3xFile.setCreateDate(createDate);
        v3xFile.setFilename(filename);
        v3xFile.setMimeType(FileUtil.getMimeType(filename));
        v3xFile.setSize(Long.valueOf(bs.length));
        try {
            File file = this.getNewFile(v3xFile.getCreateDate(), v3xFile.getId());
            FileUtils.writeByteArrayToFile((File)file, (byte[])bs);
            if (isSaveToDB.booleanValue()) {
                this.save(v3xFile);
            }
        }
        catch (Exception e) {
            throw new BusinessException(e);
        }
        return v3xFile;
    }

    @Override
    public V3XFile clone(Long originalFileId, boolean saveDB) throws BusinessException, FileNotFoundException {
        V3XFile v3xFile = this.getV3XFile(originalFileId);
        if (v3xFile == null) {
            throw new FileNotFoundException("clone\u9644\u4ef6 : [" + originalFileId + "]\u4e0d\u5b58\u5728\u3002");
        }
        Long newFileId = UUIDLong.longUUID();
        Date newCreateDate = new Date();
        this.clone(originalFileId, v3xFile.getCreateDate(), newFileId, newCreateDate);
        V3XFile file = new V3XFile();
        file.setId(newFileId);
        file.setCreateDate(newCreateDate);
        file.setCategory(v3xFile.getCategory());
        file.setDescription(v3xFile.getDescription());
        file.setCreateMember(v3xFile.getCreateMember());
        file.setFilename(v3xFile.getFilename());
        file.setMimeType(v3xFile.getMimeType());
        file.setSize(v3xFile.getSize());
        file.setType(v3xFile.getType());
        file.setAccountId(v3xFile.getAccountId());
        if (saveDB) {
            this.save(file);
        }
        return file;
    }

    @Override
    public void clone(Long originalFileId, Date createDate, Long newFileId, Date newCreateDate) throws BusinessException, FileNotFoundException {
        File srcFile = this.getFile(originalFileId, createDate);
        if (srcFile == null) {
            throw new FileNotFoundException("Clone\u9644\u4ef6 : [" + originalFileId + ", " + createDate + "]\u4e0d\u5b58\u5728\u3002");
        }
        File destFile = this.getNewFile(newCreateDate, newFileId);
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            log.error((Object)("Clone\u6587\u4ef6\u5f02\u5e38 " + originalFileId), (Throwable)e);
            throw new BusinessException("Clone\u6587\u4ef6\u5f02\u5e38" + e.getMessage());
        }
    }

    @Override
    public List<V3XFile> create(ApplicationCategoryEnum category, HttpServletRequest request) throws BusinessException {
        String[] fileUrl = request.getParameterValues("attachment_fileUrl");
        String[] mimeType = request.getParameterValues("attachment_mimeType");
        String[] size = request.getParameterValues("attachment_size");
        String[] createdate = request.getParameterValues("attachment_createDate");
        String[] filename = request.getParameterValues("attachment_filename");
        String[] type = request.getParameterValues("attachment_type");
        String[] needClone = request.getParameterValues("attachment_needClone");
        String[] description = request.getParameterValues("attachment_description");
        if (fileUrl == null || mimeType == null || size == null || createdate == null || filename == null || type == null || needClone == null) {
            return null;
        }
        Long userId = AppContext.getCurrentUser().getId();
        Long accountId = AppContext.getCurrentUser().getAccountId();
        ArrayList<V3XFile> files = new ArrayList<V3XFile>();
        for (int i = 0; i < fileUrl.length; ++i) {
            Date originalCreateDate = Datetimes.parseDatetime(createdate[i]);
            V3XFile file = new V3XFile();
            file.setCategory(category.key());
            file.setType(Integer.valueOf(type[i]));
            file.setFilename(filename[i]);
            file.setMimeType(mimeType[i]);
            file.setSize(Long.parseLong(size[i]));
            file.setDescription(description[i]);
            file.setCreateMember(userId);
            file.setAccountId(accountId);
            boolean _needClone = Boolean.parseBoolean(needClone[i]);
            if (_needClone) {
                Long newFileId = UUIDLong.longUUID();
                Date newCreateDate = new Date();
                try {
                    this.clone(Long.valueOf(fileUrl[i]), originalCreateDate, newFileId, newCreateDate);
                }
                catch (Exception e) {
                    log.error((Object)"Clone \u9644\u4ef6", (Throwable)e);
                    throw new BusinessException("Clone\u6587\u4ef6\u5f02\u5e38" + e.getMessage());
                }
                file.setId(newFileId);
                file.setCreateDate(newCreateDate);
            } else {
                file.setId(Long.parseLong(fileUrl[i]));
                file.setCreateDate(originalCreateDate);
            }
            this.save(file);
            files.add(file);
        }
        return files;
    }

    @Override
    public V3XFile save(File file, ApplicationCategoryEnum category, String filename, Date createDate, Boolean isSaveToDB) throws BusinessException {
        V3XFile v3XFile;
        if (file == null || !file.exists()) {
            throw new BusinessException("FileNotFoundException");
        }
        FileInputStream in = null;
        try {
            V3XFile v3xFile;
            in = new FileInputStream(file);
            v3XFile = v3xFile = this.save(in, category, filename, createDate, isSaveToDB);
        }
        catch (Exception e) {
            try {
                throw new BusinessException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return v3XFile;
    }

    @Override
    public V3XFile save(InputStream in, ApplicationCategoryEnum category, String filename, Date createDate, Boolean isSaveToDB) throws BusinessException {
        Date cdate = createDate;
        if (in == null) {
            throw new IllegalArgumentException("in is null");
        }
        User user = AppContext.getCurrentUser();
        if (cdate == null) {
            cdate = new Date();
        }
        V3XFile v3xFile = new V3XFile();
        v3xFile.setIdIfNew();
        v3xFile.setCategory(category.key());
        v3xFile.setCreateDate(cdate);
        v3xFile.setFilename(filename);
        v3xFile.setMimeType(FileUtil.getMimeType(filename));
        v3xFile.setType(Constants.ATTACHMENT_TYPE.FILE.ordinal());
        v3xFile.setDescription("");
        if (user != null) {
            v3xFile.setCreateMember(user.getId());
            v3xFile.setAccountId(user.getAccountId());
        } else {
            log.debug((Object)"\u4e0a\u4f20\u6587\u4ef6\u65f6\u5f53\u524d\u7528\u6237\u4e3a\u7a7a\u3002");
        }
        File destFile = this.getNewFile(cdate, v3xFile.getId());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(destFile);
            int count = IOUtils.copy((InputStream)in, (OutputStream)out);
            v3xFile.setSize(Long.valueOf(count));
            if (isSaveToDB.booleanValue()) {
                this.save(v3xFile);
            }
        }
        catch (Exception e) {
            try {
                throw new BusinessException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return v3xFile;
    }

    private String getNewFilepath(Date createDate, Long newFileId) throws BusinessException {
        return this.getFolder(createDate, true) + File.separator + String.valueOf(newFileId);
    }

    private File getNewFile(Date createDate, Long newFileId) throws BusinessException {
        return new File(this.getNewFilepath(createDate, newFileId));
    }

    @Override
    public File getStandardOffice(Long fileId, Date createDate) throws BusinessException {
        File newFile;
        File f = this.getFile(fileId, createDate);
        if (f == null && (f = this.getFile(fileId)) == null) {
            return null;
        }
        V3XFile file = this.getV3XFile(fileId);
        String newPathName2 = SystemEnvironment.getSystemTempFolder() + File.separator + f.getName() + "O" + f.lastModified();
        if (file != null) {
            String miniType = file.getMimeType();
            boolean miniTypeFlag = false;
            if (miniType != null && miniType.toLowerCase().contains("word")) {
                miniTypeFlag = true;
            }
            if (file.getFilename() != null && (file.getFilename().toLowerCase().endsWith(".doc") || file.getFilename().toLowerCase().endsWith(".docx") || miniTypeFlag)) {
                newPathName2 = newPathName2 + ".doc";
            }
        }
        if ((newFile = new File(newPathName2)).exists()) {
            return newFile;
        }
        Util.jinge2StandardOffice(f.getAbsolutePath(), newPathName2);
        return newFile;
    }

    @Override
    public InputStream getStandardOfficeInputStream(Long fileId, Date createDate) throws BusinessException, FileNotFoundException {
        File f = this.getStandardOffice(fileId, createDate);
        if (f == null) {
            return null;
        }
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            log.warn((Object)(f.getAbsolutePath() + "\u4e0d\u5b58\u5728"));
            throw e;
        }
    }

    @Override
    public V3XFile clone(Long originalFileId) throws BusinessException, FileNotFoundException {
        V3XFile v3xFile = this.getV3XFile(originalFileId);
        if (v3xFile == null) {
            throw new FileNotFoundException("V3XFile : " + originalFileId + "\u4e0d\u5b58\u5728\u3002");
        }
        Long newFileId = UUIDLong.longUUID();
        Date newCreateDate = new Date();
        this.clone(originalFileId, v3xFile.getCreateDate(), newFileId, newCreateDate);
        V3XFile file = new V3XFile();
        file.setId(newFileId);
        file.setCreateDate(newCreateDate);
        file.setCategory(v3xFile.getCategory());
        file.setDescription(v3xFile.getDescription());
        file.setCreateMember(v3xFile.getCreateMember());
        file.setFilename("copy" + v3xFile.getFilename());
        file.setMimeType(v3xFile.getMimeType());
        file.setSize(v3xFile.getSize());
        file.setType(v3xFile.getType());
        file.setAccountId(v3xFile.getAccountId());
        this.save(file);
        return file;
    }

    @Override
    public List<V3XFile> findByFileName(String fileName) {
        return this.v3xFileDAO.findByFileName(fileName);
    }

    @Override
    public void update(V3XFile file) {
        this.v3xFileDAO.update(file);
    }

    @Override
    public Long copyFileBeforeModify(Long fileId) {
        try {
            return this.clone(fileId, true).getId();
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return -1L;
        }
        catch (BusinessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    @Override
    public Long getFileIdByDocResSourceId(Long fileId) {
        try {
            return this.getV3XFile(fileId).getId();
        }
        catch (BusinessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    @Override
    public void copyWPS(Long sourceId) {
        try {
            V3XFile file = this.getV3XFile(sourceId);
            String filePath = this.getFolder(file.getCreateDate(), true) + File.separator + sourceId;
            String now = Datetimes.format(new Date(), "yyyyMMddHHmmss", TimeZone.getDefault());
            String contentFileBak = filePath + "_" + now + ".bak";
            File f = new File(filePath);
            if (f.exists()) {
                FileUtils.copyFile((File)f, (File)new File(contentFileBak));
            }
        }
        catch (Exception e) {
            log.error((Object)("WPS\u6b63\u6587\u5185\u5bb9\u5907\u4efd\u5f02\u5e38 \uff1a" + sourceId), (Throwable)e);
        }
    }

    @Override
    public File getStandardOffice(String fileAbsolutePath) throws BusinessException {
        if (StringUtils.isBlank((CharSequence)fileAbsolutePath)) {
            throw new BusinessException("\u4f20\u5165\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        String newPathName = SystemEnvironment.getSystemTempFolder() + File.separator + String.valueOf(UUIDLong.longUUID());
        Util.jinge2StandardOffice(fileAbsolutePath, newPathName);
        return new File(newPathName);
    }

    public static void main(String[] args) throws Exception {
        String p = "D:\\Working@seeyon\\Runtime\\ApacheJetspeed\\webapps\\seeyon\\main\\login\\default\\images\\banner2";
        for (int i = 1; i < 11; ++i) {
            int s = i * 100;
            ImageUtil.resize(p + ".png", "d:\\aaa_" + s + ".png", s, s);
        }
    }

    @Override
    public Map<String, V3XFile> uploadFiles(HttpServletRequest request, Long memberId, Long accountId, String allowExtensions, Long maxSize) throws BusinessException {
        return this.uploadFiles(request, memberId, accountId, allowExtensions, null, null, maxSize);
    }

    private Map<String, V3XFile> uploadFiles(HttpServletRequest request, Long memberId, Long accountId, String allowExtensions, Map<String, File> destFiles, String destDirectory, Long maxSize) throws BusinessException {
        Object maxUploadSizeExceeded;
        String dir = destDirectory;
        String allowExt = allowExtensions;
        if (!(request instanceof MultipartHttpServletRequest)) {
            throw new IllegalArgumentException("Argument request must be an instantce of MultipartHttpServletRequest. [" + request.getClass() + "]");
        }
        Date createDate = new Date();
        String ucFlag = request.getParameter("ucFlag");
        dir = StringUtils.isNotBlank((CharSequence)dir) ? FilenameUtils.separatorsToSystem((String)dir) : ("yes".equals(ucFlag) ? this.partitionManager.getFolderForUC(createDate, true) : this.getFolder(createDate, true));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        if (!"yes".equals(ucFlag) && (maxUploadSizeExceeded = multipartRequest.getAttribute("MaxUploadSizeExceeded")) != null) {
            if (maxSize == null || maxSize == 0L) {
                throw new BusinessException("fileupload.exception.MaxSize", maxUploadSizeExceeded);
            }
            throw new BusinessException("fileupload.exception.MaxSize", Strings.formatFileSize(maxSize, false));
        }
        Object ex = multipartRequest.getAttribute("unknownException");
        if (ex != null) {
            throw new BusinessException("fileupload.exception.unknown", ex);
        }
        HashMap<String, V3XFile> v3xFiles = new HashMap<String, V3XFile>();
        Iterator fileNames = multipartRequest.getFileNames();
        if (fileNames == null) {
            return null;
        }
        String isEncrypt = request.getParameter("isEncrypt");
        while (fileNames.hasNext()) {
            Object name = fileNames.next();
            if (name == null || "".equals(name)) continue;
            String fieldName = String.valueOf(name);
            List fileItemList = multipartRequest.getFiles(String.valueOf(name));
            for (int fileIndex = 0; fileIndex < fileItemList.size(); ++fileIndex) {
                MultipartFile fileItem = (MultipartFile)fileItemList.get(fileIndex);
                if (fileItem == null) continue;
                if (maxSize != null && fileItem.getSize() > maxSize) {
                    throw new BusinessException("fileupload.exception.MaxSize", Strings.formatFileSize(maxSize, false));
                }
                String filename = fileItem.getOriginalFilename().replace('\u00a0', ' ').replace('?', ' ');
                String suffix = FilenameUtils.getExtension((String)filename).toLowerCase();
                if (!(StringUtils.isEmpty((CharSequence)allowExt) || StringUtils.isEmpty((CharSequence)suffix) || Pattern.matches((allowExt = allowExt.replace(',', '|')).toLowerCase(), suffix))) {
                    throw new BusinessException("fileupload.exception.UnallowedExtension", allowExt);
                }
                FileItemImpl fi = new FileItemImpl(fileItem);
                FileUploadEvent event = new FileUploadEvent(this, fi);
                try {
                    EventDispatcher.fireEventWithException(event);
                }
                catch (Throwable e) {
                    if (e instanceof BusinessException) {
                        throw (BusinessException)e;
                    }
                    throw new BusinessException(e.getLocalizedMessage(), e);
                }
                if (fi.getMessages().size() > 0) {
                    request.setAttribute("upload.event.message", (Object)fi.getMessages());
                }
                long fileId = UUIDLong.longUUID();
                File destFile = null;
                FilterOutputStream bos = null;
                try {
                    if (destFiles != null && destFiles.get(fieldName) != null) {
                        destFile = destFiles.get(fieldName);
                        destFile.getParentFile().mkdirs();
                    } else {
                        destFile = new File(dir + File.separator + String.valueOf(fileId));
                    }
                    String encryptVersion = null;
                    encryptVersion = CoderFactory.getInstance().getEncryptVersion();
                    if (encryptVersion != null && !"no".equals(encryptVersion) && !"false".equals(isEncrypt)) {
                        bos = new BufferedOutputStream(new FileOutputStream(destFile));
                        CoderFactory.getInstance().upload(fi.getInputStream(), bos, encryptVersion);
                    } else {
                        fi.saveAs(destFile);
                    }
                }
                catch (Exception e) {
                    throw new BusinessException("\u9644\u4ef6\u5b58\u76d8\u65f6\u53d1\u751f\u9519\u8bef", e);
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException e) {
                            log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                V3XFile file = new V3XFile(fileId);
                file.setCreateDate(createDate);
                file.setFilename(filename);
                file.setSize(fi.getSize());
                file.setMimeType(fi.getContentType());
                file.setType(Constants.ATTACHMENT_TYPE.FILE.ordinal());
                file.setCreateMember(memberId);
                file.setAccountId(accountId);
                String newKeyName = fieldName + "_" + String.valueOf(fileIndex + 1);
                v3xFiles.put(newKeyName, file);
            }
        }
        return v3xFiles;
    }

    @Override
    public String getOfficeSuffix(V3XFile file) throws BusinessException {
        String extension = "";
        if (file != null) {
            String mimeType = file.getMimeType();
            if ("application/vnd.openxmlformats-officedocument.wordprocessingml.document".equals(mimeType)) {
                extension = "docx";
            } else if ("application/msword".equals(mimeType)) {
                extension = "doc";
            } else if ("application/vnd.ms-excel".equals(mimeType)) {
                extension = "xls";
            } else if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(mimeType)) {
                extension = "xlsx";
            }
        }
        return extension;
    }
}

