/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.filemanager.manager;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.config.SystemConfig;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.Constants;
import com.seeyon.ctp.common.filemanager.dao.AttachmentDAO;
import com.seeyon.ctp.common.filemanager.event.AttachmentSaveEvent;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.office.trans.util.OfficeTransHelper;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ProcessInDataSource(name=DataSourceName.BASE)
public class AttachmentManagerImpl
implements AttachmentManager {
    private static Log log = CtpLogFactory.getLog(AttachmentManagerImpl.class);
    private FileManager fileManager;
    private AttachmentDAO attachmentDAO;
    private SystemConfig systemConfig;

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setAttachmentDAO(AttachmentDAO attachmentDAO) {
        this.attachmentDAO = attachmentDAO;
    }

    public void setSystemConfig(SystemConfig systemConfig) {
        this.systemConfig = systemConfig;
    }

    @Override
    public String create(Collection<Attachment> attachments) {
        return this.create(attachments, true);
    }

    @Override
    public String create(Collection<Attachment> attachments, boolean needSetSort) {
        HashSet<Integer> r = new HashSet<Integer>();
        User user = AppContext.getCurrentUser();
        if (user == null) {
            return null;
        }
        int i = 0;
        for (Attachment attachment : attachments) {
            if (needSetSort) {
                attachment.setSort(i++);
            }
            this.saveAttachment(attachment, user);
            r.add(attachment.getType());
        }
        return AttachmentManagerImpl.parseR(r);
    }

    private void saveAttachment(Attachment attachment, Long userId, Long accountId) {
        attachment.setIdIfNew();
        if (attachment.getType().intValue() != Constants.ATTACHMENT_TYPE.DOCUMENT.ordinal()) {
            V3XFile file = new V3XFile(attachment.getFileUrl());
            file.setCategory(attachment.getCategory());
            file.setType(attachment.getType());
            file.setFilename(attachment.getFilename());
            file.setMimeType(attachment.getMimeType());
            file.setCreateDate(attachment.getCreatedate());
            file.setSize(attachment.getSize());
            file.setDescription(attachment.getDescription());
            Long fileCreateMember = userId;
            try {
                V3XFile v3XFile;
                Long fileUrl = attachment.getFileUrl();
                if (fileUrl != null && (v3XFile = this.fileManager.getV3XFile(fileUrl)) != null) {
                    fileCreateMember = v3XFile.getCreateMember();
                }
            }
            catch (Exception e) {
                log.error((Object)"\u6839\u636eattachment\u83b7\u53d6v3xFile\u51fa\u9519!", (Throwable)e);
            }
            file.setCreateMember(fileCreateMember);
            file.setAccountId(accountId);
            file.setUpdateDate(new Date());
            this.fileManager.save(file);
        }
        this.attachmentDAO.save(attachment);
        EventDispatcher.fireEvent(new AttachmentSaveEvent(attachment, this));
    }

    private void saveAttachment(Attachment attachment, User user) {
        this.saveAttachment(attachment, user.getId(), user.getAccountId());
    }

    @Override
    public List<Attachment> getByReference(Long reference) {
        return this.setOfficeTransformEnable(this.attachmentDAO.findAll(reference));
    }

    @Override
    public List<Attachment> setOfficeTransformEnable(List<Attachment> list) {
        String de = this.systemConfig.get("office_transform_enable");
        if (de != null) {
            for (Attachment att : list) {
                if (OfficeTransHelper.allowTrans(att)) {
                    att.setOfficeTransformEnable(de);
                    continue;
                }
                att.setOfficeTransformEnable("disable");
            }
        }
        return list;
    }

    @Override
    public String getAttListJSON(Long reference) {
        String tem = JSONUtil.toJSONString(this.setOfficeTransformEnable(this.fileNameESCHtml(this.attachmentDAO.findAll(reference))));
        return tem;
    }

    private List<Attachment> fileNameESCHtml(List<Attachment> list) {
        ArrayList<Attachment> attlist = new ArrayList<Attachment>();
        for (Attachment att : list) {
            try {
                Attachment attc = (Attachment)att.clone();
                attc.setId(att.getId());
                attc.setFilename(Strings.toHTML(attc.getFilename().replace('\u00a0', ' ')).replaceAll("&quot;", "\\\""));
                attlist.add(attc);
            }
            catch (CloneNotSupportedException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return attlist;
    }

    private List<Attachment> fileNameESCJS(List<Attachment> list) {
        ArrayList<Attachment> attlist = new ArrayList<Attachment>();
        for (Attachment att : list) {
            try {
                Attachment attc = (Attachment)att.clone();
                attc.setId(att.getId());
                attc.setFilename(att.getFilename());
                attc.setFilename(attc.getFilename().replace('\u00a0', ' ').replace("'", "\\'"));
                attlist.add(attc);
            }
            catch (CloneNotSupportedException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return attlist;
    }

    @Override
    public String getAttListJSON(List<Attachment> list) {
        String tem = JSONUtil.toJSONString(this.setOfficeTransformEnable(this.fileNameESCHtml(list)));
        return tem;
    }

    @Override
    public String getAttListJSON(Long reference, Long subReference) {
        String tem = JSONUtil.toJSONString(this.setOfficeTransformEnable(this.fileNameESCHtml(this.attachmentDAO.findAll(reference, subReference))));
        return tem;
    }

    @Override
    public String getAttListJSON4JS(Long reference, Long subReference) {
        String tem = JSONUtil.toJSONString(this.setOfficeTransformEnable(this.fileNameESCJS(this.attachmentDAO.findAll(reference, subReference))));
        return tem.replace("\\\\'", "\\'");
    }

    @Override
    public String getAttListJSON4JS(Long reference) {
        String tem = JSONUtil.toJSONString(this.setOfficeTransformEnable(this.fileNameESCJS(this.attachmentDAO.findAll(reference))));
        return tem.replace("\\\\'", "\\'");
    }

    @Override
    public List<Attachment> getByReference(Long reference, Long subReference) {
        return this.setOfficeTransformEnable(this.attachmentDAO.findAll(reference, subReference));
    }

    @Override
    public List<Attachment> getByReference(Long reference, Long ... subReferences) {
        return this.setOfficeTransformEnable(this.attachmentDAO.findAll(reference, subReferences));
    }

    @Override
    public void deleteByReference(Long reference) throws BusinessException {
        this.deleteByReference(reference, false);
    }

    @Override
    public void deleteByReference(List<Long> references) throws BusinessException {
        for (Long reference : references) {
            this.deleteByReference(reference, false);
        }
    }

    @Override
    public void deleteByReference(Long reference, int ... type) throws BusinessException {
        if (type == null) {
            this.deleteByReference(reference, false);
        } else {
            this.deleteByReference(reference, false, type);
        }
    }

    private void deleteByReference(Long reference, boolean isDeleteFromDisc, int ... type) throws BusinessException {
        if (type == null) {
            this.deleteByReference(reference, isDeleteFromDisc);
        } else {
            List<Attachment> attachments = this.attachmentDAO.findAll(reference);
            if (attachments != null && !attachments.isEmpty()) {
                for (Attachment objects : attachments) {
                    for (int typeIndex = 0; typeIndex < type.length; ++typeIndex) {
                        if (objects.getType() != type[typeIndex]) continue;
                        this.attachmentDAO.delete(objects.getId());
                        if (objects.getFileUrl() == null || objects.getCreatedate() == null) continue;
                        this.fileManager.deleteFile(objects.getFileUrl(), objects.getCreatedate(), isDeleteFromDisc);
                    }
                }
            }
        }
    }

    @Override
    public void removeByReference(Long reference) throws BusinessException {
        this.deleteByReference(reference, true);
    }

    private void deleteByReference(Long reference, boolean isDeleteFromDisc) throws BusinessException {
        List<Object[]> attachments = this.getAllFileUrlByReference(reference);
        if (attachments != null && !attachments.isEmpty()) {
            this.attachmentDAO.deleteByReference(reference);
            for (Object[] objects : attachments) {
                Long fileId = (Long)objects[0];
                Date createDate = (Date)objects[1];
                if (fileId == null || createDate == null) continue;
                this.fileManager.deleteFile(fileId, createDate, isDeleteFromDisc);
            }
        }
        log.debug((Object)("\u5220\u9664\u9644\u4ef6: [reference = " + reference + "]"));
    }

    @Override
    public void deleteByReference(Long reference, Long subReference) throws BusinessException {
        this.deleteByReference(reference, subReference, false);
    }

    @Override
    public void deleteOnlyAttByReference(Long reference) {
        this.attachmentDAO.deleteByReference(reference);
    }

    @Override
    public void removeByReference(Long reference, Long subReference) throws BusinessException {
        this.deleteByReference(reference, subReference, true);
    }

    private void deleteByReference(Long reference, Long subReference, boolean isDeleteFromDisc) throws BusinessException {
        List<Object[]> file = this.attachmentDAO.findAllFileUrl(reference, subReference);
        if (file != null && !file.isEmpty()) {
            this.attachmentDAO.deleteByReference(reference, subReference);
            for (Object[] objects : file) {
                Long fileId = (Long)objects[0];
                Date createDate = (Date)objects[1];
                if (fileId == null || createDate == null) continue;
                this.fileManager.deleteFile(fileId, createDate, isDeleteFromDisc);
            }
        }
        log.debug((Object)("\u5220\u9664\u9644\u4ef6: [reference = " + reference + " subReference = " + subReference + "]"));
    }

    @Override
    public void deleteById(long attachmentId) {
        this.attachmentDAO.delete(attachmentId);
    }

    @Override
    public String create(Long[] v3xFileId, ApplicationCategoryEnum cotegory, Long reference, Long subReference) {
        HashSet<Integer> r = new HashSet<Integer>();
        for (int i = 0; i < v3xFileId.length; ++i) {
            V3XFile file = null;
            try {
                file = this.fileManager.getV3XFile(v3xFileId[i]);
                if (file == null) continue;
                file.setCategory(cotegory.getKey());
                Attachment attachment = new Attachment();
                attachment.setIdIfNew();
                attachment.setSort(i);
                attachment.setReference(reference);
                attachment.setSubReference(subReference);
                attachment.setCategory(cotegory.getKey());
                attachment.setType(file.getType() == null ? Constants.ATTACHMENT_TYPE.FILE.ordinal() : file.getType().intValue());
                attachment.setFilename(file.getFilename());
                attachment.setMimeType(file.getMimeType());
                attachment.setFileUrl(file.getId());
                attachment.setCreatedate(file.getCreateDate());
                attachment.setSize(file.getSize());
                this.attachmentDAO.save(attachment);
                r.add(attachment.getType());
                continue;
            }
            catch (BusinessException e) {
                log.error((Object)e);
            }
        }
        return AttachmentManagerImpl.parseR(r);
    }

    @Override
    public List<Object[]> getAllFileUrlByReference(Long reference) {
        return this.attachmentDAO.findAllFileUrl(reference);
    }

    @Override
    public boolean hasAttachments(Long reference, Long subReference) {
        return this.attachmentDAO.hasAttachments(reference, subReference);
    }

    @Override
    public String create(ApplicationCategoryEnum category, Long reference, Long subReference) throws Exception {
        return this.create(category, reference, subReference, (HttpServletRequest)AppContext.getThreadContext("THREAD_CONTEXT_REQUEST_KEY"));
    }

    @Override
    public String create(ApplicationCategoryEnum category, Long reference, Long subReference, List<Map> attachList) throws Exception {
        return this.create(this.getAttachmentsFromAttachList(category, reference, subReference, attachList));
    }

    @Override
    public String create(ApplicationCategoryEnum category, Long reference, Long subReference, HttpServletRequest request) throws Exception {
        if (request.getAttribute("HASSAVEDATTACHMENT") != null) {
            return "";
        }
        request.setAttribute("HASSAVEDATTACHMENT", (Object)new Date());
        if (Strings.isNotBlank(request.getParameter("isEditAttachment"))) {
            this.deleteByReference(reference, subReference);
        }
        List<Attachment> attachments = this.getAttachmentsFromRequest(category, reference, subReference, request);
        return this.create(attachments);
    }

    @Override
    public List<Attachment> getAttachmentsFromRequest(ApplicationCategoryEnum category, Long reference, Long subReference, HttpServletRequest request) throws Exception {
        List<Attachment> result;
        List groups1 = ParamUtil.getJsonDomainGroup("attachmentInputs");
        int lsize = groups1.size();
        Map dMap = ParamUtil.getJsonDomain("attachmentInputs");
        if (lsize == 0 && dMap.size() > 0) {
            groups1.add(dMap);
        }
        if ((result = this.getAttachmentsFromAttachList(category, reference, subReference, groups1)).isEmpty()) {
            String[] fileUrl = request.getParameterValues("attachment_fileUrl");
            String[] mimeType = request.getParameterValues("attachment_mimeType");
            String[] size = request.getParameterValues("attachment_size");
            String[] createdate = request.getParameterValues("attachment_createDate");
            String[] filename = request.getParameterValues("attachment_filename");
            String[] type = request.getParameterValues("attachment_type");
            String[] needClone = request.getParameterValues("attachment_needClone");
            String[] description = request.getParameterValues("attachment_description");
            String[] extReference = request.getParameterValues("attachment_extReference");
            String[] extSubReference = request.getParameterValues("attachment_extSubReference");
            String[] subReferencea = request.getParameterValues("attachment_subReference");
            return this.getAttachmentsFromRequest(category, reference, subReference, fileUrl, mimeType, size, createdate, filename, type, needClone, description, extReference, extSubReference, subReferencea);
        }
        return result;
    }

    @Override
    public List<Attachment> getAttachmentsFromAttachList(ApplicationCategoryEnum category, Long reference, Long subReference, List mapList) throws Exception {
        List groups1 = mapList;
        int lsize = groups1.size();
        int i = 0;
        String[] fileUrl = new String[lsize];
        String[] extSubReference = new String[lsize];
        String[] mimeType = new String[lsize];
        String[] size = new String[lsize];
        String[] createdate = new String[lsize];
        String[] filename = new String[lsize];
        String[] type = new String[lsize];
        String[] needClone = new String[lsize];
        String[] description = new String[lsize];
        String[] extReference = new String[lsize];
        String[] subReferencea = new String[lsize];
        for (Object o : groups1) {
            if (!(o instanceof Map)) continue;
            Map map = (Map)o;
            String fileUrlStr = null;
            Object fileUrlObject = map.get("attachment_fileUrl");
            try {
                fileUrlStr = String.valueOf(fileUrlObject);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                fileUrlStr = String.valueOf(fileUrlObject);
            }
            fileUrl[i] = fileUrlStr;
            mimeType[i] = (String)map.get("attachment_mimeType");
            Object sizeObject = map.get("attachment_size");
            String sizeStr = null;
            try {
                sizeStr = String.valueOf(sizeObject);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                sizeStr = String.valueOf(sizeObject);
            }
            size[i] = sizeStr;
            createdate[i] = (String)map.get("attachment_createDate");
            filename[i] = (String)map.get("attachment_filename");
            String typeStr = null;
            Object typeObject = map.get("attachment_type");
            try {
                typeStr = String.valueOf(typeObject);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                typeStr = String.valueOf(typeObject);
            }
            type[i] = typeStr;
            needClone[i] = (String)map.get("attachment_needClone");
            description[i] = (String)map.get("attachment_description");
            extReference[i] = (String)map.get("attachment_extReference");
            subReferencea[i] = (String)map.get("attachment_subReference");
            ++i;
        }
        return this.getAttachmentsFromRequest(category, reference, subReference, fileUrl, mimeType, size, createdate, filename, type, needClone, description, extReference, extSubReference, subReferencea);
    }

    private List<Attachment> getAttachmentsFromRequest(ApplicationCategoryEnum category, Long reference, Long subReference, String[] fileUrl, String[] mimeType, String[] size, String[] createdate, String[] filename, String[] type, String[] needClone, String[] description, String[] extReference, String[] extSubReference, String[] subReferencea) throws Exception {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (fileUrl == null || mimeType == null || size == null || createdate == null || filename == null || type == null || needClone == null) {
            return attachments;
        }
        for (int i = 0; i < fileUrl.length; ++i) {
            boolean _isFile;
            Date originalCreateDate = Datetimes.parseDatetime(createdate[i]);
            Integer _type = Integer.valueOf(type[i]);
            Attachment attachment = new Attachment();
            attachment.setIdIfNew();
            attachment.setSort(i);
            attachment.setCategory(category.getKey());
            if (extReference != null && extReference.length >= i && Strings.isNotBlank(extReference[i])) {
                attachment.setReference(Long.valueOf(extReference[i]));
            } else if (reference != null) {
                attachment.setReference(reference);
            }
            if (extSubReference != null && extSubReference.length >= i && Strings.isNotBlank(extSubReference[i])) {
                attachment.setSubReference(Long.valueOf(extSubReference[i]));
            } else if (subReference != null) {
                attachment.setSubReference(subReference);
            } else if (Strings.isDigits(subReferencea[i])) {
                attachment.setSubReference(Long.valueOf(subReferencea[i]));
            }
            attachment.setMimeType(mimeType[i]);
            attachment.setSize(Long.valueOf(size[i]));
            attachment.setFilename(Strings.nobreakSpaceToSpace(filename[i]));
            attachment.setType(_type);
            attachment.setDescription(description[i]);
            if (Strings.isNotBlank(description[i]) && !"null".equals(description[i]) && (_type.equals(Constants.ATTACHMENT_TYPE.DOCUMENT.ordinal()) || _type.equals(Constants.ATTACHMENT_TYPE.FormDOCUMENT.ordinal()))) {
                Long genesisId = Long.parseLong(description[i]);
                attachment.setGenesisId(genesisId);
            }
            boolean _needClone = Boolean.parseBoolean(needClone[i]);
            boolean bl = _isFile = Constants.ATTACHMENT_TYPE.DOCUMENT.ordinal() != _type.intValue() && Constants.ATTACHMENT_TYPE.FormDOCUMENT.ordinal() != _type.intValue();
            if (_isFile && _needClone) {
                Long newFileId = UUIDLong.longUUID();
                Date newCreateDate = new Date();
                try {
                    this.fileManager.clone(Long.valueOf(fileUrl[i]), originalCreateDate, newFileId, newCreateDate);
                }
                catch (FileNotFoundException e) {
                    log.warn((Object)e.getMessage());
                }
                catch (Exception e) {
                    log.error((Object)"Clone \u9644\u4ef6", (Throwable)e);
                }
                attachment.setFileUrl(newFileId);
                attachment.setCreatedate(newCreateDate);
            } else {
                attachment.setCreatedate(originalCreateDate);
                if (NumberUtils.isNumber((String)fileUrl[i])) {
                    attachment.setFileUrl(Long.valueOf(fileUrl[i]));
                }
            }
            attachments.add(attachment);
        }
        return attachments;
    }

    @Override
    public List<Attachment> getAttachmentsFromRequestNotRelition(String attachstr) {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        String[] attstrs = attachstr.split("#");
        for (int i = 1; i < attachstr.length(); ++i) {
            String[] attstr = attstrs[i].split(";");
            Attachment attachment = new Attachment();
            if (attstr[0].split("=")[1] != null) {
                attachment.setId(Long.parseLong(attstr[0].split("=")[1]));
            }
            if (attstr[1].split("=")[1] != null) {
                attachment.setReference(Long.parseLong(attstr[1].split("=")[1]));
            }
            if (attstr[2].split("=")[1] != null) {
                attachment.setSubReference(Long.parseLong(attstr[2].split("=")[1]));
            }
            if (attstr[3].split("=")[1] != null) {
                attachment.setCategory(Integer.parseInt(attstr[3].split("=")[1]));
            }
            Integer type = null;
            if (attstr[4].split("=")[1] != null) {
                type = Integer.parseInt(attstr[4].split("=")[1]);
                attachment.setType(type);
            }
            if (attstr[5].split("=")[1] != null) {
                attachment.setFilename(attstr[5].split("=")[1]);
            }
            if (attstr[6].split("=")[1] != null) {
                attachment.setMimeType(attstr[6].split("=")[1]);
            }
            if (attstr[8].split("=")[1] != null) {
                attachment.setSize(Long.parseLong(attstr[8].split("=")[1]));
            }
            if (attstr[9].split("=")[1] != null) {
                attachment.setFileUrl(Long.parseLong(attstr[9].split("=")[1]));
            }
            if (attstr[10].split("=")[1] != null) {
                boolean typeIsDocument;
                String genesisIdStr = attstr[10].split("=")[1];
                attachment.setDescription(genesisIdStr);
                boolean bl = typeIsDocument = type.intValue() == Constants.ATTACHMENT_TYPE.DOCUMENT.ordinal() || type.intValue() == Constants.ATTACHMENT_TYPE.FormDOCUMENT.ordinal();
                if (Strings.isNotBlank(genesisIdStr) && !"null".equals(genesisIdStr) && typeIsDocument) {
                    Long genesisId = Long.parseLong(genesisIdStr);
                    attachment.setGenesisId(genesisId);
                }
            }
            attachments.add(attachment);
        }
        return attachments;
    }

    @Override
    public List<Attachment> getAttachmentsFromRequestNotRelition(HttpServletRequest request) {
        String[] fileUrl = request.getParameterValues("attachment_fileUrl");
        String[] mimeType = request.getParameterValues("attachment_mimeType");
        String[] size = request.getParameterValues("attachment_size");
        String[] createdate = request.getParameterValues("attachment_createDate");
        String[] filename = request.getParameterValues("attachment_filename");
        String[] type = request.getParameterValues("attachment_type");
        String[] needClone = request.getParameterValues("attachment_needClone");
        String[] description = request.getParameterValues("attachment_description");
        String[] genesisIds = request.getParameterValues("attachment_genesisId");
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (fileUrl == null || mimeType == null || size == null || createdate == null || filename == null || type == null || needClone == null) {
            return attachments;
        }
        for (int i = 0; i < fileUrl.length; ++i) {
            boolean _isFile;
            Date originalCreateDate = Datetimes.parseDatetime(createdate[i]);
            Integer _type = Integer.valueOf(type[i]);
            Attachment attachment = new Attachment();
            attachment.setMimeType(mimeType[i]);
            attachment.setSize(Long.valueOf(size[i]));
            attachment.setFilename(filename[i]);
            attachment.setType(_type);
            attachment.setDescription(description[i]);
            if (Strings.isNotBlank(description[i]) && !"null".equals(description[i]) && (_type.equals(Constants.ATTACHMENT_TYPE.DOCUMENT.ordinal()) || _type.equals(Constants.ATTACHMENT_TYPE.FormDOCUMENT.ordinal()))) {
                Long genesisId = Long.parseLong(description[i]);
                attachment.setGenesisId(genesisId);
            }
            boolean _needClone = Boolean.parseBoolean(needClone[i]);
            boolean bl = _isFile = Constants.ATTACHMENT_TYPE.DOCUMENT.ordinal() != _type.intValue() && Constants.ATTACHMENT_TYPE.FormDOCUMENT.ordinal() != _type.intValue();
            if (_isFile && _needClone) {
                Long newFileId = UUIDLong.longUUID();
                Date newCreateDate = new Date();
                try {
                    this.fileManager.clone(Long.valueOf(fileUrl[i]), originalCreateDate, newFileId, newCreateDate);
                }
                catch (FileNotFoundException e) {
                    log.warn((Object)e.getMessage());
                }
                catch (Exception e) {
                    log.error((Object)"Clone \u9644\u4ef6", (Throwable)e);
                }
                attachment.setFileUrl(newFileId);
                attachment.setCreatedate(newCreateDate);
            } else {
                attachment.setCreatedate(originalCreateDate);
                if (_isFile && NumberUtils.isNumber((String)fileUrl[i])) {
                    attachment.setFileUrl(Long.valueOf(fileUrl[i]));
                }
            }
            attachments.add(attachment);
        }
        return attachments;
    }

    @Override
    public String update(ApplicationCategoryEnum category, Long reference, Long subReference, HttpServletRequest request) throws Exception {
        this.deleteByReference(reference, subReference);
        return this.create(category, reference, subReference, request);
    }

    private static String parseR(Set<Integer> r) {
        StringBuilder str = new StringBuilder();
        for (Integer integer : r) {
            str.append(integer);
        }
        return str.toString();
    }

    public Attachment getFirstImageAttachment(Long reference, Long subReference) {
        return this.attachmentDAO.getFirst(reference, subReference, Constants.ATTACHMENT_TYPE.IMAGE);
    }

    @Override
    public Attachment getAttachmentByFileURL(Long fileURL) {
        return this.attachmentDAO.getAttachmentByFileURL(fileURL);
    }

    @Override
    public Attachment getAttachmentById(Long id) {
        return this.attachmentDAO.get(id);
    }

    @Override
    public List<Attachment> getAttachmentByFileURLs(List<Long> fileURLs) {
        return this.attachmentDAO.find(fileURLs);
    }

    @Override
    public List<Attachment> getAttachmentByFileURLStrings(String fileURLs) {
        ArrayList<Long> arrs = new ArrayList<Long>();
        for (String s : fileURLs.split(",")) {
            arrs.add(Long.parseLong(s));
        }
        return this.attachmentDAO.find(arrs);
    }

    @Override
    public void update(Attachment attachment) {
        this.attachmentDAO.update(attachment);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={BusinessException.class})
    public String copy(Long reference, Long subReference, Long newReference, Long newSubReference, Integer category, Long userId, Long accountId) {
        return this.copy(reference, subReference, newReference, newSubReference, category, userId, accountId, null);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={BusinessException.class})
    public String copy(Long reference, Long subReference, Long newReference, Long newSubReference, Integer category, Long userId, Long accountId, String filename) {
        List<Attachment> atts = this.getByReference(reference, subReference);
        Date now = new Date();
        HashSet<Integer> r = new HashSet<Integer>();
        for (Attachment att : atts) {
            Attachment newAtt = null;
            Long newFileId = UUIDLong.longUUID();
            try {
                newAtt = (Attachment)att.clone();
            }
            catch (Exception e1) {
                log.warn((Object)("\u590d\u5236\u89c1\u9644\u4ef6\u5bf9\u8c61\u5f02\ufffd\u5e38 [reference = " + reference + "]"), (Throwable)e1);
                continue;
            }
            newAtt.setId(UUIDLong.longUUID());
            try {
                if (att.getType().intValue() != Constants.ATTACHMENT_TYPE.DOCUMENT.ordinal() && att.getType().intValue() != Constants.ATTACHMENT_TYPE.FormDOCUMENT.ordinal()) {
                    this.fileManager.clone(att.getFileUrl(), att.getCreatedate(), newFileId, now);
                } else {
                    newFileId = att.getFileUrl();
                }
            }
            catch (FileNotFoundException e) {
                log.warn((Object)e.getMessage());
            }
            catch (Exception e) {
                log.warn((Object)("\u590d\u5236\u89c1\u9644\u4ef6\u6587\u4ef6\u5f02\ufffd\u5e38 [reference = " + reference + "]"), (Throwable)e);
            }
            newAtt.setFileUrl(newFileId);
            newAtt.setReference(newReference);
            newAtt.setSubReference(newSubReference);
            newAtt.setCreatedate(now);
            newAtt.setCategory(category);
            if (filename != null) {
                newAtt.setFilename(filename);
            }
            this.saveAttachment(newAtt, userId, accountId);
            r.add(newAtt.getType());
        }
        return AttachmentManagerImpl.parseR(r);
    }

    @Override
    public String copy(Long reference, Long subReference, Long newReference, Long newSubReference, Integer category) {
        User user = AppContext.getCurrentUser();
        if (user == null) {
            return null;
        }
        return this.copy(reference, subReference, newReference, newSubReference, category, user.getId(), user.getAccountId());
    }

    @Override
    public List<Attachment> copy(Long reference, Long subReference) {
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        List<Attachment> atts = this.getByReference(reference, subReference);
        Date now = new Date();
        for (Attachment att : atts) {
            Attachment newAtt = null;
            Long newFileId = UUIDLong.longUUID();
            try {
                newAtt = (Attachment)att.clone();
            }
            catch (Exception e1) {
                log.warn((Object)("\u590d\u5236\u89c1\u9644\u4ef6\u5bf9\u8c61\u5f02\ufffd\u5e38 [reference = " + reference + "]"), (Throwable)e1);
                continue;
            }
            newAtt.setIdIfNew();
            try {
                if (att.getType().intValue() != Constants.ATTACHMENT_TYPE.DOCUMENT.ordinal() && att.getType().intValue() != Constants.ATTACHMENT_TYPE.FormDOCUMENT.ordinal()) {
                    this.fileManager.clone(att.getFileUrl(), att.getCreatedate(), newFileId, now);
                } else {
                    newFileId = att.getFileUrl();
                }
            }
            catch (FileNotFoundException e) {
                log.warn((Object)e.getMessage());
            }
            catch (Exception e) {
                log.warn((Object)("\u590d\u5236\u89c1\u9644\u4ef6\u6587\u4ef6\u5f02\ufffd\u5e38 [reference = " + reference + "]"), (Throwable)e);
            }
            newAtt.setFileUrl(newFileId);
            newAtt.setReference(null);
            newAtt.setSubReference(null);
            newAtt.setCreatedate(now);
            result.add(newAtt);
        }
        return result;
    }

    @Override
    public long getAttSizeSum(long attId) {
        return this.attachmentDAO.get(attId).getSize();
    }

    @Override
    public boolean checkIsLicitGenesis(Long referenceId, Long genesisId) {
        return this.attachmentDAO.checkIsLicitGenesis(referenceId, genesisId);
    }

    @Override
    public void updateReference(Long fileUrl, Long referenceId) {
        this.attachmentDAO.updateReference(fileUrl, referenceId);
    }

    @Override
    public void updateReferenceByFileUrls(String fileUrls, Long referenceId) {
        for (String fileUrl : fileUrls.split(",")) {
            this.attachmentDAO.updateReference(Long.parseLong(fileUrl), referenceId);
        }
    }

    @Override
    public void updateReferenceSubReference(Long fileUrl, Long referenceId, Long subReference) {
        this.attachmentDAO.updateReferenceSubReference(fileUrl, referenceId, subReference);
    }

    @Override
    public void updateFileNameByAffairIds(String fileName, List<Long> affairIdList) {
        this.attachmentDAO.updateFileNameByAffairIds(fileName, affairIdList);
    }

    @Override
    public List<Long> getBySubReference(Long subReference) {
        return this.attachmentDAO.getBySubReference(subReference);
    }

    @Override
    public String create(Collection<Attachment> attachments, Long memberId, Long orgAccountId) {
        HashSet<Integer> r = new HashSet<Integer>();
        User user = new User();
        user.setId(memberId);
        user.setAccountId(orgAccountId);
        int i = 0;
        for (Attachment attachment : attachments) {
            attachment.setSort(i++);
            this.saveAttachment(attachment, user);
            r.add(attachment.getType());
        }
        return AttachmentManagerImpl.parseR(r);
    }

    @Override
    public List<Object[]> getByReference(Long reference, Integer type, FlipInfo flipInfo) {
        return this.attachmentDAO.findAll(reference, type, flipInfo);
    }

    @Override
    public void deleteByIds(List<Long> attachmentIds) {
        this.attachmentDAO.deleteByIds(attachmentIds);
    }

    @Override
    public List<Attachment> getBySubReference(List<Long> subReferences) {
        return this.attachmentDAO.getBySubReference(subReferences);
    }

    @Override
    public void saveAsAtt(List<Attachment> attachments) {
        int i = 0;
        for (Attachment attachment : attachments) {
            attachment.setIdIfNew();
            attachment.setSort(i++);
            this.attachmentDAO.save(attachment);
        }
    }

    @Override
    public String getFileNameExcludeSuffix(List<Attachment> attachments) {
        StringBuilder nameString = new StringBuilder();
        if (attachments != null && attachments.size() > 0) {
            for (int i = 0; i < attachments.size(); ++i) {
                Attachment tempAtt = attachments.get(i);
                String name = tempAtt.getFilename();
                String extension = tempAtt.getExtension();
                if (!Strings.isBlank(extension)) {
                    int index = name.lastIndexOf("." + extension);
                    if (index != -1) {
                        nameString.append(name.substring(0, index));
                    } else {
                        nameString.append(name);
                    }
                } else {
                    nameString.append(name);
                }
                if (i + 1 == attachments.size()) continue;
                nameString.append("|");
            }
        }
        return nameString.toString();
    }

    @Override
    public String getFilesmName(List<Attachment> attachments) {
        StringBuilder nameString = new StringBuilder();
        if (attachments != null && attachments.size() > 0) {
            int ccount = 0;
            for (int i = 0; i < attachments.size(); ++i) {
                ++ccount;
                Attachment tempAtt = attachments.get(i);
                String currAttName = tempAtt.getFilename();
                int index = currAttName.lastIndexOf(".");
                if (index < 0) {
                    nameString.append(ccount + "." + currAttName.substring(0));
                } else {
                    nameString.append(ccount + "." + currAttName.substring(0, index));
                }
                if (i + 1 == attachments.size()) continue;
                nameString.append("<br>");
            }
        }
        return nameString.toString();
    }

    @Override
    public List<Attachment> getByReference(List<Long> references) {
        return this.attachmentDAO.getByReference(references);
    }

    @Override
    public Attachment getAttachment(Long id) {
        return this.attachmentDAO.get(id);
    }
}

