/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.excel;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.excel.DataCell;
import com.seeyon.ctp.common.excel.DataRecord;
import com.seeyon.ctp.common.excel.DataRow;
import com.seeyon.ctp.common.excel.FileToExcelManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.web.util.WebUtil;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

@ProcessInDataSource(name=DataSourceName.BASE)
public class FileToExcelManagerImpl
implements FileToExcelManager {
    private static Log log = CtpLogFactory.getLog(FileToExcelManagerImpl.class);
    private static final String CACHE_KEY = "CACHE_EXCEL_STYLES";

    private Workbook doSheets(boolean isXSSF, DataRecord ... dataRecords) throws Exception {
        XSSFWorkbook wb;
        int sheetNum = dataRecords.length;
        if (sheetNum == 0) {
            throw new Exception("\u56e0\u6ca1\u6709\u63d0\u4f9b\u6570\u636e\uff0c\u6545\u4e0d\u80fd\u521b\u5efa\u5de5\u4f5c\u8868!");
        }
        if (isXSSF) {
            wb = new XSSFWorkbook();
            isXSSF = true;
        } else {
            wb = new HSSFWorkbook();
        }
        Sheet[] sheets = new Sheet[sheetNum];
        DataRecord dataRecord = null;
        StyleCache styleCache = new StyleCache((Workbook)wb);
        AppContext.putThreadContext(CACHE_KEY, styleCache);
        for (int i = 0; i < sheetNum; ++i) {
            dataRecord = dataRecords[i];
            if (dataRecord == null) {
                throw new Exception("DataRecord is disabled");
            }
            sheets[i] = wb.createSheet();
            Sheet sheet = sheets[i];
            String sheetName = dataRecord.getSheetName();
            if (Strings.isNotBlank(sheetName)) {
                if (sheetName.length() > 31) {
                    sheetName = sheetName.substring(0, 31);
                }
                if (sheetName.startsWith("'")) {
                    sheetName = sheetName.replaceFirst("'", "_");
                }
                if (sheetName.endsWith("'")) {
                    sheetName = sheetName.substring(0, sheetName.length() - 1) + "_";
                }
                sheetName = sheetName.replaceAll("[/:*?\\\\\\[\\]]", "_");
                wb.setSheetName(i, sheetName);
            }
            if (CollectionUtils.isEmpty(dataRecord.getDataHeadList())) {
                this.doSheet(sheet, dataRecord);
                continue;
            }
            this.doCrossSheet(sheet, dataRecord);
        }
        return wb;
    }

    private void doSheet(Sheet sheet, DataRecord dataRecord) {
        int c;
        if (sheet instanceof HSSFSheet) {
            HSSFSheet s = (HSSFSheet)sheet;
            s.setGridsPrinted(true);
        }
        sheet.setHorizontallyCenter(true);
        sheet.setAutobreaks(true);
        StyleCache styleCache = (StyleCache)AppContext.getThreadContext(CACHE_KEY);
        String[] columnName = dataRecord.getColumnName();
        int colunmLength = 0;
        if (columnName != null) {
            colunmLength = columnName.length;
        }
        int rowNumber = 0;
        Row row = sheet.createRow(rowNumber++);
        row.setHeightInPoints(25.0f);
        Cell cell = row.createCell(0);
        if (colunmLength > 1) {
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, colunmLength - 1));
        }
        cell.setCellValue(dataRecord.getTitle());
        cell.setCellStyle(styleCache.getTitle());
        if (dataRecord.getSubTitle() != null) {
            row = sheet.createRow(rowNumber++);
            row.setHeightInPoints(25.0f);
            if (dataRecord.getSubHeight() != 0) {
                row.setHeight(dataRecord.getSubHeight());
            }
            cell = row.createCell(0);
            if (colunmLength > 1) {
                sheet.addMergedRegion(new CellRangeAddress(rowNumber - 1, rowNumber - 1, 0, colunmLength - 1));
            }
            cell.setCellValue(dataRecord.getSubTitle());
            cell.setCellStyle(styleCache.getContentText());
        }
        boolean isAllNull = true;
        for (c = 0; c < colunmLength; ++c) {
            if (!Strings.isNotBlank(columnName[c])) continue;
            isAllNull = false;
            break;
        }
        if (!isAllNull) {
            row = sheet.createRow(rowNumber++);
            row.setHeightInPoints(20.0f);
            for (c = 0; c < colunmLength; ++c) {
                cell = row.createCell(c);
                cell.setCellValue(columnName[c]);
                cell.setCellStyle(styleCache.getColumn());
                cell.setAsActiveCell();
            }
        }
        this.doSheetContent(sheet, dataRecord, rowNumber);
    }

    private void doSheetContent(Sheet sheet, DataRecord dataRecord, int rowNumber) {
        short[] columnWith = dataRecord.getColumnWith();
        if (columnWith != null) {
            for (int j = 0; j < columnWith.length; ++j) {
                sheet.setColumnWidth(j, columnWith[j] * 200);
            }
        }
        StyleCache styleCache = (StyleCache)AppContext.getThreadContext(CACHE_KEY);
        int len = dataRecord.getRow().length;
        if (len > SpreadsheetVersion.EXCEL97.getMaxRows()) {
            len = SpreadsheetVersion.EXCEL97.getMaxRows();
        }
        for (int index = 0; index < len; ++index) {
            Row row = sheet.createRow(rowNumber++);
            row.setHeightInPoints(20.0f);
            DataRow dataRow = dataRecord.getRow()[index];
            if (dataRow == null) continue;
            short height = dataRow.getHeight();
            if (height != 0) {
                row.setHeight(height);
            }
            DataCell[] dataCells = dataRow.getCell();
            for (int col = 0; col < dataCells.length; ++col) {
                Cell cell = row.createCell(col);
                DataCell dataCell = dataCells[col];
                if (dataCell == null) continue;
                switch (dataCell.getType()) {
                    case 1: {
                        cell.setCellStyle(styleCache.getContentText());
                        cell.setCellValue(dataCell.getContent());
                        break;
                    }
                    case 3: {
                        cell.setCellStyle(styleCache.getContentBlank());
                        cell.setCellType(CellType.BLANK);
                        cell.setCellValue(dataCell.getContent());
                        break;
                    }
                    case 5: {
                        cell.setCellStyle(styleCache.getContentDate());
                        cell.setCellValue(dataCell.getContent());
                        break;
                    }
                    case 6: {
                        cell.setCellStyle(styleCache.getContentDatetime());
                        cell.setCellValue(dataCell.getContent());
                        break;
                    }
                    case 0: {
                        cell.setCellStyle(styleCache.getContentNumeric());
                        cell.setCellType(CellType.NUMERIC);
                        if (Strings.isBlank(dataCell.getContent())) {
                            cell.setCellValue("");
                            break;
                        }
                        try {
                            cell.setCellValue(Double.parseDouble(dataCell.getContent()));
                        }
                        catch (NumberFormatException e) {
                            cell.setCellValue(dataCell.getContent());
                        }
                        break;
                    }
                    case 9: {
                        cell.setCellStyle(styleCache.getContentNumeric_Thousandth());
                        cell.setCellType(CellType.NUMERIC);
                        if (Strings.isBlank(dataCell.getContent())) {
                            cell.setCellValue("");
                            break;
                        }
                        try {
                            cell.setCellValue(Double.parseDouble(dataCell.getContent()));
                        }
                        catch (NumberFormatException e) {
                            cell.setCellValue(dataCell.getContent());
                        }
                        break;
                    }
                    case 7: {
                        cell.setCellStyle(styleCache.getContentInteger());
                        if (Strings.isBlank(dataCell.getContent())) {
                            cell.setCellValue("");
                            break;
                        }
                        try {
                            cell.setCellValue((double)Long.parseLong(dataCell.getContent()));
                        }
                        catch (NumberFormatException e) {
                            cell.setCellValue(dataCell.getContent());
                        }
                        break;
                    }
                    case 10: {
                        cell.setCellStyle(styleCache.getContentInteger_Thousandth());
                        if (Strings.isBlank(dataCell.getContent())) {
                            cell.setCellValue("");
                            break;
                        }
                        try {
                            cell.setCellValue((double)Long.parseLong(dataCell.getContent()));
                        }
                        catch (NumberFormatException e) {
                            cell.setCellValue(dataCell.getContent());
                        }
                        break;
                    }
                    case 8: {
                        cell.setCellStyle(styleCache.getContentPercent());
                        cell.setCellType(CellType.NUMERIC);
                        if (Strings.isBlank(dataCell.getContent())) {
                            cell.setCellValue("");
                            break;
                        }
                        try {
                            cell.setCellValue(Double.parseDouble(dataCell.getContent()));
                        }
                        catch (NumberFormatException e) {
                            cell.setCellValue(dataCell.getContent());
                        }
                        break;
                    }
                    default: {
                        cell.setCellStyle(styleCache.getContentText());
                        cell.setCellValue(dataCell.getContent());
                    }
                }
                dataCell.afterCellRender(cell);
            }
            PrintSetup print = sheet.getPrintSetup();
            sheet.setAutobreaks(true);
            print.setPaperSize((short)9);
            print.setFitHeight((short)1);
            print.setFitWidth((short)1);
        }
    }

    private void doCrossSheet(Sheet sheet, DataRecord dataRecord) {
        if (sheet instanceof HSSFSheet) {
            HSSFSheet s = (HSSFSheet)sheet;
            s.setGridsPrinted(true);
        }
        sheet.setHorizontallyCenter(true);
        sheet.setAutobreaks(true);
        StyleCache styleCache = (StyleCache)AppContext.getThreadContext(CACHE_KEY);
        int colunmLength = 0;
        for (DataCell dataCell : dataRecord.getDataHeadList().get(0)) {
            colunmLength += dataCell.getColSpan();
        }
        int rowNumber = 0;
        Row row = sheet.createRow(rowNumber++);
        row.setHeightInPoints(25.0f);
        Cell cell = row.createCell(0);
        if (colunmLength > 1) {
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, colunmLength - 1));
        }
        cell.setCellValue(dataRecord.getTitle());
        cell.setCellStyle(styleCache.getTitle());
        if (dataRecord.getSubTitle() != null) {
            row = sheet.createRow(rowNumber++);
            row.setHeightInPoints(25.0f);
            cell = row.createCell(0);
            if (colunmLength > 1) {
                sheet.addMergedRegion(new CellRangeAddress(rowNumber - 1, rowNumber - 1, 0, colunmLength - 1));
            }
            cell.setCellValue(dataRecord.getSubTitle());
            cell.setCellStyle(styleCache.getContentText());
        }
        List<List<DataCell>> dataHeadList = dataRecord.getDataHeadList();
        List<DataCell> dataCellsFirst = dataHeadList.get(0);
        int dataCellsSecondColIndex = 0;
        row = sheet.createRow(rowNumber);
        row.setHeightInPoints(20.0f);
        int columnIndex = 0;
        for (DataCell dataCell : dataCellsFirst) {
            cell = row.createCell(columnIndex);
            if (dataCell.getRowSpan() > 1) {
                sheet.addMergedRegion(new CellRangeAddress(rowNumber, rowNumber + dataCell.getRowSpan() - 1, columnIndex, columnIndex));
                ++dataCellsSecondColIndex;
            }
            if (dataCell.getColSpan() > 1) {
                sheet.addMergedRegion(new CellRangeAddress(rowNumber, rowNumber, columnIndex, columnIndex + dataCell.getColSpan() - 1));
                columnIndex += dataCell.getColSpan();
            } else {
                ++columnIndex;
            }
            cell.setCellValue(dataCell.getContent());
            cell.setCellStyle(styleCache.getColumn());
            cell.setAsActiveCell();
        }
        if (dataHeadList.size() == 2) {
            row = sheet.createRow(++rowNumber);
            row.setHeightInPoints(20.0f);
            columnIndex = dataCellsSecondColIndex;
            List<DataCell> dataCellsSecond = dataHeadList.get(1);
            for (DataCell dataCell : dataCellsSecond) {
                cell = row.createCell(columnIndex);
                if (dataCell.getRowSpan() > 1) {
                    sheet.addMergedRegion(new CellRangeAddress(rowNumber, rowNumber + dataCell.getRowSpan() - 1, columnIndex, columnIndex));
                }
                if (dataCell.getColSpan() > 1) {
                    sheet.addMergedRegion(new CellRangeAddress(rowNumber, rowNumber, columnIndex, columnIndex + dataCell.getColSpan() - 1));
                    columnIndex += dataCell.getColSpan();
                } else {
                    ++columnIndex;
                }
                cell.setCellValue(dataCell.getContent());
                cell.setCellStyle(styleCache.getColumn());
                cell.setAsActiveCell();
            }
        }
        this.doSheetContent(sheet, dataRecord, ++rowNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(HttpServletResponse response, String name, DataRecord ... dataRecords) throws Exception {
        if (dataRecords == null || dataRecords.length == 0) {
            throw new IllegalArgumentException("\u4e0d\u80fd\u521b\u5efa\u5de5\u4f5c\u8868!");
        }
        String filename = name;
        boolean isXSSF = false;
        if (filename.endsWith(".xlsx")) {
            isXSSF = true;
        } else {
            isXSSF = false;
            if (filename.indexOf(".xls") == -1) {
                filename = filename + ".xls";
            }
        }
        Workbook wb = this.doSheets(isXSSF, dataRecords);
        response.setCharacterEncoding("UTF-8");
        try {
            this.setHeader(response, filename, "UTF-8");
            ServletOutputStream out_ = response.getOutputStream();
            wb.write((OutputStream)out_);
            out_.flush();
            out_.close();
        }
        catch (Exception e) {
            if ("ClientAbortException".equals(e.getClass().getSimpleName())) {
                log.debug((Object)("\u7528\u6237\u5173\u95ed\u4e0b\u8f7d\u7a97\u53e3: " + e.getMessage()));
            } else {
                log.error((Object)"\u5bfc\u51faExcel\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
        finally {
            if (wb != null) {
                wb.close();
                wb = null;
            }
        }
    }

    @Override
    public void saveAsCSV(HttpServletResponse response, String fileName, DataRecord dataRecords) {
        if (dataRecords == null) {
            throw new IllegalArgumentException("\u4e0d\u80fd\u521b\u5efa\u5de5\u4f5c\u8868!");
        }
        String name = fileName;
        if (name.indexOf(".csv") == -1) {
            name = name + ".csv";
        }
        StringBuilder str = new StringBuilder();
        String[] columnName = dataRecords.getColumnName();
        for (int k = 0; k < columnName.length; ++k) {
            if (k > 0) {
                str.append(",");
            }
            str.append("\"");
            str.append(columnName[k]);
            str.append("\"");
        }
        DataRow[] rows = dataRecords.getRow();
        for (int k = 0; k < rows.length; ++k) {
            str.append("\r\n");
            DataCell[] cells = rows[k].getCell();
            for (int i = 0; i < cells.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append("\"");
                str.append(this.toCsvString(cells[i].getContent()));
                str.append("\"");
            }
        }
        String charset = "UTF-8";
        response.setCharacterEncoding(charset);
        try {
            this.setHeader(response, name, charset);
            ServletOutputStream out_ = response.getOutputStream();
            out_.write(new byte[]{-17, -69, -65});
            out_.write(str.toString().getBytes(charset));
            out_.flush();
            out_.close();
        }
        catch (Exception e) {
            if ("ClientAbortException".equals(e.getClass().getSimpleName())) {
                log.debug((Object)("\u7528\u6237\u5173\u95ed\u4e0b\u8f7d\u7a97\u53e3: " + e.getMessage()));
            }
            log.error((Object)"\u5bfc\u51faCSV\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    private void setHeader(HttpServletResponse response, String filename, String charset) throws UnsupportedEncodingException {
        response.setContentType("application/octet-stream; charset=" + charset);
        filename = FileUtil.getDownloadFileName(WebUtil.getRequest(), filename);
        response.setHeader("Content-disposition", "attachment;" + filename + "");
    }

    private String toCsvString(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        String newContent = content.replaceAll("\"", "\"\"");
        if (((newContent = newContent.trim()).matches("[\\d]+") || newContent.matches("[\\d.]+")) && (newContent.length() > 11 || newContent.startsWith("0"))) {
            return "\t" + newContent;
        }
        return newContent;
    }

    @Override
    public List<List<String>> readExcel(File file) throws Exception {
        List<List<List<String>>> data = this.readExcelBySheets(file, 0);
        if (data != null && !data.isEmpty()) {
            return data.get(0);
        }
        return null;
    }

    @Override
    public List<List<String>> readExcel(File file, String type) throws Exception {
        List<List<List<String>>> data = this.readExcelBySheets(file, type, 0);
        if (data != null && !data.isEmpty()) {
            return data.get(0);
        }
        return null;
    }

    @Override
    public List<List<List<String>>> readExcelBySheets(File file) throws Exception {
        return this.readExcelBySheets(file, null, -1);
    }

    @Override
    public List<List<List<String>>> readExcelBySheets(File file, int ... sheetpages) throws Exception {
        return this.readExcelBySheets(file, null, sheetpages);
    }

    @Override
    public List<List<String>> readExcelBySheets(File file, String sheetName) throws Exception {
        return this.readExcelBySheets(file, null, sheetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<List<String>>> readExcelBySheets(File file, String type, int ... sheetpages) throws Exception {
        ArrayList<List<List<String>>> excellists;
        block20: {
            if (!file.exists()) {
                log.warn((Object)"\u5bfc\u5165\u7684Excel\u6587\u4ef6\u4e0d\u5b58\u5728!");
                throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            if (sheetpages == null || sheetpages.length < 1) {
                log.warn((Object)"\u5bfc\u5165\u7684Excel\u6587\u4ef6\u6ca1\u6709\u5de5\u4f5c\u8868!");
                throw new FileNotFoundException("Excel\u6587\u4ef6\u6ca1\u6709\u5de5\u4f5c\u8868");
            }
            excellists = new ArrayList<List<List<String>>>();
            FileInputStream in = null;
            Workbook wb = null;
            try {
                in = new FileInputStream(file);
                wb = WorkbookFactory.create((InputStream)in);
                if (sheetpages[0] == -1) {
                    for (Sheet sheet : wb) {
                        this.readSheet(sheet, type, excellists);
                    }
                    break block20;
                }
                for (int i = 0; i < sheetpages.length; ++i) {
                    Sheet sheet = null;
                    try {
                        sheet = wb.getSheetAt(sheetpages[i]);
                    }
                    catch (Exception e) {
                        throw new Exception(e.getLocalizedMessage(), e);
                    }
                    this.readSheet(sheet, type, excellists);
                }
            }
            catch (Exception e) {
                log.error((Object)("\u5bfc\u5165Excel\u6570\u636e\u6709\u9519:" + e.getMessage()), (Throwable)e);
                List<List<List<String>>> list = null;
                return list;
            }
            finally {
                if (wb != null) {
                    wb.close();
                }
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return excellists;
    }

    private void readSheet(Sheet sheet, String type, List<List<List<String>>> excellists) {
        ArrayList excellist = new ArrayList();
        int firstRow = sheet.getFirstRowNum();
        int lastRow = sheet.getLastRowNum();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(8);
        for (int s = firstRow; s <= lastRow; ++s) {
            ArrayList<String> rowlist = new ArrayList<String>();
            Row row = sheet.getRow(s);
            if (row != null) {
                int firstcell = row.getFirstCellNum();
                short lastcell = row.getLastCellNum();
                for (int k = 0; k < firstcell; ++k) {
                    rowlist.add("");
                }
                if (firstcell == -1) continue;
                for (int m = firstcell; m <= lastcell; ++m) {
                    Cell cell = row.getCell(m);
                    try {
                        if (cell != null && Strings.isNotBlank(type)) {
                            cell.setCellType(CellType.forInt((int)Integer.parseInt(type)));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"\u8f6c\u6362\u51fa\u73b0\u95ee\u9898", (Throwable)e);
                    }
                    String cellValue = "";
                    if (cell != null) {
                        if (CellType.ERROR.equals((Object)cell.getCellTypeEnum())) {
                            cellValue = null;
                            log.warn((Object)("[" + s + "," + m + "] has error value:" + cell));
                        } else if (CellType.STRING.equals((Object)cell.getCellTypeEnum())) {
                            cellValue = cell.getStringCellValue();
                        } else if (this.isCellDateFormatted(cell)) {
                            cellValue = this.getCellValueForDateType(cell);
                        } else if (CellType.NUMERIC.equals((Object)cell.getCellTypeEnum())) {
                            cellValue = numberFormat.format(cell.getNumericCellValue());
                        } else if (CellType.FORMULA.equals((Object)cell.getCellTypeEnum())) {
                            cell.setCellType(CellType.NUMERIC);
                            cellValue = numberFormat.format(cell.getNumericCellValue());
                            if (Strings.isNotBlank(cellValue) && cellValue.endsWith(".0")) {
                                cellValue = cellValue.substring(0, cellValue.length() - 2);
                            }
                        }
                    }
                    rowlist.add(cellValue);
                }
            }
            boolean insertFlag = false;
            for (String cellValue : rowlist) {
                if (!Strings.isNotBlank(cellValue)) continue;
                insertFlag = true;
                break;
            }
            if (!insertFlag) continue;
            excellist.add(rowlist);
        }
        excellists.add(excellist);
    }

    private boolean isCellDateFormatted(Cell cell) {
        double d;
        if (cell == null) {
            return false;
        }
        boolean bDate = false;
        try {
            d = cell.getNumericCellValue();
        }
        catch (Exception e) {
            throw new IllegalStateException(cell.getAddress() + "\u5355\u5143\u683c\u7684\u6570\u503c\u9519\u8bef:" + cell.getStringCellValue() + "." + e.getLocalizedMessage(), e);
        }
        if (DateUtil.isValidExcelDate((double)d)) {
            String f;
            CellStyle style = cell.getCellStyle();
            if (style == null) {
                return false;
            }
            short i = style.getDataFormat();
            bDate = HSSFDateUtil.isADateFormat((int)i, (String)(f = style.getDataFormatString()));
            if (!bDate && i == 31) {
                return true;
            }
        }
        return bDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> readExcelBySheets(File file, String type, String sheetName) throws Exception {
        if (!file.exists()) {
            log.warn((Object)"\u5bfc\u5165\u7684Excel\u6587\u4ef6\u4e0d\u5b58\u5728!");
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (sheetName == null || sheetName.trim().length() == 0) {
            log.warn((Object)"\u5bfc\u5165\u7684Excel\u6587\u4ef6\u6ca1\u6709\u5de5\u4f5c\u8868!");
            throw new FileNotFoundException("Excel\u6587\u4ef6\u6ca1\u6709\u5de5\u4f5c\u8868");
        }
        ArrayList<List<String>> excellist = new ArrayList<List<String>>();
        FileInputStream in = null;
        Workbook wb = null;
        try {
            in = new FileInputStream(file);
            wb = WorkbookFactory.create((InputStream)in);
            Sheet sheet = null;
            try {
                sheet = wb.getSheet(sheetName);
            }
            catch (Exception e) {
                throw new Exception(e.getLocalizedMessage(), e);
            }
            int firstRow = sheet.getFirstRowNum();
            int lastRow = sheet.getLastRowNum();
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setGroupingUsed(false);
            numberFormat.setMaximumFractionDigits(8);
            for (int s = firstRow; s <= lastRow; ++s) {
                ArrayList<String> rowlist = new ArrayList<String>();
                Row row = sheet.getRow(s);
                if (row != null) {
                    int firstcell = row.getFirstCellNum();
                    short lastcell = row.getLastCellNum();
                    for (int k = 0; k < firstcell; ++k) {
                        rowlist.add("");
                    }
                    if (firstcell == -1) continue;
                    for (int m = firstcell; m <= lastcell; ++m) {
                        Cell cell = row.getCell(m);
                        try {
                            if (cell != null && Strings.isNotBlank(type)) {
                                cell.setCellType(CellType.forInt((int)Integer.parseInt(type)));
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"\u8f6c\u6362\u51fa\u73b0\u95ee\u9898", (Throwable)e);
                        }
                        String cellValue = "";
                        if (cell != null) {
                            if (CellType.STRING.equals((Object)cell.getCellTypeEnum())) {
                                cellValue = cell.getStringCellValue();
                            } else if (this.isCellDateFormatted(cell)) {
                                cellValue = this.getCellValueForDateType(cell);
                            } else if (CellType.NUMERIC.equals((Object)cell.getCellTypeEnum())) {
                                cellValue = numberFormat.format(cell.getNumericCellValue());
                            } else if (CellType.FORMULA.equals((Object)cell.getCellTypeEnum())) {
                                cell.setCellType(CellType.NUMERIC);
                                cellValue = numberFormat.format(cell.getNumericCellValue());
                                if (Strings.isNotBlank(cellValue) && cellValue.endsWith(".0")) {
                                    cellValue = cellValue.substring(0, cellValue.length() - 2);
                                }
                            }
                        }
                        rowlist.add(cellValue);
                    }
                }
                boolean insertFlag = false;
                for (String cellValue : rowlist) {
                    if (!Strings.isNotBlank(cellValue)) continue;
                    insertFlag = true;
                    break;
                }
                if (!insertFlag) continue;
                excellist.add(rowlist);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u5bfc\u5165Excel\u6570\u636e\u6709\u9519:" + e.getMessage()), (Throwable)e);
            List<List<String>> list = null;
            return list;
        }
        finally {
            if (wb != null) {
                wb.close();
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
        return excellist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> readExcelAllContentBySheets(File file, String type, int ... sheetpages) throws Exception {
        ArrayList<Object> resultList = new ArrayList<Object>();
        ArrayList<String> sheetNameList = new ArrayList<String>();
        if (!file.exists()) {
            log.warn((Object)"\u5bfc\u5165\u7684Excel\u6587\u4ef6\u4e0d\u5b58\u5728!");
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (sheetpages == null || sheetpages.length < 1) {
            log.warn((Object)"\u5bfc\u5165\u7684Excel\u6587\u4ef6\u6ca1\u6709\u5de5\u4f5c\u8868!");
            throw new FileNotFoundException("Excel\u6587\u4ef6\u6ca1\u6709\u5de5\u4f5c\u8868");
        }
        ArrayList excellists = new ArrayList();
        FileInputStream in = null;
        Workbook wb = null;
        try {
            in = new FileInputStream(file);
            wb = WorkbookFactory.create((InputStream)in);
            for (int i = 0; i < sheetpages.length; ++i) {
                ArrayList excellist = new ArrayList();
                Sheet sheet = null;
                try {
                    sheet = wb.getSheetAt(sheetpages[i]);
                    sheetNameList.add(sheet.getSheetName());
                }
                catch (Exception e) {
                    throw new Exception(e.getLocalizedMessage(), e);
                }
                int firstRow = sheet.getFirstRowNum();
                int lastRow = sheet.getLastRowNum();
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setGroupingUsed(false);
                numberFormat.setMaximumFractionDigits(8);
                for (int s = firstRow; s <= lastRow; ++s) {
                    ArrayList<String> rowlist = new ArrayList<String>();
                    Row row = sheet.getRow(s);
                    if (row != null) {
                        int firstcell = row.getFirstCellNum();
                        short lastcell = row.getLastCellNum();
                        for (int k = 0; k < firstcell; ++k) {
                            rowlist.add("");
                        }
                        if (firstcell == -1) continue;
                        for (int m = firstcell; m <= lastcell; ++m) {
                            Cell cell = row.getCell(m);
                            try {
                                if (cell != null && Strings.isNotBlank(type)) {
                                    cell.setCellType(CellType.forInt((int)Integer.parseInt(type)));
                                }
                            }
                            catch (Exception e) {
                                log.error((Object)"\u8f6c\u6362\u51fa\u73b0\u95ee\u9898", (Throwable)e);
                            }
                            String cellValue = "";
                            if (cell != null) {
                                if (CellType.STRING.equals((Object)cell.getCellTypeEnum())) {
                                    cellValue = cell.getStringCellValue();
                                } else if (this.isCellDateFormatted(cell)) {
                                    cellValue = this.getCellValueForDateType(cell);
                                } else if (CellType.NUMERIC.equals((Object)cell.getCellTypeEnum())) {
                                    cellValue = numberFormat.format(cell.getNumericCellValue());
                                } else if (CellType.FORMULA.equals((Object)cell.getCellTypeEnum())) {
                                    try {
                                        cell.setCellType(CellType.NUMERIC);
                                        cellValue = numberFormat.format(cell.getNumericCellValue());
                                        if (Strings.isNotBlank(cellValue) && cellValue.endsWith(".0")) {
                                            cellValue = cellValue.substring(0, cellValue.length() - 2);
                                        }
                                    }
                                    catch (Exception e) {
                                        cellValue = cell.getStringCellValue();
                                    }
                                }
                            }
                            rowlist.add(cellValue);
                        }
                    }
                    boolean insertFlag = false;
                    for (String cellValue : rowlist) {
                        if (!Strings.isNotBlank(cellValue)) continue;
                        insertFlag = true;
                        break;
                    }
                    if (!insertFlag) continue;
                    excellist.add(rowlist);
                }
                excellists.add(excellist);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u5bfc\u5165Excel\u6570\u636e\u6709\u9519:" + e.getMessage()), (Throwable)e);
            List<Object> list = null;
            return list;
        }
        finally {
            if (wb != null) {
                wb.close();
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
        resultList.add(sheetNameList);
        resultList.add(excellists);
        return resultList;
    }

    private String getCellValueForDateType(Cell cell) {
        String cellValue = "";
        Date cellDate = cell.getDateCellValue();
        if (cellDate == null) {
            return cellValue;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(cellDate);
        int second = calendar.get(13);
        if (second == 59) {
            calendar.add(12, 1);
            calendar.add(13, -59);
        }
        cellValue = Datetimes.formatDateOrDatetime(calendar.getTime());
        return cellValue;
    }

    @Override
    public void saveExcelInBase(String filePath, String fileName, DataRecord dataRecords) {
        if (dataRecords == null) {
            throw new IllegalArgumentException("\u4e0d\u80fd\u521b\u5efa\u5de5\u4f5c\u8868!");
        }
        StringBuilder str = new StringBuilder();
        String[] columnName = dataRecords.getColumnName();
        for (int k = 0; k < columnName.length; ++k) {
            if (k > 0) {
                str.append(",");
            }
            str.append("\"");
            str.append(columnName[k]);
            str.append("\"");
        }
        DataRow[] rows = dataRecords.getRow();
        for (int k = 0; k < rows.length; ++k) {
            str.append("\r\n");
            DataCell[] cells = rows[k].getCell();
            for (int i = 0; i < cells.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append("\"");
                str.append(this.toCsvString(cells[i].getContent()));
                str.append("\"");
            }
        }
        String charset = "UTF-8";
        File file = new File(filePath);
        try {
            if (!file.exists()) {
                file.getParentFile().mkdir();
                file.createNewFile();
            }
            FileOutputStream out_ = new FileOutputStream(file);
            out_.write(new byte[]{-17, -69, -65});
            out_.write(str.toString().getBytes(charset));
            out_.flush();
            out_.close();
        }
        catch (Exception e) {
            if ("ClientAbortException".equals(e.getClass().getSimpleName())) {
                log.debug((Object)("\u7528\u6237\u5173\u95ed\u4e0b\u8f7d\u7a97\u53e3: " + e.getMessage()));
            }
            log.error((Object)"\u5bfc\u51faexcel\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    class StyleCache {
        private CellStyle title;
        private CellStyle column;
        private CellStyle contentText;
        private CellStyle contentBlank;
        private CellStyle contentDate;
        private CellStyle contentDatetime;
        private CellStyle contentNumeric;
        private CellStyle contentNumericThousandth;
        private CellStyle contentInteger;
        private CellStyle contentIntegerThousandth;
        private CellStyle contentPercent;

        public StyleCache(Workbook wb) {
            this.initStyle(wb);
        }

        private CellStyle getTitle() {
            return this.title;
        }

        public CellStyle getColumn() {
            return this.column;
        }

        public CellStyle getContentText() {
            return this.contentText;
        }

        public CellStyle getContentBlank() {
            return this.contentBlank;
        }

        public CellStyle getContentDate() {
            return this.contentDate;
        }

        public CellStyle getContentDatetime() {
            return this.contentDatetime;
        }

        public CellStyle getContentNumeric() {
            return this.contentNumeric;
        }

        public CellStyle getContentNumeric_Thousandth() {
            return this.contentNumericThousandth;
        }

        public CellStyle getContentInteger() {
            return this.contentInteger;
        }

        public CellStyle getContentInteger_Thousandth() {
            return this.contentIntegerThousandth;
        }

        public CellStyle getContentPercent() {
            return this.contentPercent;
        }

        private void initStyle(Workbook wb) {
            this.title = wb.createCellStyle();
            this.column = wb.createCellStyle();
            this.contentText = wb.createCellStyle();
            this.contentBlank = wb.createCellStyle();
            this.contentDate = wb.createCellStyle();
            this.contentDatetime = wb.createCellStyle();
            this.contentNumeric = wb.createCellStyle();
            this.contentNumericThousandth = wb.createCellStyle();
            this.contentInteger = wb.createCellStyle();
            this.contentIntegerThousandth = wb.createCellStyle();
            this.contentPercent = wb.createCellStyle();
            DataFormat format = wb.createDataFormat();
            Font fontTitle = wb.createFont();
            fontTitle.setBold(true);
            fontTitle.setFontHeightInPoints((short)16);
            this.title.setFont(fontTitle);
            this.title.setVerticalAlignment(VerticalAlignment.CENTER);
            this.title.setAlignment(HorizontalAlignment.CENTER);
            short dataformat = format.getFormat("text");
            this.title.setDataFormat(dataformat);
            Font fontCulumn = wb.createFont();
            fontCulumn.setBold(true);
            this.column.setFont(fontCulumn);
            this.column.setVerticalAlignment(VerticalAlignment.CENTER);
            this.column.setAlignment(HorizontalAlignment.CENTER);
            this.column.setDataFormat(dataformat);
            Font fontContent = wb.createFont();
            this.contentText.setFont(fontContent);
            this.contentText.setVerticalAlignment(VerticalAlignment.CENTER);
            this.contentText.setHidden(true);
            this.contentText.setWrapText(true);
            this.contentText.setDataFormat(dataformat);
            this.contentDate.setFont(fontContent);
            this.contentDate.setVerticalAlignment(VerticalAlignment.CENTER);
            this.contentDate.setHidden(true);
            this.contentDate.setWrapText(true);
            this.contentDate.setDataFormat(format.getFormat("yyyy-m-d"));
            this.contentDatetime.setFont(fontContent);
            this.contentDatetime.setVerticalAlignment(VerticalAlignment.CENTER);
            this.contentDatetime.setHidden(true);
            this.contentDatetime.setWrapText(true);
            this.contentDatetime.setDataFormat(format.getFormat("yyyy-m-d H:mm:ss"));
            this.contentNumeric.setFont(fontContent);
            this.contentNumeric.setVerticalAlignment(VerticalAlignment.CENTER);
            this.contentNumeric.setHidden(true);
            this.contentNumeric.setWrapText(true);
            this.contentNumeric.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00"));
            this.contentNumericThousandth.setFont(fontContent);
            this.contentNumericThousandth.setVerticalAlignment(VerticalAlignment.CENTER);
            this.contentNumericThousandth.setHidden(true);
            this.contentNumericThousandth.setWrapText(true);
            this.contentNumericThousandth.setDataFormat((short)4);
            this.contentInteger.setFont(fontContent);
            this.contentInteger.setVerticalAlignment(VerticalAlignment.CENTER);
            this.contentInteger.setHidden(true);
            this.contentInteger.setWrapText(true);
            this.contentInteger.setDataFormat(format.getFormat("0"));
            this.contentIntegerThousandth.setFont(fontContent);
            this.contentIntegerThousandth.setVerticalAlignment(VerticalAlignment.CENTER);
            this.contentIntegerThousandth.setHidden(true);
            this.contentIntegerThousandth.setWrapText(true);
            this.contentIntegerThousandth.setDataFormat((short)3);
            this.contentPercent.setFont(fontContent);
            this.contentPercent.setVerticalAlignment(VerticalAlignment.CENTER);
            this.contentPercent.setHidden(true);
            this.contentPercent.setWrapText(true);
            this.contentPercent.setDataFormat((short)10);
        }
    }
}

