/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.encrypt;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.config.SystemConfig;
import com.seeyon.ctp.common.encrypt.ICoder;
import com.seeyon.ctp.common.encrypt.TV01Coder;
import com.seeyon.ctp.common.encrypt.TV02Coder;
import com.seeyon.ctp.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;

public class CoderFactory {
    private final String KEY = "62C20D8F29A243D3";
    private static final CoderFactory factory = new CoderFactory();
    private Map<String, Object> fileLocks = new ConcurrentHashMap<String, Object>();
    private Object dLock = new Object();

    private CoderFactory() {
    }

    public static CoderFactory getInstance() {
        return factory;
    }

    public String getEncryptVersion() {
        String encryptVersion = null;
        SystemConfig systemConfig = (SystemConfig)AppContext.getBean("systemConfig");
        String configItem = systemConfig.get("attach_encrypt");
        encryptVersion = configItem != null && !"no".equals(configItem) ? ("middle".equals(configItem) ? "V02" : "V01") : "no";
        return encryptVersion;
    }

    public void download(InputStream in, OutputStream out) throws Exception {
        byte[] temp = new byte["seeyon attachment encrypt v01".getBytes("ISO-8859-1").length];
        int count = in.read(temp);
        String head = new String(temp);
        if ("seeyon attachment encrypt v01".equals(head)) {
            TV01Coder code = new TV01Coder();
            code.initKey("62C20D8F29A243D3");
            code.decode(in, out);
        } else if ("seeyon attachment encrypt v02".equals(head)) {
            TV02Coder code = new TV02Coder();
            code.initKey("62C20D8F29A243D3");
            code.decode(in, out);
        } else {
            if (count > 0) {
                out.write(temp);
            }
            this.directOutput(in, out);
        }
    }

    public String download(byte[] buffer) throws Exception {
        byte[] temp = new byte["seeyon attachment encrypt v01".getBytes("ISO-8859-1").length];
        if (buffer.length - temp.length > 0) {
            byte[] temp1 = new byte[buffer.length - temp.length];
            System.arraycopy(buffer, 0, temp, 0, temp.length);
            System.arraycopy(buffer, temp.length, temp1, 0, temp1.length);
            String head = new String(temp);
            if ("seeyon attachment encrypt v01".equals(head)) {
                TV01Coder code = new TV01Coder();
                code.initKey("62C20D8F29A243D3");
                return code.decodeStr(temp1);
            }
            if ("seeyon attachment encrypt v02".equals(head)) {
                TV02Coder code = new TV02Coder();
                code.initKey("62C20D8F29A243D3");
                return code.decodeStr(temp1);
            }
        }
        return new String(buffer);
    }

    public void upload(InputStream in, OutputStream out, String version) throws Exception {
        Class<?> coderClass = Class.forName("com.seeyon.ctp.common.encrypt.T" + version.toUpperCase() + "Coder");
        ICoder coder = (ICoder)coderClass.newInstance();
        coder.initKey("62C20D8F29A243D3");
        coder.encode(in, out);
    }

    public String getFileToString(String realPath) throws Exception {
        FileInputStream fis = new FileInputStream(realPath);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.download(fis, baos);
        fis.close();
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        String encoding = FileUtil.detectEncoding(bis);
        if (encoding != null) {
            if ("KOI8-R".equalsIgnoreCase(encoding) || "WINDOWS-1252".equals(encoding) || "IBM855".equals(encoding)) {
                return baos.toString("GB18030");
            }
            return baos.toString(encoding);
        }
        return baos.toString();
    }

    private void directOutput(InputStream in, OutputStream out) throws Exception {
        int count = 0;
        byte[] temp = new byte[8192];
        while (count >= 0) {
            count = in.read(temp);
            if (count <= 0) continue;
            out.write(temp, 0, count);
        }
        in.close();
        out.close();
    }

    public String decryptFileToTemp(String srcFilePath) throws Exception {
        return this.decryptFileToTemp(new File(srcFilePath)).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File decryptFileToTemp(File srcFile) throws Exception {
        if (!srcFile.exists()) {
            return srcFile;
        }
        String dectFilePath = SystemEnvironment.getSystemTempFolder() + File.separator + srcFile.getName() + "D" + srcFile.lastModified();
        File dectFile = new File(dectFilePath);
        if (dectFile.exists()) {
            return dectFile;
        }
        Object fileLock = null;
        Object object = this.dLock;
        synchronized (object) {
            fileLock = this.fileLocks.get(dectFilePath);
            if (fileLock == null) {
                fileLock = new Object();
                this.fileLocks.put(dectFilePath, fileLock);
            }
        }
        object = fileLock;
        synchronized (object) {
            File file;
            FileOutputStream out;
            FileInputStream in;
            block15: {
                String head;
                block14: {
                    if (dectFile.exists()) {
                        return dectFile;
                    }
                    in = null;
                    out = null;
                    in = new FileInputStream(srcFile);
                    byte[] temp = new byte["seeyon attachment encrypt v01".getBytes("ISO-8859-1").length];
                    ((InputStream)in).read(temp);
                    head = new String(temp);
                    if (!"seeyon attachment encrypt v01".equals(head)) break block14;
                    out = new FileOutputStream(dectFile);
                    TV01Coder code = new TV01Coder();
                    code.initKey("62C20D8F29A243D3");
                    code.decode(in, out);
                    File file2 = dectFile;
                    this.fileLocks.remove(dectFilePath);
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)out);
                    return file2;
                }
                if (!"seeyon attachment encrypt v02".equals(head)) break block15;
                out = new FileOutputStream(dectFile);
                TV02Coder code = new TV02Coder();
                code.initKey("62C20D8F29A243D3");
                code.decode(in, out);
                File file3 = dectFile;
                this.fileLocks.remove(dectFilePath);
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
                return file3;
            }
            try {
                file = srcFile;
                this.fileLocks.remove(dectFilePath);
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    this.fileLocks.remove(dectFilePath);
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
            return file;
        }
    }

    public void encryptFile(String srcFile, String dectFile) throws Exception {
        FileOutputStream out;
        FileInputStream in;
        block5: {
            in = null;
            out = null;
            try {
                in = new FileInputStream(srcFile);
                out = new FileOutputStream(dectFile);
                String encryptVersion = this.getEncryptVersion();
                if ("no".equals(encryptVersion)) {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    break block5;
                }
                this.upload(in, out, encryptVersion);
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }
}

