/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.dao.support.page;

import com.seeyon.ctp.common.config.PerformanceConfig;
import java.io.Serializable;
import java.util.ArrayList;

public class Page
implements Serializable {
    private static final long serialVersionUID = 6885283719635364199L;
    public static int DEFAULT_PAGE_SIZE = PerformanceConfig.getInstance().getIntegerConfig("paginate.page.size", 20);
    private int start;
    private int pageSize = DEFAULT_PAGE_SIZE;
    private Object data;
    private int totalCount;

    public Page() {
        this(0, 0, DEFAULT_PAGE_SIZE, new ArrayList());
    }

    public Page(int start, int totalSize, int pageSize, Object data) {
        this.pageSize = pageSize;
        this.start = start;
        this.totalCount = totalSize;
        this.data = data;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getTotalPageCount() {
        if (this.totalCount % this.pageSize == 0) {
            return this.totalCount / this.pageSize;
        }
        return this.totalCount / this.pageSize + 1;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Object getResult() {
        return this.data;
    }

    public int getCurrentPageNo() {
        return this.start / this.pageSize + 1;
    }

    public boolean hasNextPage() {
        return this.getCurrentPageNo() < this.getTotalPageCount() - 1;
    }

    public boolean hasPreviousPage() {
        return this.getCurrentPageNo() > 1;
    }

    protected static int getStartOfPage(int pageNo) {
        return Page.getStartOfPage(pageNo, DEFAULT_PAGE_SIZE);
    }

    protected static int getStartOfPage(int pageNo, int pageSize) {
        return (pageNo - 1) * pageSize;
    }
}

