/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.ctpenumnew;

import com.seeyon.ctp.common.ctpenumnew.Enums;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnum;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumBean;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItemPO;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumMember;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumPO;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import www.seeyon.com.utils.StringUtil;

public class CtpEnumUtil {
    public static final String newCtpEnumBeanHql = " new " + CtpEnumBean.class.getCanonicalName() + "(id,enumtype,sortnumber,ifuse,enumstate,description,orgAccountId,parentId,programCode,category,edit,ruleCtp,enumname,i18n,belongMemberId,createMemberId)";
    public static final String newCtpEnumItemHql = " new " + CtpEnumItem.class.getCanonicalName() + "(id,refEnumid,showvalue,enumvalue,sortnumber,state,outputSwitch,orgAccountId,parentId,rootId,levelNum,description,ifuse,i18n,imageId)";
    public static final String SUCCESS = "success";
    public static Comparator<CtpEnumItem> enumItemComparator = new Comparator<CtpEnumItem>(){

        @Override
        public int compare(CtpEnumItem o1, CtpEnumItem o2) {
            int result = 0;
            Long id1 = o1.getSortnumber();
            Long id2 = o2.getSortnumber();
            if (id1 != null && id2 != null) {
                result = id1 > id2 ? 1 : (id1 < id2 ? -1 : 0);
            }
            return result;
        }
    };
    public static Comparator<CtpEnumBean> enumComparator = new Comparator<CtpEnumBean>(){

        @Override
        public int compare(CtpEnumBean o1, CtpEnumBean o2) {
            int result = 0;
            Integer id1 = o1.getSortnumber();
            Integer id2 = o2.getSortnumber();
            if (id1 != null && id2 != null) {
                result = id1 > id2 ? 1 : (id1 < id2 ? -1 : 0);
            }
            return result;
        }
    };

    public static CtpEnumBean transCtpEnumToBean(CtpEnum ctpEnum) {
        CtpEnumBean ctpEnumBean = new CtpEnumBean();
        ctpEnumBean.setId(ctpEnum.getId());
        ctpEnumBean.setEnumtype(ctpEnum.getEnumtype());
        ctpEnumBean.setSortnumber(ctpEnum.getSortnumber());
        ctpEnumBean.setIfuse(ctpEnum.getIfuse());
        ctpEnumBean.setEnumstate(ctpEnum.getEnumstate());
        ctpEnumBean.setDescription(ctpEnum.getDescription());
        ctpEnumBean.setOrgAccountId(ctpEnum.getOrgAccountId());
        ctpEnumBean.setParentId(ctpEnum.getParentId());
        ctpEnumBean.setProgramCode(ctpEnum.getProgramCode());
        ctpEnumBean.setCategory(ctpEnum.getCategory());
        ctpEnumBean.setEdit(ctpEnum.isEdit());
        ctpEnumBean.setRuleCtp(ctpEnum.getRuleCtp());
        ctpEnumBean.setEnumname(ctpEnum.getOriginalEnumname());
        ctpEnumBean.setI18n(ctpEnum.getI18n());
        ctpEnumBean.setBelongMemberId(ctpEnum.getBelongMemberId());
        ctpEnumBean.setCreateMemberId(ctpEnum.getCreateMemberId());
        return ctpEnumBean;
    }

    public static List<CtpEnumBean> transCtpEnumToBean(List transList) {
        List<CtpEnumBean> resultList = null;
        if (Strings.isNotEmpty(transList)) {
            resultList = new ArrayList<CtpEnumBean>(transList.size());
            for (int i = 0; i < transList.size(); ++i) {
                resultList.add(CtpEnumUtil.transCtpEnumToBean((CtpEnum)transList.get(i)));
            }
        } else {
            resultList = Collections.emptyList();
        }
        return resultList;
    }

    public static CtpEnum transBeanToCtpEnum(CtpEnumBean bean) {
        CtpEnum ctpEnum = new CtpEnum();
        ctpEnum.setId(bean.getId());
        ctpEnum.setEnumtype(bean.getEnumtype());
        ctpEnum.setSortnumber(bean.getSortnumber());
        ctpEnum.setIfuse(bean.getIfuse());
        ctpEnum.setEnumstate(bean.getEnumstate());
        ctpEnum.setDescription(bean.getDescription());
        ctpEnum.setOrgAccountId(bean.getOrgAccountId());
        ctpEnum.setParentId(bean.getParentId());
        ctpEnum.setProgramCode(bean.getProgramCode());
        ctpEnum.setCategory(bean.getCategory());
        ctpEnum.setEdit(bean.isEdit());
        ctpEnum.setRuleCtp(bean.getRuleCtp());
        ctpEnum.setEnumname(bean.getOriginalEnumname());
        ctpEnum.setI18n(bean.getI18n());
        ctpEnum.setBelongMemberId(bean.getBelongMemberId());
        ctpEnum.setCreateMemberId(bean.getCreateMemberId());
        return ctpEnum;
    }

    public static CtpEnumBean cloneEnumBean(CtpEnumBean ctpEnum) {
        CtpEnumBean ctpEnumBean = new CtpEnumBean();
        ctpEnumBean.setId(ctpEnum.getId());
        ctpEnumBean.setEnumtype(ctpEnum.getEnumtype());
        ctpEnumBean.setSortnumber(ctpEnum.getSortnumber());
        ctpEnumBean.setIfuse(ctpEnum.getIfuse());
        ctpEnumBean.setEnumstate(ctpEnum.getEnumstate());
        ctpEnumBean.setDescription(ctpEnum.getDescription());
        ctpEnumBean.setOrgAccountId(ctpEnum.getOrgAccountId());
        ctpEnumBean.setParentId(ctpEnum.getParentId());
        ctpEnumBean.setProgramCode(ctpEnum.getProgramCode());
        ctpEnumBean.setCategory(ctpEnum.getCategory());
        ctpEnumBean.setEdit(ctpEnum.isEdit());
        ctpEnumBean.setRuleCtp(ctpEnum.getRuleCtp());
        ctpEnumBean.setEnumname(ctpEnum.getOriginalEnumname());
        ctpEnumBean.setI18n(ctpEnum.getI18n());
        ctpEnumBean.setMaxDepth(ctpEnum.getMaxDepth());
        ctpEnumBean.setBelongMemberId(ctpEnum.getBelongMemberId());
        ctpEnumBean.setBelongTo(ctpEnum.getBelongTo());
        ctpEnumBean.setCreateMemberId(ctpEnum.getCreateMemberId());
        ctpEnumBean.setAuthorizedMember(ctpEnum.getAuthorizedMember());
        ctpEnumBean.setAuthorizedPepoles(ctpEnum.getAuthorizedPepoles());
        if (null != ctpEnum.getItems()) {
            ctpEnumBean.setItems(new ArrayList<CtpEnumItem>(ctpEnum.getItems()));
        }
        return ctpEnumBean;
    }

    public static CtpEnumItem cloneEnumItem(CtpEnumItem cei) {
        CtpEnumItem newCei = new CtpEnumItem();
        newCei.setId(cei.getId());
        newCei.setDescription(cei.getDescription());
        newCei.setEnumvalue(cei.getEnumvalue());
        newCei.setI18n(cei.getI18n());
        newCei.setIfuse(cei.getIfuse());
        newCei.setLevelNum(cei.getLevelNum());
        newCei.setOrgAccountId(cei.getOrgAccountId());
        newCei.setOutputSwitch(cei.getOutputSwitch());
        newCei.setParentId(cei.getParentId());
        newCei.setRefEnumid(cei.getRefEnumid());
        newCei.setRootId(cei.getRootId());
        newCei.setShowvalue(cei.getOriginalShowvalue());
        newCei.setSortnumber(cei.getSortnumber());
        newCei.setState(cei.getState());
        newCei.setImageId(cei.getImageId());
        return newCei;
    }

    public static List<CtpEnumMember> convertAuthorizeList(Long enumId, String memberIds) {
        String[] members;
        ArrayList<CtpEnumMember> result = new ArrayList<CtpEnumMember>();
        if (Strings.isBlank(memberIds)) {
            return result;
        }
        for (String memberId : members = memberIds.split(",")) {
            CtpEnumMember ctpEnumMember = new CtpEnumMember();
            ctpEnumMember.setIdIfNew();
            ctpEnumMember.setEnumId(enumId);
            ctpEnumMember.setMemberId(Long.parseLong(memberId));
            result.add(ctpEnumMember);
        }
        return result;
    }

    public static String convertAuthorizeMemberIds(List<CtpEnumMember> list) {
        StringBuilder memberIds = new StringBuilder();
        if (Strings.isNotEmpty(list)) {
            for (CtpEnumMember ctpEnumMember : list) {
                if (null == ctpEnumMember.getMemberId()) continue;
                memberIds.append("Member|" + ctpEnumMember.getMemberId().toString() + ",");
            }
            if (memberIds.length() > 0) {
                memberIds.deleteCharAt(memberIds.length() - 1);
            }
        }
        return memberIds.toString();
    }

    public static String extractMemberIds(String ids) {
        if (Strings.isBlank(ids)) {
            return null;
        }
        StringBuffer memberIds = new StringBuffer();
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; ++i) {
            memberIds.append(id[i].split("[|]")[1] + ",");
        }
        if (memberIds.length() > 0) {
            memberIds.deleteCharAt(memberIds.length() - 1);
        }
        return memberIds.toString();
    }

    public static int caculateEnumType(CtpEnum ctpEnum) {
        CtpEnumBean formEnumBean = CtpEnumUtil.transCtpEnumToBean(ctpEnum);
        return CtpEnumUtil.caculateEnumType(formEnumBean);
    }

    public static int caculateEnumType(CtpEnumBean ctpEnumBean) {
        int result = ctpEnumBean == null || ctpEnumBean.getEnumtype() == null ? -1 : (ctpEnumBean.getEnumtype() == 1 ? Enums.EnumTabType.SYSTEMENUM.getKey() : (ctpEnumBean.getEnumtype() == 7 || ctpEnumBean.getEnumtype() == 3 && ctpEnumBean.getCategory() != null && ctpEnumBean.getCategory() == -3 ? Enums.EnumTabType.BUSINESSENUM.getKey() : (ctpEnumBean.getEnumtype() == 8 || ctpEnumBean.getEnumtype() == 3 && ctpEnumBean.getCategory() != null && ctpEnumBean.getCategory() == -4 ? Enums.EnumTabType.BUSINESSIMAGEENUM.getKey() : (ctpEnumBean.getEnumtype() == 4 || ctpEnumBean.getEnumtype() == 3 && ctpEnumBean.getCategory() != null && ctpEnumBean.getCategory() == 1 ? Enums.EnumTabType.UNITIMAGEENUM.getKey() : (ctpEnumBean.getEnumtype() == 5 ? Enums.EnumTabType.UNITSEEWORKENUM.getKey() : (ctpEnumBean.getEnumtype() == 0 || ctpEnumBean.getEnumtype() == 3 && (ctpEnumBean.getCategory() == null || ctpEnumBean.getCategory() != 1) ? (ctpEnumBean.getOrgAccountId() == null ? Enums.EnumTabType.PUBLICENUM.getKey() : Enums.EnumTabType.ORGENUM.getKey()) : -1))))));
        return result;
    }

    public static List<CtpEnumPO> toPOS(List<CtpEnum> enumList) {
        if (CollectionUtils.isEmpty(enumList)) {
            return Collections.emptyList();
        }
        ArrayList<CtpEnumPO> pos = new ArrayList<CtpEnumPO>(enumList.size());
        for (CtpEnum ctpEnum : enumList) {
            pos.add(CtpEnumUtil.toPO(ctpEnum));
        }
        return pos;
    }

    public static CtpEnumPO toPO(CtpEnum ctpEnum) {
        if (ctpEnum == null) {
            return null;
        }
        CtpEnumPO po = new CtpEnumPO();
        po.setId(ctpEnum.getId());
        po.setEnumtype(ctpEnum.getEnumtype());
        po.setSortnumber(ctpEnum.getSortnumber());
        po.setIfuse(ctpEnum.getIfuse());
        po.setEnumstate(ctpEnum.getEnumstate());
        po.setDescription(ctpEnum.getDescription());
        po.setOrgAccountId(ctpEnum.getOrgAccountId());
        po.setParentId(ctpEnum.getParentId());
        po.setProgramCode(ctpEnum.getProgramCode());
        po.setCategory(ctpEnum.getCategory());
        po.setEdit(ctpEnum.isEdit());
        po.setRuleCtp(ctpEnum.getRuleCtp());
        po.setEnumname(ctpEnum.getOriginalEnumname());
        po.setI18n(ctpEnum.getI18n());
        po.setBelongMemberId(ctpEnum.getBelongMemberId());
        po.setCreateMemberId(ctpEnum.getCreateMemberId());
        return po;
    }

    public static List<CtpEnum> toBOS(List<CtpEnumPO> enumList) {
        if (CollectionUtils.isEmpty(enumList)) {
            return Collections.emptyList();
        }
        ArrayList<CtpEnum> bos = new ArrayList<CtpEnum>(enumList.size());
        for (CtpEnumPO ctpEnum : enumList) {
            bos.add(CtpEnumUtil.toBO(ctpEnum));
        }
        return bos;
    }

    public static CtpEnum toBO(CtpEnumPO po) {
        if (po == null) {
            return null;
        }
        CtpEnum ctpEnum = new CtpEnum();
        ctpEnum.setId(po.getId());
        ctpEnum.setEnumtype(po.getEnumtype());
        ctpEnum.setSortnumber(po.getSortnumber());
        ctpEnum.setIfuse(po.getIfuse());
        ctpEnum.setEnumstate(po.getEnumstate());
        ctpEnum.setDescription(po.getDescription());
        ctpEnum.setOrgAccountId(po.getOrgAccountId());
        ctpEnum.setParentId(po.getParentId());
        ctpEnum.setProgramCode(po.getProgramCode());
        ctpEnum.setCategory(po.getCategory());
        ctpEnum.setEdit(po.isEdit());
        ctpEnum.setRuleCtp(po.getRuleCtp());
        ctpEnum.setEnumname(po.getEnumname());
        ctpEnum.setI18n(po.getI18n());
        ctpEnum.setBelongMemberId(po.getBelongMemberId());
        ctpEnum.setCreateMemberId(po.getCreateMemberId());
        return ctpEnum;
    }

    public static List<CtpEnumItem> toItemBOS(List<CtpEnumItemPO> enumList) {
        if (CollectionUtils.isEmpty(enumList)) {
            return Collections.emptyList();
        }
        ArrayList<CtpEnumItem> bos = new ArrayList<CtpEnumItem>(enumList.size());
        for (CtpEnumItemPO ctpEnum : enumList) {
            bos.add(CtpEnumUtil.toBO(ctpEnum));
        }
        return bos;
    }

    public static CtpEnumItem toBO(CtpEnumItemPO po) {
        CtpEnumItem item = new CtpEnumItem();
        item.setId(po.getId());
        item.setDescription(po.getDescription());
        item.setEnumvalue(po.getEnumvalue());
        item.setI18n(po.getI18n());
        item.setIfuse(po.getIfuse());
        item.setLevelNum(po.getLevelNum());
        item.setOrgAccountId(po.getOrgAccountId());
        item.setOutputSwitch(po.getOutputSwitch());
        item.setParentId(po.getParentId());
        item.setRefEnumid(po.getRefEnumid());
        item.setRootId(po.getRootId());
        item.setShowvalue(po.getShowvalue());
        item.setSortnumber(po.getSortnumber());
        item.setState(po.getState());
        item.setImageId(po.getImageId());
        return item;
    }

    public static List<CtpEnumItemPO> toItemPOS(List<CtpEnumItem> enumList) {
        if (CollectionUtils.isEmpty(enumList)) {
            return Collections.emptyList();
        }
        ArrayList<CtpEnumItemPO> pos = new ArrayList<CtpEnumItemPO>(enumList.size());
        for (CtpEnumItem ctpEnum : enumList) {
            pos.add(CtpEnumUtil.toPO(ctpEnum));
        }
        return pos;
    }

    public static CtpEnumItemPO toPO(CtpEnumItem item) {
        CtpEnumItemPO po = new CtpEnumItemPO();
        po.setId(item.getId());
        po.setDescription(item.getDescription());
        po.setEnumvalue(item.getEnumvalue());
        po.setI18n(item.getI18n());
        po.setIfuse(item.getIfuse());
        po.setLevelNum(item.getLevelNum());
        po.setOrgAccountId(item.getOrgAccountId());
        po.setOutputSwitch(item.getOutputSwitch());
        po.setParentId(item.getParentId());
        po.setRefEnumid(item.getRefEnumid());
        po.setRootId(item.getRootId());
        po.setShowvalue(item.getOriginalShowvalue());
        po.setSortnumber(item.getSortnumber());
        po.setState(item.getState());
        po.setImageId(item.getImageId());
        return po;
    }

    public static String validateEnumItem(int i, List<String> itemNames, String itemValue, String itemSortNum) {
        int langSize = itemNames.size();
        int size = itemNames.size();
        for (int j = 0; j < size; ++j) {
            String itemName = itemNames.get(j);
            if (!StringUtils.isBlank((CharSequence)itemName)) continue;
            return ResourceUtil.getString("enum.import.the") + (i + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.value.showName.empty", langSize * 2 + 3 + j);
        }
        if (StringUtils.isBlank((CharSequence)itemValue)) {
            return ResourceUtil.getString("enum.import.the") + (i + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.value.empty", langSize * 3 + 3);
        }
        if (StringUtils.isBlank((CharSequence)itemSortNum)) {
            return ResourceUtil.getString("enum.import.the") + (i + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.value.sort.empty", langSize * 3 + 4);
        }
        Integer preSize = null;
        int size2 = itemNames.size();
        for (int j = 0; j < size2; ++j) {
            String[] names;
            String name = itemNames.get(j);
            for (String ns : names = name.split("==")) {
                if (!StringUtils.isNotBlank((CharSequence)ns) || ns.length() <= 85) continue;
                return ResourceUtil.getString("enum.import.the") + (i + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.value.faild", langSize * 2 + 3 + j);
            }
            if (preSize == null) {
                preSize = names.length;
                continue;
            }
            if (preSize == names.length) continue;
            return ResourceUtil.getString("enum.import.the") + (i + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.value.faild1", langSize * 2 + 3 + j);
        }
        if (!StringUtil.isInteger((String)itemValue)) {
            return ResourceUtil.getString("enum.import.the") + (i + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.value.integer", langSize * 3 + 3);
        }
        if (itemValue != null && itemValue.length() > 15) {
            return ResourceUtil.getString("enum.import.the") + (i + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.value.15", langSize * 3 + 3);
        }
        int sortNum = Integer.parseInt(itemSortNum);
        if (sortNum > 9999) {
            return ResourceUtil.getString("enum.import.the") + (i + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.value.sort.big", langSize * 3 + 4);
        }
        if (sortNum < -9999) {
            return ResourceUtil.getString("enum.import.the") + (i + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.value.sort.small", langSize * 3 + 4);
        }
        return SUCCESS;
    }

    public static String validatecategory(int index, List<String> categroyNames, String categroySortNum) {
        int langSize = categroyNames.size();
        int size = categroyNames.size();
        for (int j = 0; j < size; ++j) {
            String categroyName = categroyNames.get(j);
            if (categroyName.length() <= 85) continue;
            return ResourceUtil.getString("enum.import.the") + (index + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.categroy.name.faild", j + 1);
        }
        if (Strings.isBlank(categroySortNum)) {
            return ResourceUtil.getString("enum.import.the") + (index + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.categroy.sort.empty", langSize + 1);
        }
        if (!StringUtil.isInteger((String)categroySortNum)) {
            return ResourceUtil.getString("enum.import.the") + (index + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.categroy.sort.integer", langSize + 1);
        }
        if (Integer.parseInt(categroySortNum) > 99999999) {
            return ResourceUtil.getString("enum.import.the") + (index + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.categroy.sort.99999999", langSize + 1);
        }
        if (Integer.parseInt(categroySortNum) < -99999999) {
            return ResourceUtil.getString("enum.import.the") + (index + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.categroy.sort.-99999999", langSize + 1);
        }
        return SUCCESS;
    }

    public static String validateEnum(int index, List<String> enumNames, String enumSortNum) {
        int langSize = enumNames.size();
        int size = enumNames.size();
        for (int j = 0; j < size; ++j) {
            String enumName = enumNames.get(j);
            if (StringUtils.isBlank((CharSequence)enumName)) {
                return ResourceUtil.getString("enum.import.the") + (index + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.showName.empty", langSize + 2 + j);
            }
            if (enumName.length() <= 85) continue;
            return ResourceUtil.getString("enum.import.the") + (index + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.showName.faild", langSize + 2 + j);
        }
        if (StringUtils.isBlank((CharSequence)enumSortNum)) {
            return ResourceUtil.getString("enum.import.the") + (index + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.sortNum.empty", langSize * 2 + 2);
        }
        if (!StringUtil.isInteger((String)enumSortNum)) {
            return ResourceUtil.getString("enum.import.the") + (index + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.sort.integer", langSize * 2 + 2);
        }
        if (Integer.parseInt(enumSortNum) > 99999999) {
            return ResourceUtil.getString("enum.import.the") + (index + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.sort.99999999", langSize * 2 + 2);
        }
        if (Integer.parseInt(enumSortNum) < -99999999) {
            return ResourceUtil.getString("enum.import.the") + (index + 1) + ResourceUtil.getString("enum.import.row") + ResourceUtil.getString("enum.import.enum.sort.-99999999", langSize * 2 + 2);
        }
        return SUCCESS;
    }
}

