/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.controller;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.util.BooleanBinder;
import com.seeyon.ctp.util.DateBinder;
import com.seeyon.ctp.util.NumberBinder;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

public abstract class BaseController
extends MultiActionController {
    public static final String REDIRECT_BACK = "-BACK-";
    public static final String DATA_NO_EXISTS = "NoExists";

    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    protected void printV3XJS(PrintWriter out) {
        out.println("<script type=\"text/javascript\" charset=\"UTF-8\" src=\"" + SystemEnvironment.getContextPath() + "/common/js/V3X.js\"></script>");
    }

    protected void printV3XJS(HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        this.printV3XJS(response.getWriter());
    }

    protected void infoCloseOrFresh(HttpServletRequest request, HttpServletResponse response, String infoMsg) throws Exception {
        PrintWriter out = response.getWriter();
        this.printV3XJS(out);
        out.println("<script>");
        out.println("alert(\"" + StringEscapeUtils.escapeEcmaScript((String)infoMsg) + "\")");
        out.println("if(window.dialogArguments){");
        out.println("  window.returnValue = \"true\";");
        out.println("  window.close();");
        out.println("}else{");
        out.println("  parent.getA8Top().reFlesh();");
        out.println("}");
        out.println("");
        out.println("</script>");
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new DateBinder(true));
        binder.registerCustomEditor(Integer.class, (PropertyEditor)new NumberBinder(Integer.class, true));
        binder.registerCustomEditor(Double.class, (PropertyEditor)new NumberBinder(Double.class, true));
        binder.registerCustomEditor(Long.class, (PropertyEditor)new NumberBinder(Long.class, true));
        binder.registerCustomEditor(Boolean.class, (PropertyEditor)new BooleanBinder(true));
    }

    protected void preBind(HttpServletRequest request, Object object, ServletRequestDataBinder binder) throws Exception {
    }

    protected String getCommandName(Object command) {
        return StringUtils.uncapitalize((String)command.getClass().getSimpleName());
    }

    protected void addValidator(Validator validator) {
        ArrayUtils.add((Object[])this.getValidators(), (Object)validator);
    }

    protected void rendText(HttpServletResponse response, String content) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.write(content);
        out.close();
    }

    protected void rendJavaScript(HttpServletResponse response, String jsContent) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<script type=\"text/javascript\">");
        out.println(jsContent);
        out.println("</script>");
        out.close();
    }

    protected void rendJavaScriptUnclose(HttpServletResponse response, String jsContent) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<script type=\"text/javascript\">");
        out.println(jsContent);
        out.println("</script>");
        out.flush();
    }

    protected ModelAndView redirectModelAndView(String url) {
        return new ModelAndView("common/redirect", "redirectURL", (Object)url);
    }

    protected ModelAndView redirectModelAndView(String url, String location) {
        ModelAndView m = new ModelAndView("common/redirect");
        m.addObject("redirectURL", (Object)url);
        m.addObject("location", (Object)location);
        return m;
    }

    protected ModelAndView refreshWorkspace() {
        return new ModelAndView("common/refresh");
    }

    protected ModelAndView refreshWindow(String jsWindow) {
        return new ModelAndView("common/refreshWindow").addObject("windowObj", (Object)jsWindow);
    }

    protected ModelAndView refreshWindow(String jsWindow, String jsScript) {
        return new ModelAndView("common/refreshWindow").addObject("windowObj", (Object)jsWindow).addObject("jsScript", (Object)jsScript);
    }

    protected void noCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragrma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    protected ModelAndView buildView(final String content) {
        ModelAndView mvc = new ModelAndView();
        View view = new View(){

            public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0L);
                response.setContentType("text/html;charset=UTF-8");
                response.getWriter().print(content);
            }

            public String getContentType() {
                return "text/html;charset=UTF-8";
            }
        };
        mvc.setView(view);
        return mvc;
    }
}

