/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.constdef.manager;

import com.seeyon.ctp.common.constdef.ConstDefUtil;
import com.seeyon.ctp.common.constdef.cache.ConstDefCacheManager;
import com.seeyon.ctp.common.constdef.dao.ConstDefDao;
import com.seeyon.ctp.common.constdef.exception.ConstDefException;
import com.seeyon.ctp.common.constdef.manager.ConstDefManager;
import com.seeyon.ctp.common.dao.support.page.Page;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.constdef.ConstDef;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.FlipInfo;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.springframework.util.Assert;

@ProcessInDataSource(name=DataSourceName.BASE)
public class ConstDefManagerImpl
implements ConstDefManager {
    private static final Log log = CtpLogFactory.getLog(ConstDefManagerImpl.class);
    private ConstDefDao constDefDao;

    public void setConstDefDao(ConstDefDao constDefDao) {
        this.constDefDao = constDefDao;
    }

    @Override
    public List<ConstDef> getAll() {
        return this.constDefDao.getAll();
    }

    @Override
    public Page listPage(int pageNo, int pageSize) {
        Page page = new Page();
        page = this.constDefDao.listPage("select def from ConstDef def", pageNo, pageSize);
        List list = (List)page.getResult();
        this.updateConstValue(list);
        return page;
    }

    @Override
    public FlipInfo listPage(FlipInfo flipInfo, Map params) {
        Page page = this.constDefDao.listPage("select def from ConstDef def", flipInfo.getPage(), flipInfo.getSize());
        List list = (List)page.getResult();
        this.updateConstValue(list);
        for (ConstDef def : list) {
            if (StringUtils.equals((CharSequence)def.getConstType(), (CharSequence)"3")) {
                def.setConstType("\u8868\u8fbe\u5f0f");
            }
            if (StringUtils.equals((CharSequence)def.getConstType(), (CharSequence)"4")) {
                def.setConstType("\u5b8f\u66ff\u6362");
            }
            if (StringUtils.equals((CharSequence)def.getConstType(), (CharSequence)"1")) {
                def.setConstType("\u6570\u503c");
            }
            if (!StringUtils.equals((CharSequence)def.getConstType(), (CharSequence)"2")) continue;
            def.setConstType("\u5b57\u7b26");
        }
        flipInfo.setData(list);
        flipInfo.setTotal(page.getTotalCount());
        return flipInfo;
    }

    @Override
    public List<ConstDef> findByDescription(String description) {
        Assert.notNull((Object)description, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a: \u63cf\u8ff0");
        ConstDef def = new ConstDef();
        def.setConstDescription(description);
        List<ConstDef> list = this.constDefDao.findByExample(def);
        this.updateConstValue(list);
        return list;
    }

    @Override
    public ConstDef findByConstKey(String constKey) {
        Assert.notNull((Object)constKey, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a: \u952e");
        ConstDef def = new ConstDef();
        def.setConstKey(constKey);
        List<ConstDef> list = this.constDefDao.findByExample(def);
        ConstDef result = null;
        if (list != null && list.size() != 0) {
            result = list.get(0);
        }
        this.updateConstValue(result);
        return result;
    }

    @Override
    public void insertConstDef(ConstDef def) throws ConstDefException {
        Assert.notNull((Object)def, (String)"\u5e38\u91cf\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)def.getConstKey(), (String)"\u5e38\u91cf \u952e \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)def.getConstDefine(), (String)"\u5e38\u91cf\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        ConstDef exist = this.findByConstKey(def.getConstKey());
        Assert.isNull((Object)exist, (String)"\u64cd\u4f5c\u5931\u8d25, \u952e\u5df2\u5b58\u5728");
        ConstDefCacheManager modifyListener = ConstDefCacheManager.getInstance();
        modifyListener.onAdd(def);
        this.constDefDao.add(def);
    }

    @Override
    public void deleteConstDef(ConstDef def) throws ConstDefException {
        Assert.notNull((Object)def, (String)"\u5e38\u91cf\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        def = this.constDefDao.findById(def.getId());
        ConstDefCacheManager modifyListener = ConstDefCacheManager.getInstance();
        modifyListener.onDelete(def);
        this.constDefDao.delete(def);
    }

    @Override
    public void updateConstDef(ConstDef def) throws ConstDefException {
        Assert.notNull((Object)def, (String)"\u5e38\u91cf\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)def.getConstKey(), (String)"\u5e38\u91cf \u952e \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)def.getConstDefine(), (String)"\u5e38\u91cf\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        ConstDefCacheManager modifyListener = ConstDefCacheManager.getInstance();
        modifyListener.onModify(def);
        this.constDefDao.update(def);
    }

    private void updateConstValue(ConstDef def) {
        if (def != null) {
            String constValue = ConstDefUtil.getConstDefValue(def.getConstKey());
            def.setConstValue(constValue);
        }
    }

    private void updateConstValue(List<ConstDef> list) {
        if (list != null && list.size() != 0) {
            for (ConstDef def : list) {
                this.updateConstValue(def);
            }
        }
    }

    @Override
    public ConstDef findById(Long id) {
        return this.constDefDao.findById(id);
    }
}

