/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.constdef.cache;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constdef.cache.ConstDefReferRecord;
import com.seeyon.ctp.common.constdef.cache.IConstDefCacheManager;
import com.seeyon.ctp.common.constdef.cache.IConstDefModifyListener;
import com.seeyon.ctp.common.constdef.exception.ConstDefException;
import com.seeyon.ctp.common.constdef.manager.ConstDefManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.constdef.ConstDef;
import com.seeyon.ctp.common.script.ScriptEvaluator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class ConstDefCacheManager
implements IConstDefModifyListener,
IConstDefCacheManager {
    private static final Log log = CtpLogFactory.getLog(ConstDefCacheManager.class);
    private AtomicBoolean inited = new AtomicBoolean(Boolean.FALSE);
    private ConcurrentHashMap<String, ConstDef> cacheMap = new ConcurrentHashMap();
    private ConstDefReferRecord refRecord = new ConstDefReferRecord();
    private static ConstDefCacheManager instance = null;

    @Override
    public void onSystemStartup() {
        if (!this.inited.get()) {
            log.debug((Object)"ConstDefCacheManager initCacheOnSystemStartup start.");
            try {
                ConstDefManager manager = (ConstDefManager)AppContext.getBeanWithoutCache("constDefManager");
                List<ConstDef> list = manager.getAll();
                for (ConstDef def : list) {
                    this.cacheMap.put(def.getConstKey(), def);
                }
                for (ConstDef def : this.cacheMap.values()) {
                    String constValue = this.computeConstValue(def);
                    def.setConstValue(constValue);
                }
                for (ConstDef def : this.cacheMap.values()) {
                    Set<String> refers = this.parserRefKey(def.getConstDefine());
                    for (String ref : refers) {
                        this.refRecord.addReferBy(ref, def.getConstKey());
                    }
                }
                this.inited.set(Boolean.TRUE);
            }
            catch (Exception e) {
                log.error((Object)"ConstDefCache initCacheOnSystemStartup Error: ", (Throwable)e);
            }
            log.debug((Object)"ConstDefCacheManager initCacheOnSystemStartup finish.");
        }
    }

    @Override
    public void onAdd(ConstDef def) throws ConstDefException {
        this.validateFormat(def);
        String key = def.getConstKey();
        if (this.cacheMap.containsKey(def.getConstKey())) {
            throw new ConstDefException("\u64cd\u4f5c\u5931\u8d25, \u952e\u5df2\u5b58\u5728, " + key);
        }
        this.cacheMap.put(key, def);
        for (String ref : this.parserRefKey(def.getConstDefine())) {
            this.refRecord.addReferBy(ref, def.getConstKey());
        }
        log.debug((Object)("constDef Added : " + def.toString()));
    }

    @Override
    public void onDelete(ConstDef def) throws ConstDefException {
        String key = def.getConstKey();
        if (!this.cacheMap.containsKey(key)) {
            throw new ConstDefException("\u64cd\u4f5c\u5931\u8d25, \u952e\u4e0d\u5b58\u5728, " + key);
        }
        if (this.refRecord.hasReferBy(key)) {
            throw new ConstDefException("\u64cd\u4f5c\u5931\u8d25, \u5e38\u91cf\u8fd8\u6709\u5f15\u7528");
        }
        this.cacheMap.remove(key);
        this.refRecord.deleteKey(key);
        log.debug((Object)("constDef Deleted : " + def.toString()));
    }

    @Override
    public void onModify(ConstDef def) throws ConstDefException {
        String key = def.getConstKey();
        if (!this.cacheMap.containsKey(key)) {
            throw new ConstDefException("\u64cd\u4f5c\u5931\u8d25, \u952e\u4e0d\u5b58\u5728, " + key);
        }
        this.validateFormat(def);
        ConstDef oldDef = this.cacheMap.get(key);
        Set<String> oldRefBys = this.refRecord.getReferBys(oldDef.getConstKey());
        for (String ref : oldRefBys) {
            this.refRecord.removeReferBy(ref, key);
        }
        for (String k : oldRefBys) {
            this.cacheMap.get(k).setConstValue(null);
        }
        Set<String> oldRefs = this.parserRefKey(oldDef.getConstDefine());
        for (String refby : oldRefs) {
            this.refRecord.removeReferBy(refby, key);
        }
        for (String s : this.parserRefKey(def.getConstDefine())) {
            this.refRecord.addReferBy(s, def.getConstKey());
        }
        this.cacheMap.put(key, def);
        log.debug((Object)("constDef Modified : " + def.toString()));
    }

    @Override
    public String getConstDefValue(String constKey) {
        String value = "";
        ConstDef def = this.cacheMap.get(constKey);
        if (def != null) {
            if (StringUtils.isBlank((CharSequence)def.getConstValue())) {
                String constValue = this.computeConstValue(def);
                def.setConstValue(constValue);
            }
            value = def.getConstValue();
        }
        return value;
    }

    public ConstDef getConstDef(String constKey) {
        return this.cacheMap.get(constKey);
    }

    private String computeConstValue(ConstDef def) {
        String constDefine = def.getConstDefine();
        String constValue = "";
        if (constDefine.contains("$")) {
            try {
                Object result = "\u8868\u8fbe\u5f0f\u8ba1\u7b97\u5f02\u5e38";
                Set<String> refs = this.parserRefKey(constDefine);
                if (def.getConstType().equals("4")) {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    for (String ref : refs) {
                        context.put(ref, this.getConstDefValue(ref));
                    }
                    result = ScriptEvaluator.getInstance().evalString(constDefine, context);
                } else if (def.getConstType().equals("3")) {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    for (String ref : refs) {
                        ConstDef r = this.cacheMap.get(ref);
                        String value = this.getConstDefValue(ref);
                        Object valueObj = value;
                        if (r.getConstType().equals("1")) {
                            valueObj = Double.parseDouble(value);
                        } else if (r.getConstType().equals("2")) {
                            // empty if block
                        }
                        context.put("$" + ref, valueObj);
                    }
                    result = ScriptEvaluator.getInstance().eval(constDefine, context);
                }
                constValue = result.toString();
            }
            catch (Exception e) {
                log.error((Object)e);
                constValue = "\u8868\u8fbe\u5f0f\u8ba1\u7b97\u5f02\u5e38";
            }
        } else {
            constValue = constDefine;
        }
        return constValue;
    }

    private Set<String> parserRefKey(String constDefine) {
        HashSet<String> refs = new HashSet<String>();
        try {
            this._parserRefKey(constDefine, 0, refs);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return refs;
    }

    private void _parserRefKey(String constDefine, int fromIndex, Set<String> refs) {
        if (fromIndex > constDefine.length()) {
            return;
        }
        int startIndex = constDefine.indexOf("$", fromIndex);
        if (startIndex == -1 || startIndex == constDefine.length()) {
            return;
        }
        int endIndex = constDefine.indexOf(" ", startIndex + 1);
        if (endIndex == -1 && (endIndex = constDefine.indexOf("$", startIndex + 1)) == -1) {
            endIndex = constDefine.length();
        }
        String key = constDefine.substring(startIndex + 1, endIndex);
        refs.add(key);
        if (endIndex >= constDefine.length()) {
            return;
        }
        this._parserRefKey(constDefine, endIndex + 1, refs);
    }

    @Override
    public void validateFormat(ConstDef def) throws ConstDefException {
        String key = def.getConstKey();
        String define = def.getConstDefine();
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new ConstDefException("\u64cd\u4f5c\u5931\u8d25, \u952e\u4e0d\u7b26\u5408\u683c\u5f0f, \u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (key.contains(" ")) {
            throw new ConstDefException("\u64cd\u4f5c\u5931\u8d25, \u952e\u4e0d\u7b26\u5408\u683c\u5f0f, \u952e\u4e0d\u80fd\u5305\u542b\u7a7a\u683c " + key);
        }
        if (key.contains("$")) {
            throw new ConstDefException("\u64cd\u4f5c\u5931\u8d25, \u952e\u4e0d\u7b26\u5408\u683c\u5f0f, \u952e\u4e0d\u80fd\u5305\u542b$ " + key);
        }
        if (StringUtils.isBlank((CharSequence)define)) {
            throw new ConstDefException("\u64cd\u4f5c\u5931\u8d25, \u5b9a\u4e49\u4e0d\u7b26\u5408\u683c\u5f0f, \u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.refKeyNotExist(define)) {
            throw new ConstDefException("\u64cd\u4f5c\u5931\u8d25, \u5e38\u91cf\u5f15\u7528\u4e0d\u5b58\u5728");
        }
        if (this.refKeyMultiLevel(define)) {
            throw new ConstDefException("\u64cd\u4f5c\u5931\u8d25, \u6682\u4e0d\u652f\u6301, \u4e0d\u652f\u6301\u591a\u7ea7\u5e38\u91cf\u5f15\u7528");
        }
    }

    private boolean refKeyNotExist(String define) {
        Set<String> keys = this.parserRefKey(define);
        for (String k : keys) {
            if (this.cacheMap.containsKey(k)) continue;
            return true;
        }
        return false;
    }

    private boolean refKeyMultiLevel(String define) {
        boolean isMultLevel = false;
        Set<String> keys = this.parserRefKey(define);
        for (String k : keys) {
            Set<String> refBys;
            if (!this.cacheMap.containsKey(k) || (refBys = this.parserRefKey(this.cacheMap.get(k).getConstDefine())).isEmpty()) continue;
            isMultLevel = true;
            break;
        }
        return isMultLevel;
    }

    private ConstDefCacheManager() {
    }

    public static ConstDefCacheManager getInstance() {
        if (instance == null) {
            instance = new ConstDefCacheManager();
            log.debug((Object)"init constdef ====>>>>> ");
            instance.onSystemStartup();
        }
        return instance;
    }
}

