/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.constants;

import com.seeyon.ctp.util.Datetimes;
import java.util.Date;

public enum ProductVersionEnum {
    V3_0("V3.0", "", "2008-01-11", "", ""),
    V3_01("V3.01", "", "2008-04-02", "", ""),
    V3_01SP1("V3.01", "SP1", "2008-05-07", "", ""),
    V3_01SP2("V3.01", "SP2", "2008-06-30", "", ""),
    V3_02("V3.02", "", "2008-09-27", "", ""),
    V3_02SP1("V3.02", "SP1", "2008-11-10", "", ""),
    V3_05("V3.05", "", "2009-02-28", "", ""),
    V3_05SP1("V3.05", "SP1", "2009-04-10", "", ""),
    V3_10("V3.10", "", "2009-09-30", "", ""),
    V3_10SP1("V3.10", "SP1", "2009-12-10", "", ""),
    V3_10sp2("V3.10", "SP2", "2010-01-30", "", ""),
    V3_12("V3.12", "", "2010-05-10", "V5.6", ""),
    V3_12SP1("V3.12", "SP1", "2010-08-30", "V5.7", ""),
    V3_20("V3.20", "", "2011-04-30", "V5.71", ""),
    V3_20SP1("V3.20", "SP1", "2011-06-30", "V5.71", ""),
    V3_50("V3.50", "", "2012-04-30", "V5.72", ""),
    V5_0("V5.0", "", "2013-05-30", "V5.72", ""),
    V5_0SP1("V5.0", "SP1", "2013-08-30", "V5.72", ""),
    V5_0SP2("V5.0", "SP2", "2013-12-30", "V5.72", ""),
    V5_1("V5.1", "", "2014-06-30", "V5.72", ""),
    V5_1SP1("V5.1", "SP1", "2014-09-30", "V5.75", "V12.0"),
    V5_6("V5.6", "", "2015-06-30", "V5.75", "V12.1"),
    V5_6SP1("V5.6", "SP1", "2015-09-30", "V5.80", "V12.1"),
    V6_0("V6.0", "", "2016-06-30", "V5.80", "V12.5"),
    V6_0SP1("V6.0", "SP1", "2016-09-30", "V5.80", "V12.5"),
    V6_1("V6.1", "", "2017-04-30", "V5.80", "V12.5"),
    V6_1SP1("V6.1", "SP1", "2017-08-15", "V5.80", "V12.5"),
    V6_1SP2("V6.1", "SP2", "2017-10-30", "V5.80", "V12.5"),
    V7_0("V7.0", "", "2018-06-30", "V5.80", "V12.5"),
    V7_0SP1("V7.0", "SP1", "2018-07-30", "V5.80", "V12.5"),
    V7_0SP2("V7.0", "SP2", "2018-09-30", "V5.80", "V12.5"),
    V7_0SP3("V7.0", "SP3", "2018-11-30", "V5.80", "V12.5"),
    V7_1("V7.1", "", "2019-03-30", "V5.80", "V12.5"),
    V7_1SP1("V7.1", "SP1", "2019-07-30", "V5.80", "V12.5");

    private static final ProductVersionEnum CurrentVersion;
    private String mainVer;
    private String spVer;
    private String ncVer;
    private Date releaseDate;
    private String u8Ver;

    private ProductVersionEnum(String mainVer, String spVer, String releaseDate, String ncVer, String u8Ver) {
        this.mainVer = mainVer;
        this.spVer = spVer;
        this.releaseDate = Datetimes.parseDate(releaseDate);
        this.ncVer = ncVer;
        this.u8Ver = u8Ver;
    }

    public String getMainVersion() {
        return this.mainVer;
    }

    public String getSpVersion() {
        return this.spVer;
    }

    public String getCanonicalVersion() {
        return this.mainVer + this.spVer;
    }

    public String getOEMVersion(boolean isNC, boolean isU8) {
        if (isNC) {
            return this.ncVer;
        }
        if (isU8) {
            return this.u8Ver;
        }
        return this.mainVer;
    }

    public boolean isCurrentVersion() {
        return this == CurrentVersion;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public static ProductVersionEnum getCurrentVersion() {
        return CurrentVersion;
    }

    static {
        CurrentVersion = V7_1SP1;
    }
}

