/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.config;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PropertiesLoader {
    private static final Log LOGGER = CtpLogFactory.getLog(PropertiesLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' can't be null.");
        }
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("Properties file not exists:" + file.getAbsolutePath());
        }
        String fm = file.getName();
        Properties props = new Properties();
        if (fm.endsWith(".xml")) {
            try {
                SAXReader builder = new SAXReader();
                Document doc = builder.read(file);
                Element root = doc.getRootElement();
                List childrenList = root.elements();
                for (Element child : childrenList) {
                    PropertiesLoader.parseElement(child, "", props);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error parsing XML file:" + file.getAbsolutePath()), (Throwable)e);
            }
        } else if (fm.endsWith(".properties")) {
            FileInputStream is = null;
            Reader reader = null;
            try {
                is = new FileInputStream(file);
                reader = new InputStreamReader((InputStream)is, "utf-8");
                props.load(reader);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error loading properties file:" + file.getAbsolutePath()), (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        } else {
            throw new IllegalArgumentException("Unsupported properties file type:" + file.getAbsolutePath());
        }
        return props;
    }

    private static void parseElement(Element ele, String fkey, Properties props) {
        String name = ele.getName();
        String text = ele.getText();
        String key = fkey;
        List childrenList = ele.elements();
        if (key.length() > 0) {
            key = key + ".";
        }
        key = key + name;
        if (text != null && !"".equals(text.trim()) || childrenList.size() == 0) {
            PropertiesLoader.putProperty(key, text, props);
        }
        List attrList = ele.attributes();
        for (Attribute attr : attrList) {
            String attKey = key + "." + attr.getName();
            String attText = attr.getValue();
            PropertiesLoader.putProperty(attKey, attText, props);
        }
        for (Element child : childrenList) {
            PropertiesLoader.parseElement(child, key, props);
        }
    }

    private static void putProperty(String key, String text, Properties props) {
        if (props.containsKey(key)) {
            String tmp = props.getProperty(key);
            props.put(key, tmp + "|" + text);
        } else {
            props.put(key, text);
        }
    }
}

