/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.redis;

import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.util.SerializableUtil;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class RedisSeeyonEventCodec
implements RedisCodec<String, Event> {
    private static final byte[] EMPTY = new byte[0];
    private StringCodec stringCodec = new StringCodec(Charset.forName("UTF-8"));

    public String decodeKey(ByteBuffer bytes) {
        return this.stringCodec.decodeKey(bytes);
    }

    public Event decodeValue(ByteBuffer bytes) {
        return (Event)SerializableUtil.fstDeserialize(this.getBytes(bytes));
    }

    public ByteBuffer encodeKey(String key) {
        return this.stringCodec.encodeKey(key);
    }

    public ByteBuffer encodeValue(Event event) {
        if (event == null) {
            return ByteBuffer.wrap(EMPTY);
        }
        return ByteBuffer.wrap(SerializableUtil.fstSerialize(event));
    }

    private byte[] getBytes(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (remaining == 0) {
            return EMPTY;
        }
        byte[] b = new byte[remaining];
        buffer.get(b);
        return b;
    }
}

